require 'test_helper'
require 'mail'

class DasMailer < ActionMailer::Base

  def willkommen
    headers ::Message::DO_NOT_SEND_HEADER => true
    mail to: 'me@3scale.net', body: "DIES-IST-EIN-TEST", subject: "HELLO.", from: "me2@3scale.net"
  end

  def nachrichten
    mail to: 'me@3scale.net', body: "DIES-IST-EIN-TEST", subject: "HELLO.", from: "me2@3scale.net"
  end
end

class ThreeScale::EmailDoNotSendInterceptorTest < ActiveSupport::TestCase

  test "action mailer" do
    ActionMailer::Base.deliveries.clear

    DasMailer.willkommen.deliver
    DasMailer.nachrichten.deliver

    assert_equal 1, ActionMailer::Base.deliveries.size
  end

  test "mail deliver" do
    message = Mail.new(to: 'me@3scale.net', body: "DIES-IST-EIN-TEST", subject: "HELLO.", from: "me2@3scale.net")
    message.header[::Message::DO_NOT_SEND_HEADER] = true

    ThreeScale::EmailDoNotSendInterceptor.delivering_email message

    # so, if the message would be sent, this will fail to connect to test SMTP server
    assert message.deliver
  end
end
