require 'test_helper'

class ThreeScale::OAuth2::Auth0ClientTest < ActiveSupport::TestCase

  setup do
    authentication_provider = FactoryGirl.build_stubbed(:authentication_provider)
    @authentication = ThreeScale::OAuth2::Client.build_authentication(authentication_provider)
    @oauth2 = ThreeScale::OAuth2::Auth0Client.new(@authentication)
  end

  def test_callback_url
    base_url     = 'http://alaska.com/auth'
    callback_url = @oauth2.callback_url(base_url)
    assert_equal "#{base_url}/#{@authentication.system_name}/callback", callback_url

    token        = '12345'
    base_url     = 'http://alaska.com/auth/invitations'
    callback_url = @oauth2.callback_url("#{base_url}/#{token}")
    assert_equal "#{base_url}/auth0/#{@authentication.system_name}/callback?state=#{token}", callback_url
  end

  test '#kind' do
    assert_equal 'auth0', @oauth2.kind
  end

  test '#site' do
    @authentication.options.expects(site: 'http://foo.com')
    assert_equal 'http://foo.com', @oauth2.site

    @authentication.options.expects(site: nil)
    assert_equal 'http://example.com', @oauth2.site
  end

  test '#user_data' do
    raw_info = {
      'email' => 'foo@exmaple.com',
      'email_verified' => true,
      'nickname' => 'foo',
      'sub' => 'bar|123',
      'user_id' => 'alaska'
    }

    @oauth2.stubs(:raw_info).returns(raw_info)

    expected_data = {
      email: 'foo@exmaple.com',
      email_confirmed: true,
      username: 'foo',
      uid: 'bar|123',
      org_name: nil,
      kind: 'auth0',
      authentication_id: 'alaska'
    }

    assert_equal expected_data, @oauth2.user_data
  end
end
