/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class DateConverter
implements Converter {
    public Object convert(Class type, Object value) {
        double date;
        if (value == null) {
            throw new ConversionException("No value specified");
        }
        if (value instanceof Double) {
            date = (Double)value;
        } else if (value instanceof Number) {
            date = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            try {
                date = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConversionException((Throwable)e);
            }
        } else {
            if (value instanceof Date) {
                return value;
            }
            throw new ConversionException("No value specified");
        }
        return HSSFDateUtil.getJavaDate((double)date);
    }
}

