/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.tree.TreeUtils;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Key
implements Comparable<Key> {
    public static DumpType DUMP_TYPE = DumpType.BINARY;
    public static boolean DUMP_INT_BINDING = false;
    public static final byte[] EMPTY_KEY = new byte[0];
    private byte[] key;

    public Key(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.key = new byte[key.length];
            System.arraycopy(key, 0, this.key, 0, key.length);
        }
    }

    public static byte[] makeKey(DatabaseEntry dbt) {
        byte[] entryKey = dbt.getData();
        if (entryKey == null) {
            return EMPTY_KEY;
        }
        byte[] newKey = new byte[dbt.getSize()];
        System.arraycopy(entryKey, dbt.getOffset(), newKey, 0, dbt.getSize());
        return newKey;
    }

    public byte[] getKey() {
        return this.key;
    }

    @Override
    public int compareTo(Key argKey) {
        return Key.compareUnsignedBytes(this.key, argKey.key);
    }

    public boolean equals(Object o) {
        return o instanceof Key && this.compareTo((Key)o) == 0;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.key.length; ++i) {
            code += this.key[i];
        }
        return code;
    }

    public static int compareKeys(byte[] key1, byte[] key2, Comparator<byte[]> comparator) {
        if (comparator != null) {
            return comparator.compare(key1, key2);
        }
        return Key.compareUnsignedBytes(key1, key2);
    }

    private static int compareUnsignedBytes(byte[] key1, byte[] key2) {
        int a1Len = key1.length;
        int a2Len = key2.length;
        int limit = Math.min(a1Len, a2Len);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i];
            byte b2 = key2[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return a1Len - a2Len;
    }

    public static int getKeyPrefixLength(byte[] key1, int a1Len, byte[] key2) {
        assert (key1 != null && key2 != null);
        int a2Len = key2.length;
        int limit = Math.min(a1Len, a2Len);
        for (int i = 0; i < limit; ++i) {
            byte b1 = key1[i];
            byte b2 = key2[i];
            if (b1 == b2) continue;
            return i;
        }
        return limit;
    }

    public static byte[] createKeyPrefix(byte[] key1, byte[] key2) {
        int len = Key.getKeyPrefixLength(key1, key1.length, key2);
        if (len == 0) {
            return null;
        }
        byte[] ret = new byte[len];
        System.arraycopy(key1, 0, ret, 0, len);
        return ret;
    }

    public static String dumpString(byte[] key, int nspaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nspaces));
        sb.append("<key v=\"");
        if (DUMP_TYPE == DumpType.BINARY || DUMP_TYPE == DumpType.HEX) {
            if (key == null) {
                sb.append("<null>");
            } else {
                sb.append(DUMP_TYPE.dumpByteArray(key));
            }
        } else if (DUMP_TYPE == DumpType.TEXT) {
            if (DUMP_INT_BINDING) {
                if (key == null) {
                    sb.append("<null>");
                } else {
                    DatabaseEntry e = new DatabaseEntry(key);
                    sb.append(IntegerBinding.entryToInt(e));
                }
            } else {
                sb.append(key == null ? "" : new String(key));
            }
        } else if (DUMP_TYPE == DumpType.OBFUSCATE) {
            int len = key.length;
            sb.append("[").append(len).append(len == 1 ? " byte]" : " bytes]");
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public static String getNoFormatString(byte[] key) {
        return "key=" + Key.dumpString(key, 0);
    }

    public static abstract class DumpType {
        private String name;
        public static final DumpType BINARY = new DumpType("BINARY"){

            void dumpByteArrayInternal(StringBuffer sb, byte[] b) {
                for (int i = 0; i < b.length; ++i) {
                    sb.append(b[i] & 0xFF).append(" ");
                }
            }
        };
        public static final DumpType HEX = new DumpType("HEX"){

            void dumpByteArrayInternal(StringBuffer sb, byte[] b) {
                for (int i = 0; i < b.length; ++i) {
                    sb.append(Integer.toHexString(b[i] & 0xFF)).append(" ");
                }
            }
        };
        public static final DumpType TEXT = new DumpType("TEXT"){

            void dumpByteArrayInternal(StringBuffer sb, byte[] b) {
                sb.append(new String(b));
            }
        };
        public static final DumpType OBFUSCATE = new DumpType("OBFUSCATE"){

            void dumpByteArrayInternal(StringBuffer sb, byte[] b) {
                int len = b.length;
                sb.append("[").append(len).append(len == 1 ? " byte]" : " bytes]");
            }
        };

        private DumpType(String name) {
            this.name = name;
        }

        public String dumpByteArray(byte[] b) {
            StringBuffer sb = new StringBuffer();
            if (b != null) {
                this.dumpByteArrayInternal(sb, b);
            } else {
                sb.append("null");
            }
            return sb.toString();
        }

        public String toString() {
            return this.name;
        }

        abstract void dumpByteArrayInternal(StringBuffer var1, byte[] var2);
    }
}

