/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import org.hornetq.api.core.HornetQException;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.logging.Logger;
import org.hornetq.spi.core.remoting.BufferHandler;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;

class HornetQChannelHandler
extends SimpleChannelHandler {
    private static final Logger log = Logger.getLogger(HornetQChannelHandler.class);
    private final ChannelGroup group;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    volatile boolean active;

    HornetQChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.group.add((Object)e.getChannel());
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelInterestChanged(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.listener.connectionReadyForWrites(e.getChannel().getId(), e.getChannel().isWritable());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        this.handler.bufferReceived(e.getChannel().getId(), new ChannelBufferWrapper(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HornetQChannelHandler hornetQChannelHandler = this;
        synchronized (hornetQChannelHandler) {
            if (this.active) {
                this.listener.connectionDestroyed(e.getChannel().getId());
                this.active = false;
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.active) {
            return;
        }
        HornetQException me = new HornetQException(0, "Netty exception");
        me.initCause(e.getCause());
        ConnectionLifeCycleListener connectionLifeCycleListener = this.listener;
        synchronized (connectionLifeCycleListener) {
            try {
                this.listener.connectionException(e.getChannel().getId(), me);
                this.active = false;
            }
            catch (Exception ex) {
                log.error("failed to notify the listener:", ex);
            }
        }
    }
}

