/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.text;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetUtilities;

public class EditContextMenuWidget
extends LafWidgetAdapter {
    protected JTextComponent textComp;
    protected MouseListener menuMouseListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.textComp = (JTextComponent)jcomp;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void installListeners() {
        this.menuMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            private void handleMouseEvent(MouseEvent e) {
                if (!LafWidgetUtilities.hasTextEditContextMenu(EditContextMenuWidget.this.textComp)) {
                    return;
                }
                if (!e.isPopupTrigger()) {
                    return;
                }
                EditContextMenuWidget.this.textComp.requestFocus(true);
                JPopupMenu editMenu = new JPopupMenu();
                editMenu.add(new CutAction());
                editMenu.add(new CopyAction());
                editMenu.add(new PasteAction());
                editMenu.addSeparator();
                editMenu.add(new DeleteAction());
                editMenu.add(new SelectAllAction());
                Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), EditContextMenuWidget.this.textComp);
                editMenu.show(EditContextMenuWidget.this.textComp, pt.x, pt.y);
            }
        };
        this.textComp.addMouseListener(this.menuMouseListener);
    }

    public void uninstallListeners() {
        this.textComp.removeMouseListener(this.menuMouseListener);
        this.menuMouseListener = null;
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super(LafWidgetUtilities.getResourceBundle(EditContextMenuWidget.this.textComp).getString("EditMenu.copy"), new ImageIcon(EditContextMenuWidget.class.getClassLoader().getResource("org/jvnet/lafwidget/text/edit-copy.png")));
        }

        public void actionPerformed(ActionEvent e) {
            EditContextMenuWidget.this.textComp.copy();
        }

        public boolean isEnabled() {
            return EditContextMenuWidget.this.textComp.isEnabled() && EditContextMenuWidget.this.textComp.getSelectedText() != null;
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super(LafWidgetUtilities.getResourceBundle(EditContextMenuWidget.this.textComp).getString("EditMenu.cut"), new ImageIcon(EditContextMenuWidget.class.getClassLoader().getResource("org/jvnet/lafwidget/text/edit-cut.png")));
        }

        public void actionPerformed(ActionEvent e) {
            EditContextMenuWidget.this.textComp.cut();
        }

        public boolean isEnabled() {
            return EditContextMenuWidget.this.textComp.isEditable() && EditContextMenuWidget.this.textComp.isEnabled() && EditContextMenuWidget.this.textComp.getSelectedText() != null;
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(LafWidgetUtilities.getResourceBundle(EditContextMenuWidget.this.textComp).getString("EditMenu.delete"), new ImageIcon(EditContextMenuWidget.class.getClassLoader().getResource("org/jvnet/lafwidget/text/edit-delete.png")));
        }

        public void actionPerformed(ActionEvent e) {
            EditContextMenuWidget.this.textComp.replaceSelection(null);
        }

        public boolean isEnabled() {
            return EditContextMenuWidget.this.textComp.isEditable() && EditContextMenuWidget.this.textComp.isEnabled() && EditContextMenuWidget.this.textComp.getSelectedText() != null;
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super(LafWidgetUtilities.getResourceBundle(EditContextMenuWidget.this.textComp).getString("EditMenu.selectAll"), new ImageIcon(EditContextMenuWidget.class.getClassLoader().getResource("org/jvnet/lafwidget/text/edit-select-all.png")));
        }

        public void actionPerformed(ActionEvent e) {
            EditContextMenuWidget.this.textComp.selectAll();
        }

        public boolean isEnabled() {
            return EditContextMenuWidget.this.textComp.isEnabled() && EditContextMenuWidget.this.textComp.getText().length() > 0;
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super(LafWidgetUtilities.getResourceBundle(EditContextMenuWidget.this.textComp).getString("EditMenu.paste"), new ImageIcon(EditContextMenuWidget.class.getClassLoader().getResource("org/jvnet/lafwidget/text/edit-paste.png")));
        }

        public void actionPerformed(ActionEvent e) {
            EditContextMenuWidget.this.textComp.paste();
        }

        public boolean isEnabled() {
            if (EditContextMenuWidget.this.textComp.isEditable() && EditContextMenuWidget.this.textComp.isEnabled()) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            return false;
        }
    }
}

