package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.ports.utils.PortUtils;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;
import com.redhat.installer.ports.utils.PortOffset;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * Created by thauser on 3/17/15.
 */
public class Ports extends PostInstallation {

    @Override
    protected Class getClassName() {
        return Ports.class;
    }

    private static final String[] HOST_SERVERS = {"server-one", "server-two", "server-three"};
    private static final String[] HOST_SLAVE_SERVERS = {"server-one", "server-two"};
    private static final String[] HOST_MASTER_SERVERS = {};
    private static final String DOMAIN_MASTER_PORT = "master.domain.port";
    private static final String HOST_MANAGEMENT_NATIVE_PORT = "host.management-native";

    @Override
    protected boolean performOperation() {
        String variablePrefix = arguments[0];
        boolean offset = AutomatedInstallData.getInstance().getRules().isConditionTrue("port.decisionIsAssist");
        String socketGroupName = getSocketGroupName(variablePrefix);
        boolean result;

        if (offset) {
            switch (variablePrefix) {
                case "host-slave":
                    result = configureDomainPortOffsets(HOST_SLAVE_SERVERS) &&
                            writeSlaveSpecificOffsets();
                    break;
                case "host":
                    result = configureDomainPortOffsets(HOST_SERVERS) &&
                            writeInterfacePorts();
                    break;
                case "host-master":
                    result = configureDomainPortOffsets(HOST_MASTER_SERVERS) &&
                            writeInterfacePorts();
                    break;
                default:
                    result = configureStandalonePortOffsets();
                    break;
            }
            printResult(result);
        }
        else {
            result = configurePorts(socketGroupName, variablePrefix);
        }
        return result;
    }

    private static boolean configurePorts(String socketGroupName, String variablePrefix) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        variablePrefix = variablePrefix.startsWith("host") ? "host" : variablePrefix;
        List<String> portVariables = getPortVariablesList(variablePrefix);
        for (String port : portVariables) {
            String bindingName;
            boolean result;
            String remainingVarName = port.substring(variablePrefix.length() + 1);
            String portValue = idata.getVariable(port);
            if (remainingVarName.equals("management-native") && serverCommands.isDomain()) {
                result = serverCommands.writeNativeManagementPort(portValue);
            } else if (remainingVarName.equals("management-http") && serverCommands.isDomain()) {
                if (!serverCommands.isSlave()) {
                    result = serverCommands.writeHttpManagementPort(portValue);
                } else {
                    result = true;
                }
            } else if (remainingVarName.contains(".multicast-port")) {
                bindingName = remainingVarName.replace(".multicast-port", "");
                result = serverCommands.writeSocketBindingMulticastPort(socketGroupName, bindingName, portValue);
            } else if (remainingVarName.contains(".multicast-address")) {
                bindingName = remainingVarName.replace(".multicast-address", "");
                result = serverCommands.writeSocketBindingMulticastAddress(socketGroupName, bindingName, portValue);
            } else {
                result = serverCommands.writeSocketBindingPort(socketGroupName, remainingVarName, portValue);
            }
            if (!result) {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("Ports.failed"), portValue), true);
                return false;
            } else {
                ProcessPanelHelper.printToPanel(mHandler, String.format(idata.langpack.getString("Ports.success"), portValue), false);
            }
        }

        if (serverCommands.isSlave()) {
            String newPort = ""+PortUtils.getPort(idata.getVariable(HOST_MANAGEMENT_NATIVE_PORT));
            serverCommands.writeDomainMasterPort(idata.getVariable(DOMAIN_MASTER_PORT), newPort);
        }

        return true;
    }

    private static String getSocketGroupName(String variablePrefix) {
        if (variablePrefix.equals("domain.full")) {
            return "full-sockets";
        } else if (variablePrefix.equals("domain.h")) {
            return "ha-sockets";
        } else if (variablePrefix.equals("domain.fa")) {
            return "full-ha-sockets";
        } else {
            return "standard-sockets";
        }
    }

    private static List<String> getPortVariablesList(String variablePrefix) {
        List<String> returnList = new ArrayList<String>();
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        Set<String> allVariables = idata.getVariables().stringPropertyNames();
        for (String key : allVariables) {
            if (key.startsWith(variablePrefix) && !(key.endsWith("-1") || key.endsWith("-2")) && !(key.endsWith("-a") || key.endsWith("-b"))) {
                returnList.add(key);
            }
        }
        return returnList;
    }

    private static boolean configureStandalonePortOffsets() {
        String offset = "" + PortOffset.get();
        return serverCommands.writeStandalonePortOffset(offset);
    }

    private static boolean configureDomainPortOffsets(String[] servers) {
        String offset = "" + PortOffset.get();
        return serverCommands.writeDomainPortOffset(offset, servers);
    }
    private static boolean writeInterfacePorts() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        return serverCommands.writeHostInterfacePortOffset("http-interface", idata.getVariable("host.management-http")) &&
        serverCommands.writeHostInterfacePortOffset("native-interface", idata.getVariable("host.management-native"));
    }

    private static boolean writeSlaveSpecificOffsets() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String nativePort = idata.getVariable("host.management-native");
        String masterPort = idata.getVariable("master.domain.port");
        return serverCommands.writeHostInterfacePortOffset("native-interface", nativePort) &&
                serverCommands.writeDomainMasterPortOffset(masterPort);
    }

    private static void printResult(boolean result) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        if(result) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("Ports.offset.success"), false);
        }
        else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("Ports.offset.fail"), true);
        }
    }
}
