/*
Copyright (C) 2017 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package cmd

import (
	"testing"

	"github.com/minishift/minishift/pkg/testing/cli"
	"regexp"
)

func Test_version_output_has_correct_format(t *testing.T) {
	tee := cli.CreateTee(t, false)

	runPrintVersion(nil, nil)

	tee.Close()
	versionString := tee.StdoutBuffer.String()

	versionRegExp := "minishift v[0-9]+\\.[0-9]+\\.[0-9]+\\+[a-z0-9]{7,8}\n"
	match, err := regexp.Match(versionRegExp, []byte(versionString))
	if err != nil {
		t.Fatalf("Unexpected error: %v", err)
	}

	if !match {
		t.Fatalf("Expected version string to match '%s' but '%s' does not.", versionRegExp, versionString)
	}
}
