/*
Copyright (C) 2016 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package util

import (
	"fmt"
	"github.com/docker/machine/libmachine/host"
)

func SetProxyToShellEnv(host *host.Host, shellProxyEnv string) error {
	if _, err := host.RunSSHCommand(fmt.Sprintf("export %s", shellProxyEnv)); err != nil {
		return err
	}
	if _, err := host.RunSSHCommand(fmt.Sprintf(`sudo su -c 'echo "export %s" > /etc/profile.d/proxy.sh'`, shellProxyEnv)); err != nil {
		return err
	}
	return nil
}
