Summary: A dictionary of English words for the /usr/share/dict directory.
Name: words
Version: 3.0
Release: 2.3.gnupro.1
License: public domain
Group: System Environment/Libraries
Source: http://www.dcs.shef.ac.uk/research/ilash/Moby/mwords.tar.Z
URL: http://www.dcs.shef.ac.uk/research/ilash/Moby/
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
%if "%{_arch}" == %{_build_arch}
BuildRequires: ncompress, dos2unix
%endif

%description
The words file is a dictionary of English words for the
/usr/share/dict directory. Some programs use this database of
words to check spelling. Password checkers use it to look for bad
passwords.

%prep
%setup -q -c

%build
cd mwords
dos2unix -o *; chmod a+r *
cat [1-9]*.??? | fgrep -v \'s | egrep  "^[[:alnum:]'&!,./-]+$" | sort --ignore-case --dictionary-order | uniq > moby

cat <<EOF >license.txt
On June 1, 1996 Grady Ward announced that the fruits of
the Moby project were being placed in the public domain:

The Moby lexicon project is complete and has
been place into the public domain. Use, sell,
rework, excerpt and use in any way on any platform.
    
Placing this material on internal or public servers is
also encouraged. The compiler is not aware of any
export restrictions so freely distribute world-wide.
    
You can verify the public domain status by contacting
   
Grady Ward
3449 Martha Ct.
Arcata, CA  95521-4884
    
daedal@myrealbox.com
EOF

%install
install -d $RPM_BUILD_ROOT%{_datadir}/dict
install -m644 mwords/moby $RPM_BUILD_ROOT%{_datadir}/dict/linux.words
ln -sf linux.words $RPM_BUILD_ROOT%{_datadir}/dict/words

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc mwords/readme.txt mwords/license.txt
/usr/share/dict/linux.words
/usr/share/dict/words

%changelog
* Mon May  2 2005  Karel Zak <kzak@redhat.com> 3-2.3
- sort with --dictionary-order
- remove words with possessives ('s)

* Mon Apr  4 2005 Karel Zak <kzak@redhat.com> 3-2.2
- sort with --ignore-case (#147949)

* Fri Nov 05 2004 Adrian Havill <havill@redhat.com> 3-1
- replace word list with much better Moby Project words list (#61395)
- revise %%description; ispell/aspell no longer uses words

* Mon Sep 27 2004 Adrian Havill <havill@redhat.com> 2-23
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Feb  5 2003 Nalin Dahyabhai <nalin@redhat.com> 2-21
- rebuild

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Apr  3 2002 Trond Eivind Glomsrd <teg@redhat.com> 2-18
- Bump.

* Mon Mar 18 2002 Trond Eivind Glomsrd <teg@redhat.com> 2-17
- s/Copyright/License/
- add gullible and facetious (#60166, #60173)

* Fri Apr  6 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add carnivore (#35031)

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jun 13 2000 Trond Eivind Glomsrd <teg@redhat.com>
- use %%{_tmppath}

* Thu Apr 13 2000 Nalin Dahyabhai <nalin@redhat.com>
- add some words: some food additives, dinosaurs, atmospheric terms

* Fri Apr 07 2000 Trond Eivind Glomsrd <teg@redhat.com>
- update description
- moved it to /usr/share/dict
- updated URL

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 12)

* Wed Sep 30 1998 Bill Nottingham <notting@redhat.com>
- take out extra.words (they're all in linux.words)

* Sun Aug 23 1998 Jeff Johnson <jbj@redhat.com>
- correct desiccate (problem #794)

* Tue Aug 11 1998 Jeff Johnson <jbj@redhat.com>
- build root

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Oct 21 1997 Donnie Barnes <djb@redhat.com>
- spec file cleanups

* Tue Sep 23 1997 Erik Troan <ewt@redhat.com>
- made a noarch package
