%{expand: %%global _includedir %{_includedir}/gdbm}

Summary: A GNU set of database routines which use extensible hashing.
Name: gdbm
Version: 1.8.0
Release: 24.gnupro.1
Source: ftp://ftp.gnu.org/gnu/gdbm-%{version}.tar.gz
Patch0: gdbm-1.8.0-jbj.patch
Patch1: gdbm-1.8.0-fhs.patch
Patch2: gdbm-1.8.0-cflags.patch
Patch3: gdbm-1.8.0-64offset.patch
License: GPL
URL: http://www.gnu.org/software/gdbm/
Group: System Environment/Libraries
BuildRoot: %{_tmppath}/%{name}-%{version}-root
%if "%{_arch}" == %{_build_arch}
BuildRequires: libtool
%endif

%description
Gdbm is a GNU database indexing library, including routines which use
extensible hashing.  Gdbm works in a similar way to standard UNIX dbm
routines.  Gdbm is useful for developers who write C applications and
need access to a simple and efficient database or who are building C
applications which will use such a database.

If you're a C developer and your programs need access to simple
database routines, you should install gdbm.  You'll also need to
install gdbm-devel.

%package devel
Summary: Development libraries and header files for the gdbm library.
Group: Development/Libraries
Requires: gdbm = %{version}
%if "%{_arch}" == %{_build_arch}
Prereq: /sbin/install-info
%endif

%description devel
Gdbm-devel contains the development libraries and header files for
gdbm, the GNU database system.  These libraries and header files are
necessary if you plan to do development using the gdbm database.

Install gdbm-devel if you are developing C programs which will use the
gdbm database library.  You'll also need to install the gdbm package.

%prep
%setup -q
%patch0 -p 1 -b .jbj
%patch1 -p 1 -b .fhs
%patch2 -p 1 -b .cflags
%patch3 -p1 -b .offset

%build

libtoolize --force --copy
aclocal
autoreconf
%if "%{_arch}" != %{_build_arch}
LDFLAGS="%{_sysroot_option}" \
%endif
%configure

# We need to override libdir, which for whatever reason is set to $(prefix)/lib
# instead of the value passed to configure above.
make libdir=%{_libdir}

%install
rm -rf ${RPM_BUILD_ROOT}

%makeinstall install-compat

ln -sf gdbm/gdbm.h $RPM_BUILD_ROOT/%{_oldincludedir}/gdbm.h
ln -sf libgdbm.so.2.0.0 $RPM_BUILD_ROOT/%{_libdir}/libgdbm.so

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%if "%{_arch}" == %{_build_arch}
%post devel
/sbin/install-info %{_infodir}/gdbm.info.gz %{_infodir}/dir --entry="* gdbm: (gdbm).                   The GNU Database."

%preun devel
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/gdbm.info.gz %{_infodir}/dir --entry="* gdbm: (gdbm).                   The GNU Database."
fi
%endif

%files
%defattr(-,root,root)
%doc COPYING NEWS README
%{_libdir}/libgdbm.so.*

%files devel
%defattr(-,root,root)
%{_libdir}/libgdbm.so
%{_libdir}/libgdbm.la
%{_libdir}/libgdbm.a
%{_oldincludedir}/gdbm.h
%{_includedir}
%{_infodir}/*.info*
%{_mandir}/man3/*

%clean
rm -rf ${RPM_BUILD_ROOT}

%changelog
* Sun Aug  8 2004 Alan Cox <alan@redhat.com> 1.8.0-24
- Close bug #125319

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Fri Oct  4 2002 Nalin Dahyabhai <nalin@redhat.com> 1.8.0-19
- rebuild

* Fri Sep 13 2002 Nalin Dahyabhai <nalin@redhat.com> 1.8.0-18.1
- run make with libdir overridden so that it has the value passed to configure
  instead of $(prefix)/lib

* Wed Jul 24 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.8.0-18
- Remove cflags for large database support - not compatible 
  with databases without it

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Apr 25 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.8.0-15
- Use 64bit offset
- Patch to make the above not break from downsj@downsj.com (#63980) 

* Tue Feb 26 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.8.0-14
- Rebuild

* Fri Jan 25 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.8.0-13
- Update location
- auto* changes to make it build

* Wed Oct 17 2001 Trond Eivind Glomsrd <teg@redhat.com> 1.8.0-11
- Add URL (# 54607)

* Mon Jun 25 2001 Nalin Dahyabhai <nalin@redhat.com>
- s/Copyright:/License:/g
- include text docs in binary package

* Tue Jun 12 2001 Than Ngo <than@redhat.com>
- fix to build against new libtool

* Mon Mar 19 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Make it respect RPM_OPT_FLAGS/CFLAGS - #32242. 
  Patch from dan@D00M.cmc.msu.ru

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jun  5 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.

* Mon Feb  7 2000 Bill Nottingham <notting@redhat.com>
- handle compressed manpages

* Tue Aug 10 1999 Jeff Johnson <jbj@redhat.com>
- make sure created database header is initialized (#4457).

* Tue Jun  1 1999 Jeff Johnson <jbj@redhat.com>
- update to 1.8.0.
- repackage to include /usr/include/gdbm/*dbm.h compatibility includes.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 19)

* Thu Dec 17 1998 Cristian Gafton <gafton@redhat.com>
- build against glibc 2.1

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Apr 30 1998 Cristian Gafton <gafton@redhat.com>
- gdbm-devel moved to Development/Libraries

* Wed Apr 08 1998 Cristian Gafton <gafton@redhat.com>
- buildroot and built for Manhattan

* Tue Oct 14 1997 Donnie Barnes <djb@redhat.com>
- spec file cleanups

* Thu Jun 12 1997 Erik Troan <ewt@redhat.com>
- built against glibc
