%if %{?WITH_PIE:0}%{!?WITH_PIE:1}
%define WITH_PIE 1
%endif
Summary: The RARP daemon.
Name: rarpd
Version: ss981107
Release: 18.gnupro.1
License: GPL
Group: System Environment/Daemons
Source: ftp://ftp.inr.ac.ru/ip-routing/dhcp.bootp.rarp/rarpd-%{version}.tar.gz
Patch0: rarpd-%{version}.patch
Patch1: rarpd-norun.patch
Patch2: rarpd-initscript.patch
Prereq: /sbin/chkconfig
Buildroot: %{_tmppath}/%{name}-%{version}-root

%description
RARP (Reverse Address Resolution Protocol) is a protocol which allows
individual devices on an IP network to get their own IP addresses from the
RARP server.  Some machines (e.g. SPARC boxes) use this protocol instead
of e.g. DHCP to query their IP addresses during network bootup.
Linux kernels up to 2.2 used to provide a kernel daemon for this service,
but since 2.3 kernels it is served by this userland daemon.

You should install rarpd if you want to set up a RARP server on your
network.

%prep
%setup -q -n rarpd
%patch0 -p1 -b .ss981107
%patch1 -p1 -b .norun
%patch2 -p1 -b .initscript

%build
%ifarch s390 s390x
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%else
export CFLAGS="$RPM_OPT_FLAGS -fpic"
%endif
%if %{WITH_PIE}
export LDFLAGS="-pie"
%endif
make CFLAGS="$CFLAGS" CC="%{__cc}"

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/etc/rc.d/init.d
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8

install -m 755 rarpd.init ${RPM_BUILD_ROOT}/etc/rc.d/init.d/rarpd
install -m 755 rarpd ${RPM_BUILD_ROOT}%{_sbindir}/rarpd
install -m 644 rarpd.8 ${RPM_BUILD_ROOT}%{_mandir}/man8/rarpd.8

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/chkconfig --add rarpd

%preun
if [ "$1" = 0 ] ; then
  service rarpd stop >/dev/null 2>&1
  /sbin/chkconfig --del rarpd
fi

%postun
if [ "$1" -ge "1" ]; then
  service rarpd condrestart >/dev/null 2>&1
fi

%files
%defattr(-,root,root)
%doc README
%config /etc/rc.d/init.d/rarpd
%{_sbindir}/rarpd
%{_mandir}/man8/*

%changelog
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 12 2004 Phil Knirsch <pknirsch@redhat.com> ss981107-17
- Enabled PIE compilation and linking.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Dec 11 2002 Tim Powers <timp@redhat.com> ss981107-13
- rebuild on all arches

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Mar 15 2001 Trond Eivind Glomsrd <teg@redhat.com>
- more generic i18n (#26555)

* Mon Feb  5 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- i18nize init scripts (#26086)

* Thu Aug 17 2000 Jeff Johnson <jbj@redhat.com>
- summaries from specspo.
- typo in init script (#16450).

* Thu Jul 20 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jul 10 2000 Preston Brown <pbrown@redhat.com>
- move initscript, condrestart magic

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.

* Fri Jun 16 2000 Bill Nottingham <notting@redhat.com>
- don't run by default

* Fri Apr  7 2000 Jakub Jelinek <jakub@redhat.com>
- initial package
