%if %{?WITH_PIE:0}%{!?WITH_PIE:1}
%define WITH_PIE 1
%endif
Summary: Traces the route taken by packets over a TCP/IP network.
Name: traceroute
Version: 1.4a12
Release: 24.gnupro.1
License: BSD
Group: Applications/Internet
Source: ftp://ftp.ee.lbl.gov/%{name}-%{version}.tar.bz2
Patch0: traceroute-1.4a5-fix.patch
Patch1: traceroute-1.4a5-secfix.patch
Patch2: traceroute-1.4a5-alpha.patch
Patch3: traceroute-1.4a5-autoroute.patch
Patch4: traceroute-1.4a5-autoroute2.patch
Patch5: traceroute-1.4a5-unaligned.patch
Patch6: traceroute-1.4a5-llanfairpwllgwyngyllgogerychwyrndrobwllllantysiliogogogoch.patch
Patch7: traceroute-1.4a5-fhs.patch
Patch8: traceroute-1.4a5-sourceroute.patch
Patch9: traceroute-1.4a5-aliases.patch
Patch10: traceroute-1.4a5-droproot.patch
Patch11: traceroute-1.4a5-bigpacklen.patch
Patch12: traceroute-1.4a5-lsrr.patch
Patch13: traceroute-1.4a12-sockopt.patch
Patch14: traceroute-1.4a12-sockopt2.patch
Patch15: traceroute-1.4a12-tos-monitoring.patch
Patch16: traceroute-1.4a12-mpls-icmp-02.patch
Patch17: traceroute-1.4a12-pie.patch
URL: ftp://ftp.ee.lbl.gov/
BuildRoot: %{_tmppath}/%{name}-root

%description
The traceroute utility displays the route used by IP packets on their
way to a specified network (or Internet) host.  Traceroute displays
the IP number and host name (if possible) of the machines along the
route taken by the packets.  Traceroute is used as a network debugging
tool.  If you're having network connectivity problems, traceroute will
show you where the trouble is coming from along the route.

Install traceroute if you need a tool for diagnosing network connectivity
problems.

%prep
%setup -q
%patch0 -p1 -b .fix
%patch1 -p1 -b .secfix
#%patch2 -p1 -b .alpha
%patch3 -p1 -b .autoroute
%patch4 -p1 -b .autoroute2
%patch5 -p1 -b .unaligned
%patch6 -p1 -b .hostname
%patch7 -p1 -b .fhs
#%patch8 -p1 -b .sourceroute
%patch9 -p1 -b .aliases
%patch10 -p1 -b .droproot
%patch11 -p1 -b .bigpacklen
%patch12 -p1 -b .lsrr
%patch13 -p1 -b .sockopt
%patch14 -p1 -b .sockopt2
%patch15 -p1 -b .tos-monitoring
%patch16 -p1 -b .mpls-icmp-02
%if %{WITH_PIE}
%patch17 -p1 -b .pie
%endif

%build
rm -f config.sub
cp -f %{_datadir}/libtool/config.sub .
%ifarch s390 s390x
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%else
export CFLAGS="$RPM_OPT_FLAGS -fpic"
%endif
%if %{WITH_PIE}
export LDFLAGS="-pie"
%endif
%configure
make CCOPT="$CFLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p ${RPM_BUILD_ROOT}/bin
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8

make DESTDIR=${RPM_BUILD_ROOT} install install-man

ln -sf /bin/traceroute ${RPM_BUILD_ROOT}%{_sbindir}

# remove sugid apps to get proper debuginfo
chmod 755 ${RPM_BUILD_ROOT}/bin/*

%clean
rm -rf $RPM_BUILD_ROOT
echo %{_prefix}

%files
%defattr(-,root,root)
# this is set as 4555 by make install, which I don't really like
%attr(4755,root,root)	/bin/traceroute
%{_sbindir}/traceroute
%{_mandir}/man8/*

%changelog
* Mon Oct 11 2004 Radek Vokal <rvokal@redhat.com> 1.4a12-24
- spec file updated (#135187)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 12 2004 Phil Knirsch <pknirsch@redhat.com> 1.4a12-22
- Enabled PIE for traceroute.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Sep 01 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-20.1
- rebuilt

* Mon Sep 01 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-20
- Added patch from Jesper Skriver supplied by Kaj J. Niemi to support
  draft-ietf-mpls-icmp-02.txt.

* Thu Aug 28 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- move debuginfo stuff into proper rpms

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue May 13 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-17
- Bumped release and rebuilt

* Tue May 13 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-16
- Moved binary to /bin and symlink to old /usr/sbin place for compatibility.

* Mon May 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-15
- Bumped release and rebuilt

* Mon May 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-14
- Added -t option (#71790).

* Mon May 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-13
- Bumped release and rebuilt

* Mon May 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-12
- Switch to bz2 tarball to save space
- Added URL tag.

* Mon May 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-11
- Bumped release and rebuilt

* Mon May 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-10
- Added symlink to /usr/bin (#18313).

* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 1.4a12-9
- rebuilt

* Wed Jan 08 2003 Phil Knirsch <pknirsch@redhat.com> 1.4a12-8
- Yet another fix for that bug.

* Tue Nov 26 2002 Phil Knirsch <pknirsch@redhat.com> 1.4a12-7
- Added fix for -i option (#78424).

* Fri Jun 21 2002 Tim Powers <timp@redhat.com> 1.4a12-6
- automated rebuild

* Wed Jun 19 2002 Phil Knirsch <pknirsch@redhat.com> 1.4a12-5
- Don't forcibly strip binaries

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 30 2002 Phil Knirsch <pknirsch@redhat.com>
- Bumped version number for rebuild

* Mon Jun 25 2001 Philipp Knirsch <pknirsch@redhat.de>
- Updated to 1.4a12

* Fri Dec  1 2000 Jeff Johnson <jbj@redhat.com>
- use RPM_OPT_FLAGS (#21279).

* Wed Oct  4 2000 Jeff Johnson <jbj@redhat.com>
- check max. packet length correctly (#15917).
- support LSRR correctly (#16281).

* Tue Jul 18 2000 Jeff Johnson <jbj@redhat.com>
- drop root privileges even earlier (#13466).

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jul 10 2000 Preston Brown <pbrown@redhat.com>
- bugfix for segfault with source routing (#13466)
- fix bug tracerouting thru aliased ethernet addresses (#9351)

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging.

* Fri Apr 28 2000 Bill Nottingham <notting@redhat.com>
- fix build with new stricter patch

* Mon Feb  7 2000 Jeff Johnson <jbj@redhat.com>
- compress man pages.

* Fri Jan 14 2000 Bill Nottingham <notting@redhat.com>
- add patch for tracing to really long hostnames

* Thu May 27 1999 Richard Henderson <rth@twiddle.net>
- avoid unaligned traps writing into the output data area.

* Fri May 14 1999 Jeff Johnson <jbj@redhat.com>
- fix segfault when host cannot be reached through if (#2819)

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 14)

* Fri Mar 19 1999 Jeff Johnson <jbj@redhat.com>
- strip binaries.

* Sun Feb 07 1999 Preston Brown <pbrown@redhat.com>
- patch added to automatically determine interface to route through

* Fri Jan 22 1999 Jeff Johnson <jbj@redhat.com>
- use %configure
- fix 64 bit problem on alpha (#919)

* Wed Jan 13 1999 Bill Nottingham <notting@redhat.com>
- configure fix for arm

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Dec 16 1997 Cristian Gafton <gafton@redhat.com>
- updated the security patch (ouch!). Without the glibc fix, it could be
  worthless anyway

* Sat Dec 13 1997 Cristian Gafton <gafton@redhat.com>
- added a security patch fix

* Wed Oct 22 1997 Erik Troan <ewt@redhat.com>
- added fix from Christopher Seawood

* Mon Sep 22 1997 Erik Troan <ewt@redhat.com>
- updated to 1.4a5 for security fixes; release 1 is for RH 4.2, release 2
  is against glibc

* Fri Jul 18 1997 Erik Troan <ewt@redhat.com>
- built against glibc
