Summary: The Linux kernel (the core of the Linux operating system)

# What parts do we want to build?  We must build at least one kernel.
# These are the kernels that are built IF the architecture allows it.

%define FC3 1
%define FC4 0

%define buildup 1
%define buildsmp 1
%define builddoc 0

%define bzImage 1

# Versions of various parts

#
# Polite request for people who spin their own kernel rpms:
# please modify the "release" field in a way that identifies
# that the kernel isn't the stock distribution kernel, for example by
# adding some text to the end of the version number.
#
%define sublevel 11
%define kversion 2.6.%{sublevel}
%define rpmversion 2.6.%{sublevel}
%if "%{_arch}" == %{_build_arch}
%define rhbsys  %([ -r /etc/beehive-root -o -n "%{?__beehive_build}" ] && echo || echo .`whoami`)
%else
%define rhbsys  %(echo )
%endif
%if %{FC3}
%define release 10.1
%endif
%if %{FC4}
%define release %(R="1.773"; RR="${R##: }"; echo ${RR%%?})_FC4%{rhbsys}
%endif
%define signmodules 0
%define make_target bzImage

%define canonical_arch %{_arch}

%define KVERREL %{PACKAGE_VERSION}-%{PACKAGE_RELEASE}

# groups of related archs
%define all_x86 i586 i686
%define all_arm armv4l armv5l

# Override generic defaults with per-arch defaults 

%ifarch noarch
%define builddoc 1
%define buildup 0
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}*.config
%endif

# Second, per-architecture exclusions (ifarch)

%ifarch %{all_x86}
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-i?86*.config
%define image_install_path boot
%define signmodules 1
%endif

%ifarch x86_64
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-x86_64*.config
%define image_install_path boot
%define signmodules 1
%endif

%ifarch ppc64
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ppc64*.config
%define image_install_path boot
%define signmodules 1
%define make_target bzImage zImage.stub
%endif

%ifarch ppc64iseries
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ppc64*.config
%define image_install_path boot
%define signmodules 1
%define make_target bzImage
%endif

%ifarch s390
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-s390*.config
%define image_install_path boot
%endif

%ifarch s390x
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-s390x.config
%define image_install_path boot
%endif

%ifarch sparc
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-sparc.config
%define buildsmp 0
%endif

%ifarch sparc64
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-sparc64*.config
%endif

%ifarch ppc
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ppc*.config
%define buildsmp 1
%define image_install_path boot
%endif

%ifarch ia64
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-ia64.config
%define buildsmp 0
%define image_install_path boot/efi/EFI/redhat
%define signmodules 1
%endif

%ifarch am33_2.0
%define buildsmp 0
%define all_arch_configs $RPM_SOURCE_DIR/kernel-%{kversion}-am33-*.config
%define canonical_arch mn10300
%define image_install_path boot
%define make_target zImage
%define bzImage 0
%endif

#
# Three sets of minimum package version requirements in the form of Conflicts:
# to versions below the minimum
#

#
# First the general kernel 2.6 required versions as per
# Documentation/Changes
#
%define kernel_dot_org_conflicts  ppp <= 2.3.15, pcmcia-cs <= 3.1.20, isdn4k-utils <= 3.0, mount < 2.10r-5, nfs-utils < 1.0.3, e2fsprogs < 1.29, util-linux < 2.10, jfsutils < 1.0.14, reiserfsprogs < 3.6.3, xfsprogs < 2.1.0, procps < 2.0.9, oprofile < 0.5.3

# 
# Then a series of requirements that are distribution specific, either 
# because we add patches for something, or the older versions have 
# problems with the newer kernel or lack certain things that make 
# integration in the distro harder than needed.
#
%define package_conflicts  cipe < 1.4.5, kudzu <= 0.92, initscripts < 7.23, dev < 3.2-7, iptables < 1.2.5-3, bcm5820 < 1.81, nvidia-rh72 <= 1.0, selinux-policy-targeted < 1.17.30-2.94 ipw2200-firmware < 2.2

#
# Several packages had bugs in them that became obvious when the NPTL
# threading code got integrated. 
#
%define nptl_conflicts SysVinit < 2.84-13, pam < 0.75-48, vixie-cron < 3.0.1-73, privoxy < 3.0.0-8, spamassassin < 2.44-4.8.x,  cups < 1.1.17-13

#
# Packages that need to be installed before the kernel is, because the %post
# scripts use them.
#
%define kernel_prereq  fileutils, module-init-tools, initscripts >= 5.83, mkinitrd >= 4.1.15, kernel-utils

Name: kernel
Group: System Environment/Kernel
License: GPLv2
Version: %{rpmversion}
Release: %{release}.gnupro.1
ExclusiveArch: noarch %{all_x86} x86_64 ppc64 ppc mips mipsel %{all_arm} am33_2.0
ExclusiveOS: Linux
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function
AutoReqProv: no
Requires: udev >= 039-10.FC3.7

#
# List the packages used during the kernel build
#
%if "%{_arch}" == %{_build_arch}
BuildPreReq: module-init-tools, patch >= 2.5.4, bash >= 2.03, sh-utils, tar
BuildPreReq: bzip2, findutils, gzip, m4, perl, make >= 3.78, gnupg
BuildRequires: gcc >= 3.4.2, binutils >= 2.12, redhat-rpm-config
%endif
BuildConflicts: rhbuildsys(DiskFree) < 500Mb


Source0: ftp://ftp.kernel.org/pub/linux/kernel/v2.6/linux-%{kversion}.tar.bz2

Source10: COPYING.modules
Source11: genkey

Source20: kernel-%{kversion}-i586.config
Source21: kernel-%{kversion}-i586-smp.config
Source22: kernel-%{kversion}-i686.config
Source23: kernel-%{kversion}-i686-smp.config
Source25: kernel-%{kversion}-x86_64.config
Source26: kernel-%{kversion}-x86_64-smp.config
Source27: kernel-%{kversion}-ppc64.config
Source28: kernel-%{kversion}-ppc64iseries.config
Source29: kernel-%{kversion}-s390.config
Source30: kernel-%{kversion}-s390x.config
#Source31: kernel-%{kversion}-sparc.config
#Source32: kernel-%{kversion}-sparc64.config
#Source33: kernel-%{kversion}-sparc64-smp.config
Source34: kernel-%{kversion}-ppc.config
Source34: kernel-%{kversion}-ppc-smp.config
Source36: kernel-%{kversion}-ia64.config
Source10002: kernel-%{kversion}-am33-asb2303.config

#
# Patches 0 through 100 are meant for core subsystem upgrades
#
Patch1: patch-2.6.11.10.bz2

# Patches 100 through 500 are meant for architecture patches

# 200 - 300   x86(-64)

Patch210: linux-2.6.10-x86-tune-p4.patch
Patch211: linux-2.6.11-x86_64-pmdpud-race.patch
Patch212: linux-2.6.11-x86_64-badpmd-debug.patch
Patch213: linux-2.6.11-x86_64-fault-fix.patch

# 300 - 330   ppc(64)
Patch300: linux-2.6.2-ppc64-build.patch
Patch301: linux-2.6.8-ppc64-netboot.patch
Patch302: linux-2.6.10-ppc-headerabuse.patch

# 330 - 350   ia64
Patch330: linux-2.6.3-ia64-build.patch

# 350 - 400   s390(x)
Patch350: linux-2.6.1-s390-compile.patch
Patch351: linux-2.6.9-s390-autoraid.patch
Patch353: linux-2.6.9-s390-zfcp_port-fix.patch
Patch360: linux-2.6.9-s390-qeth_hipersocket-fix.patch

# 400 - sparc(64)
Patch400: linux-2.6.3-sparc-addbzimage.patch

#
# Patches 500 through 1000 are reserved for bugfixes to the core system
# and patches related to how RPMs are build
#
Patch500: linux-2.4.0-nonintconfig.patch
Patch511: linux-2.6.0-exec-shield.patch
Patch512: linux-2.6.8-print-fatal-signals.patch
Patch513: linux-2.6.8-execshield-vaspace.patch
Patch515: linux-2.6.10-x86_64-read-implies-exec32.patch

Patch530: linux-2.6.0-must_check.patch
# Module signing infrastructure.
Patch600: linux-2.6.7-modsign-core.patch
Patch601: linux-2.6.7-modsign-crypto.patch
Patch602: linux-2.6.7-modsign-ksign.patch
Patch603: linux-2.6.7-modsign-mpilib.patch
Patch604: linux-2.6.7-modsign-script.patch
Patch605: linux-2.6.7-modsign-include.patch
Patch606: linux-2.6.9-sha1.patch

# Tux http accelerator.
Patch700: linux-2.6.11-tux.patch

#
# Patches 1000 to 5000 are reserved for bugfixes to drivers and filesystems
#
Patch1000: linux-2.4.0-test11-vidfail.patch
Patch1010: linux-2.6.10-periodic-slab-debug.patch
Patch1020: linux-2.6.4-stackusage.patch

Patch1050: linux-2.6.12-devmem.patch
Patch1051: linux-2.6.11-devmem.patch

Patch1060: linux-2.6.3-crash-driver.patch
Patch1070: linux-2.6.0-sleepon.patch

# SCSI bits.
Patch1130: linux-2.6.10-scsi-blacklist.patch
Patch1131: linux-2.6.9-scsi-advansys-enabler.patch
Patch1132: linux-2.6.11-scsi-st_ioctl-CAP_ADMIN.patch
Patch1133: linux-2.6.11-scsi-queue-lock.patch
Patch1134: linux-2.6.11-scsi-aacraid-openoops.patch
Patch1136: linux-2.6.9-scsi-megaraid-legacy.patch


# NFS bits.
Patch1201: linux-2.6.9-NFSD-non-null-getxattr.patch
Patch1207: linux-2.6.8-lockd-racewarn2.patch
Patch1209: linux-2.6.9-lockd-block-nosleep.patch
Patch1210: linux-2.6.9-lockd-reclaims.patch

Patch1300: linux-2.6.11-net-conntrack-leak.patch

# NIC driver updates
Patch1351: linux-2.6.9-net-tr-irqlock-fix.patch
Patch1362: linux-2.6.9-net-airo-nullptr.patch

# USB bits
Patch1400: linux-2.6.10-usb-use_both_schemes.patch
Patch1401: linux-2.6.11-usb-aggressive-init-retry.patch

# Netdump and Diskdump bits.
Patch1500: linux-2.6.10-crashdump-common.patch
Patch1501: linux-2.6.10-netdump.patch
Patch1502: linux-2.6.8-netconsole.patch
Patch1503: linux-2.6.10-diskdump.patch

# Misc bits.
Patch1700: linux-2.6.10-revert-module-invalidparam.patch
Patch1710: linux-2.6.11-panic-stackdump.patch
Patch1720: linux-2.6.10-ac11-firewire-fixes.patch
Patch1740: linux-2.6.11-default-elevator.patch
Patch1760: linux-2.6.9-module_version.patch
Patch1910: linux-2.6.9-spinlock-debug-panic.patch

Patch2000: linux-2.6.11-vm-taint.patch
Patch2003: linux-2.6.9-vm-oomkiller-debugging.patch

Patch2100: linux-2.6.11-ide-acfixes.patch

Patch2999: linux-2.6.3-printopen.patch

#
# External drivers that are about to get accepted upstream
#

# PWC webcam driver
Patch3000: linux-2.6.11-pwc.patch

# Intel Centrino wireless drivers.
Patch3020: linux-2.6.9-ipw2100.patch
Patch3021: linux-2.6.9-ipw2200.patch
Patch3022: linux-2.6.9-ieee80211.patch

#
# 10000 to 20000 is for stuff that has to come last due to the
# amount of drivers they touch. But only these should go here. 
# Not patches you're too lazy for to put in the proper place.
#

Patch10000: linux-2.6.0-compile.patch
Patch10001: linux-2.6.10-compile-fixes.patch
Patch10002: linux-2.6.11-compile-fixes.patch

Patch20010: linux-2.6.11-am33.patch
# Phase 2 AM33 patch
Patch20012: linux-2.6.11-am33-2.patch

# END OF PATCH DEFINITIONS

BuildRoot: %{_tmppath}/kernel-%{KVERREL}-root

%description 
The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system:  memory allocation, process allocation, device
input and output, etc.

%package doc
Summary: Various documentation bits found in the kernel source.
Group: Documentation

%description doc
This package contains documentation files from the kernel
source. Various bits of information about the Linux kernel and the
device drivers shipped with it are documented in these files. 

You'll want to install this package if you need a reference to the
options that can be passed to Linux kernel modules at load time.


%package smp
Summary: The Linux kernel compiled for SMP machines.

Group: System Environment/Kernel
Provides: kernel = %{version}
Provides: kernel-drm = 4.3.0
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}
# upto and including kernel 2.4.9 rpms, the 4Gb+ kernel was called kernel-enterprise
# now that the smp kernel offers this capability, obsolete the old kernel
Obsoletes: kernel-enterprise < 2.4.10
# We can't let RPM do the dependencies automatic because it'll then pick up
# a correct but undesirable perl dependency from the module headers which
# isn't required for the kernel proper to function
AutoReqProv: no

%description smp
This package includes a SMP version of the Linux kernel. It is
required only on machines with two or more CPUs as well as machines with
hyperthreading technology.

Install the kernel-smp package if your machine uses two or more CPUs.

%prep

%setup -q -n %{name}-%{version} -c
cd linux-%{kversion}

#
# Patches 0 through 100 are meant for core subsystem upgrades
# 
%patch1 -p1

#
# Patches to back out
#

#
# Architecture patches
#

#
# x86(-64)
#
%if "%{_arch}" == %{_build_arch}
# Compile 686 kernels tuned for Pentium4.
%patch210 -p1
# x86_64: Only free PMDs and PUDs after other CPUs have been flushed
%patch211 -p1
# Debug the bad pmd problem.
%patch212 -p1
# Fix bugs in x86-64's fault handler.
%patch213 -p1

# 
# ppc64
#

# Patch for Kconfig and Makefile build issues
%patch300 -p1
%patch301 -p1
%patch302 -p1

#
# ia64
#

# Basic build fixes
%patch330 -p1


#
# s390
#

# Basic build fixes
%patch350 -p1
# Auto raidstart for S390
%patch351 -p1
# Recover after aborted nameserver request.
%patch353 -p1
# Support broadcast on z800/z900 HiperSockets
%patch360 -p1

#
# sparc/sparc64
#
%patch400 -p1
%endif

#
# Patches 500 through 1000 are reserved for bugfixes to the core system
# and patches related to how RPMs are build
#


# This patch adds a "make nonint_oldconfig" which is non-interactive and
# also gives a list of missing options at the end. Useful for automated
# builds (as used in the buildsystem).
%patch500 -p1


%if "%{_arch}" == %{_build_arch}
#
# The execshield patch series, broken into smaller pieces
#
# 1) Exec shield core
%patch511 -p1

# 2) Option to printk fatal signals, useful for debugging
%patch512 -p1

# 3) The Execshield VA rearrangements
%patch513 -p1

# 4) Revert x86-64 read-implies-exec on 32 bit processes.
%patch515 -p1 -R

#
# Patch that adds a __must_check attribute for functions for which checking
# the return value is mantadory (eg copy_from_user)
#
%patch530 -p1

#
# GPG signed kernel modules
#
%patch600 -p1
%patch601 -p1
%patch602 -p1
%patch603 -p1
%patch604 -p1
%patch605 -p1
%patch606 -p1

# Tux
%patch700 -p1

#
# Patches 1000 to 5000 are reserved for bugfixes to drivers and filesystems
#


# add vidfail capability; 
# without this patch specifying a framebuffer on the kernel prompt would
# make the boot stop if there's no supported framebuffer device; this is bad
# for the installer cd that wants to automatically fall back to textmode
# in that case
%patch1000 -p1

# Periodically scan slab caches for corruption.
%patch1010 -p1

#
# Fix the extreme stack usage in some kernel functions
#
%patch1020 -p1

#
# Make /dev/mem a need-to-know function 
#
%patch1050 -p1
%patch1051 -p1

#
# /dev/crash driver for the crashdump analysis tool
#
%patch1060 -p1

#
# Most^WAll users of sleep_on are broken; fix a bunch
#
%patch1070 -p1

#
# SCSI Bits.
#
# Blacklist some device
%patch1130 -p1
# Enable Advansys driver
%patch1131 -p1
# SCSI tape security: require CAP_ADMIN for SG_IO etc.
%patch1132 -p1
# Improved blkdev queue locking.
%patch1133 -p1
# fix oops in open when using adaptec tools.
%patch1134 -p1
# Enable both new and old megaraid drivers.
%patch1136 -p1

#
# Various upstream NFS/NFSD fixes.
#
%patch1201 -p1
%patch1207 -p1
%patch1209 -p1
%patch1210 -p1

# Fix conntrack leak with raw sockets.
%patch1300 -p1

# NIC driver fixes.
# Use correct spinlock functions in token ring net code
%patch1351 -p1
# NULL out ptrs in airo after kfree'ing them.
%patch1362 -p1

# USB Bits.
# Enable both old and new style USB initialisation.
%patch1400 -p1
# Retry more aggressively during USB device initialization
%patch1401 -p1

# netdump bits
%patch1500 -p1
%patch1501 -p1
%patch1502 -p1
%patch1503 -p1

#
# Various SELinux fixes from 2.6.10rc
#

# Misc fixes
# Don't barf on obsolete module parameters.
%patch1700 -p1
# Print stack trace when we panic.
%patch1710 -p1
# Various fixes for firewire from -mm
%patch1720 -p1
# Set CFQ as default elevator
%patch1740 -p1
# Add missing MODULE_VERSION tags to some modules.
%patch1760 -p1
# Make spinlock debugging panic instead of continue.
%patch1910 -p1

#
# VM related fixes.
#
# Display taint bits on VM error.
%patch2000 -p1
# Extra debugging on OOM Kill.
%patch2003 -p1

# IDE bits.
# Numerous fixes from 2.6.11-ac7
%patch2100 -p1

#
# Local hack (off for any shipped kernels) to printk all files opened 
# the first 180 seconds after boot for debugging userspace startup 
# speeds
#
# %patch2999 -p1

#
# External drivers that are about to get accepted upstream
#

# PWC driver
%patch3000 -p1

# Intel wireless
%patch3020 -p1
%patch3021 -p1
%patch3022 -p1

#
# Patches 5000 to 6000 are reserved for new drivers that are about to
# be merged upstream
#


#
# final stuff
#

#
# misc small stuff to make things compile or otherwise improve performance
#
%patch10000 -p1
%patch10001 -p1
%patch10002 -p1
%endif

# AM33 (MN10300) specific patches
%ifarch am33_2.0
%patch20010 -p1
%patch20012 -p1
rm GNUmakefile
%endif

# END OF PATCH APPLICATIONS

cp %{SOURCE10} Documentation/

mkdir configs

cp -fv %{all_arch_configs} .


# now run oldconfig over all the config files
for i in *.config 
do 
	mv $i .config 
	Arch=`head -1 .config | cut -b 3-`
	make ARCH=$Arch nonint_oldconfig > /dev/null
	echo "# $Arch" > configs/$i
	cat .config >> configs/$i 
done

# make sure the kernel has the sublevel we know it has. This looks weird
# but for -pre and -rc versions we need it since we only want to use
# the higher version when the final kernel is released.
perl -p -i -e "s/^SUBLEVEL.*/SUBLEVEL = %{sublevel}/" Makefile
perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -prep/" Makefile

# get rid of unwanted files resulting from patch fuzz
find . -name "*.orig" -exec rm -fv {} \;
find . -name "*~" -exec rm -fv {} \;

###
### build
###
%build

#
# Create gpg keys for signing the modules
#

%if %{signmodules}
gpg --homedir . --batch --gen-key %{SOURCE11}  
gpg --homedir . --export --keyring ./kernel.pub Red > extract.pub 
#rm /tmp/pubring.gpg /tmp/secring.gpg /tmp/random_seed
rm ./pubring.gpg ./secring.gpg ./random_seed
make linux-%{kversion}/scripts/bin2c
linux-%{kversion}/scripts/bin2c ksign_def_public_key __initdata < extract.pub > linux-%{kversion}/crypto/signature/key.h
%endif

cd linux-%{kversion}



BuildKernel() {

    # Pick the right config file for the kernel we're building
    if [ -n "$1" ] ; then
	Config=kernel-%{kversion}-%{_target_cpu}-$1.config
    else
	Config=kernel-%{kversion}-%{_target_cpu}.config
    fi
%ifarch am33_2.0
    if [ -n "$1" ] ; then
	Config=$1.config
    else
	Config=kernel-%{kversion}-am33-asb2303.config
    fi
%endif

    KernelVer=%{version}-%{release}$1
    echo BUILDING A KERNEL FOR $1 %{_target_cpu}...

    # make sure EXTRAVERSION says what we want it to say
    perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = -%{release}$1/" Makefile

    # and now to start the build process

    make -s mrproper
    cp configs/$Config .config

    Arch=`head -1 .config | cut -b 3-`
    echo USING ARCH=$Arch

%if "%{_arch}" != %{_build_arch}
    make -s ARCH=$Arch CROSS_COMPILE=%{_target_platform}- nonint_oldconfig > /dev/null
    make -s ARCH=$Arch CROSS_COMPILE=%{_target_platform}- include/linux/version.h 

    make -s ARCH=$Arch CROSS_COMPILE=%{_target_platform}- %{?_smp_mflags} %{make_target}
    make -s ARCH=$Arch CROSS_COMPILE=%{_target_platform}- %{?_smp_mflags} modules || exit 1
#    make ARCH=$Arch CROSS_COMPILE=%{_target_platform}- buildcheck
%else
    make -s ARCH=$Arch nonint_oldconfig > /dev/null
    make -s ARCH=$Arch include/linux/version.h 

    make -s ARCH=$Arch %{?_smp_mflags} %{make_target}
    make -s ARCH=$Arch %{?_smp_mflags} modules || exit 1
%endif
    
    # Start installing the results

    mkdir -p $RPM_BUILD_ROOT/usr/lib/debug/boot
    mkdir -p $RPM_BUILD_ROOT/%{image_install_path}
    install -m 644 .config $RPM_BUILD_ROOT/boot/config-$KernelVer
    install -m 644 System.map $RPM_BUILD_ROOT/boot/System.map-$KernelVer
%if "%{_arch}" != %{_build_arch}
    # Since we can't run /sbin/depmod, we have to do this by hand.
    %{__objdump} -t vmlinux | grep ksymtab | cut -f2 | cut -d" " -f2 | cut -c11- | sort -u  > exported
    echo "_stext" >> exported
    echo "_end" >> exported
    touch $RPM_BUILD_ROOT/boot/System.map-$KernelVer
    for i in `cat exported` 
    do 
	 grep " $i\$" System.map >> $RPM_BUILD_ROOT/boot/System.map-$KernelVer || :
	 grep "tab_$i\$" System.map >> $RPM_BUILD_ROOT/boot/System.map-$KernelVer || :
	 grep "__crc_$i\$" System.map >> $RPM_BUILD_ROOT/boot/System.map-$KernelVer ||:
    done
    rm -f exported
    rm -f System.map
%endif
%if %{bzImage}
    cp arch/$Arch/boot/bzImage $RPM_BUILD_ROOT/%{image_install_path}/vmlinuz-$KernelVer
    cp arch/$Arch/boot/zImage.stub $RPM_BUILD_ROOT/%{image_install_path}/zImage.stub-$KernelVer || :
%else
    cp arch/$Arch/boot/%{make_target} $RPM_BUILD_ROOT/%{image_install_path}/%{make_target}-$KernelVer
%endif

    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer
%if "%{_arch}" != %{_build_arch}
    make -s ARCH=$Arch CROSS_COMPILE=%{_target_platform}- INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install KERNELRELEASE=$KernelVer
%else
    make -s ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install KERNELRELEASE=$KernelVer
%endif
    # And save the headers/makefiles etc for building modules against
    #
    # This all looks scary, but the end result is supposed to be:
    # * all arch relevant include/ files
    # * all Makefile/Kconfig files
    # * all script/ files 

    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/source
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    (cd $RPM_BUILD_ROOT/lib/modules/$KernelVer ; ln -s build source)
    # first copy everything
    cp --parents `find  -type f -name Makefile -o -name "Kconfig*"` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build 
    cp Module.symvers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    # then drop all but the needed Makefiles/Kconfig files
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Documentation
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts
    rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cp arch/%{canonical_arch}/kernel/asm-offsets.s $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{canonical_arch}/kernel || :
    cp .config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp -a scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    cp -a arch/%{canonical_arch}/scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{canonical_arch} || :
    cp -a arch/%{canonical_arch}/*lds $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{canonical_arch}/ || :
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*.o
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*/*.o
%if "%{_arch}" != %{_build_arch}
    # Remove all host exes
    exes="basic/fixdep
	basic/docproc
	basic/split-include
	bin2c
	conmakehash
	genksyms/genksyms
	kallsyms
	kconfig/conf
	kconfig/libkconfig.so
	mod/mk_elfconfig
	mod/modpost
	pnmtologo"
    for exe in $exes
    do
        rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/$exe
    done
%endif
    mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cd include
    cp -a acpi config linux math-emu media net pcmcia rxrpc scsi sound video asm asm-generic $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    cp -a `readlink asm` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
    # Make sure the Makefile and version.h have a matching timestamp so that
    # external modules can be built
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Makefile $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/version.h
    touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/autoconf.h
    cd .. 

    #
    # save the vmlinux file for kernel debugging into the kernel-debuginfo rpm
    #
    mkdir -p $RPM_BUILD_ROOT/usr/lib/debug/lib/modules/$KernelVer
    cp vmlinux $RPM_BUILD_ROOT/usr/lib/debug/lib/modules/$KernelVer

    # gpg sign the modules
%if %{signmodules}
    gcc -o scripts/modsign/mod-extract scripts/modsign/mod-extract.c -Wall
	KEYFLAGS="--no-default-keyring --homedir .." 
	KEYFLAGS="$KEYFLAGS --secret-keyring ../kernel.sec" 
	KEYFLAGS="$KEYFLAGS --keyring ../kernel.pub" 
	export KEYFLAGS 
    for i in ` find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f` ; do
	sh ./scripts/modsign/modsign.sh $i Red
        mv -f $i.signed $i
    done
	unset KEYFLAGS
%endif

    # mark modules executable so that strip-to-file can strip them
%if "%{_arch}" == %{_build_arch}
    find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f  | xargs chmod u+x
%else
    # This works in the case where modules might or might not exist.
    for i in `find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f`; do chmod u+x $i ; done
%endif

    # detect missing or incorrect license tags
    for i in `find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" ` ; do echo -n "$i " ; /sbin/modinfo -l $i >> modinfo ; done
    cat modinfo | grep -v "^GPL" | grep -v "^Dual BSD/GPL" | grep -v "^Dual MPL/GPL" | grep -v "^GPL and additional rights" | grep -v "^GPL v2" && exit 1 
    rm -f modinfo
    # remove files that will be auto generated by depmod at rpm -i time
    rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.*

}

###
# DO it...
###

# prepare directories
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/boot

%if %{buildup}
BuildKernel
%endif

%if %{buildsmp}
BuildKernel smp
%endif

###
### install
###

%install

cd linux-%{kversion}

%if %{builddoc}
mkdir -p $RPM_BUILD_ROOT/usr/share/doc/kernel-doc-%{kversion}/Documentation

# sometimes non-world-readable files sneak into the kernel source tree
chmod -R a+r *
# copy the source over
tar cf - Documentation | tar xf - -C $RPM_BUILD_ROOT/usr/share/doc/kernel-doc-%{kversion}
%endif

###
### clean
###

%clean
rm -rf $RPM_BUILD_ROOT

###
### scripts
###

# load the loop module for upgrades...in case the old modules get removed we have
# loopback in the kernel so that mkinitrd will work.
%pre 
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
exit 0

%pre smp
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
exit 0

%post 
[ ! -x /usr/sbin/module_upgrade ] || /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel --mkinitrd --depmod --install %{KVERREL}

%post smp
[ ! -x /usr/sbin/module_upgrade ] || /usr/sbin/module_upgrade
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --package kernel-smp --mkinitrd --depmod --install %{KVERREL}smp


%preun 
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}

%preun smp
/sbin/modprobe loop 2> /dev/null > /dev/null  || :
[ -x /sbin/new-kernel-pkg ] && /sbin/new-kernel-pkg --rminitrd --rmmoddep --remove %{KVERREL}smp


###
### file lists
###

%if %{buildup}
%files 
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}
/boot/System.map-%{KVERREL}
/boot/config-%{KVERREL}
%dir /lib/modules/%{KVERREL}
/lib/modules/%{KVERREL}/kernel
%verify(not mtime) /lib/modules/%{KVERREL}/build
%endif

%if %{buildsmp}
%files smp
%defattr(-,root,root)
/%{image_install_path}/*-%{KVERREL}smp
/boot/System.map-%{KVERREL}smp
/boot/config-%{KVERREL}smp
%dir /lib/modules/%{KVERREL}smp
/lib/modules/%{KVERREL}smp/kernel
%verify(not mtime) /lib/modules/%{KVERREL}smp/build
%endif


# only some architecture builds need kernel-doc

%if %{builddoc}
%files doc
%defattr(-,root,root)
/usr/share/doc/kernel-doc-%{kversion}/Documentation/*
%endif

%changelog
* Tue May 17 2005 Dave Jones <davej@redhat.com>
- Remove the unused (and outdated) Xen patches from the FC3 tree.

* Mon May 16 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11.10, (fixing CAN-2005-1264)

* Thu May 12 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11.9, (fixing CAN-2005-1263)

* Tue May 10 2005 Dave Jones <davej@redhat.com>
- Fix two bugs in x86-64 page fault handler.

* Mon May  9 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11.8
  | Fixes CAN-2005-1368 (local DoS in key lookup). (#156680)
  | Fixes CAN-2005-1369 (i2c alarms sysfs DoS). (#156683)
- Merge IDE fixes from 2.6.11-ac7
- Add Conflicts for older IPW firmwares.
- Fix conntrack leak with raw sockets.

* Sun May  1 2005 Dave Jones <davej@redhat.com>
- Various firewire fixes backported from -mm. (#133798)
  (Thanks to Jody McIntyre for doing this)

* Fri Apr 29 2005 Dave Jones <davej@redhat.com>
- fix oops in aacraid open when using adaptec tools. (#148761)
- Blacklist another brainless SCSI scanner. (#155457)

* Thu Apr 21 2005 Dave Jones <davej@redhat.com>
- Fix up SCSI queue locking. (#155472)

* Tue Apr 19 2005 Dave Jones <davej@redhat.com>
- SCSI tape security: require CAP_ADMIN for SG_IO etc. (#155355)

* Mon Apr 18 2005 Dave Jones <davej@redhat.com>
- Retry more aggressively during USB device initialization

* Thu Apr 14 2005 Dave Jones <davej@redhat.com>
- Build DRM modular. (#154769)

* Fri Apr  8 2005 Dave Jones <davej@redhat.com>
- Disable Longhaul driver (again).

* Thu Apr  7 2005 Dave Jones <davej@redhat.com> [2.6.11-1.14_FC3]
- Update to 2.6.11.7
- Set CFQ as default elevator again.

* Wed Apr  5 2005 Dave Jones <davej@redhat.com>
- Disable slab debug.
- Re-add the pwc driver. (#152593)

* Wed Mar 30 2005 Dave Jones <davej@redhat.com>
- x86_64: Only free PMDs and PUDs after other CPUs have been flushed

* Sat Mar 26 2005 Dave Jones <davej@redhat.com>
- Update to 2.6.11.6

* Tue Mar 22 2005 Dave Jones <davej@redhat.com>
- Fix up several calls to memset with swapped arguments.

* Sat Mar 19 2005 Dave Jones <davej@redhat.com>
- Update to 2.6.11.5

* Fri Mar 18 2005 Dave Jones <davej@redhat.com>
- Kjournald oops race. (#146344)

* Tue Mar 15 2005 Dave Jones <davej@redhat.com>
- Update to 2.6.11.4

* Thu Mar 10 2005 Dave Jones <davej@redhat.com>
- Update to 2.6.11.2
- Reenable advansys driver for x86

* Sun Mar  6 2005 Dave Jones <davej@redhat.com> [2.6.11-1.1_FC3]
- FC3 build.

* Fri Mar  4 2005 Dave Jones <davej@redhat.com>
- Fix up ACPI vs keyboard controller problem.
- Fix up Altivec usage on PPC/PPC64.

* Fri Mar  4 2005 Dave Jones <davej@redhat.com>
- Finger the programs that try to read from /dev/mem.
- Improve spinlock debugging a little.

* Thu Mar  3 2005 Dave Jones <davej@redhat.com>
- Fix up the unresolved symbols problem.

* Thu Mar  3 2005 Rik van Riel <riel@redhat.com>
- upgrade to new Xen snapshot (requires new xen RPM, too)

* Wed Mar  2 2005 Dave Jones <davej@redhat.com>
- 2.6.11

* Tue Mar 1 2005 David Woodhouse <dwmw2@redhat.com>
- Building is nice. Booting would be better. Work around GCC -Os bug which
  which makes the PPC kernel die when extracting its initramfs. (#150020)
- Update include/linux/compiler-gcc+.h

* Tue Mar 1 2005 Dave Jones <davej@redhat.com>
- 802.11b/ipw2100/ipw2200 update.
- 2.6.11-rc5-bk4

* Tue Mar 1 2005 David Woodhouse <dwmw2@redhat.com>
- Fix ppc/ppc64/ppc64iseries builds for gcc 4.0
- Fix Xen build too

* Mon Feb 28 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc5-bk3
- Various compile fixes for building with gcc-4.0

* Sat Feb 26 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc5-bk1

* Fri Feb 25 2005 Dave Jones <davej@redhat.com>
- Hopefully fix the zillion unresolved symbols. (#149758)

* Thu Feb 24 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc5

* Wed Feb 23 2005 Rik van Riel <riel@redhat.com>
- get rid of unknown symbols in kernel-xen0 (#149495)

* Wed Feb 23 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk11

* Mon Feb 21 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk9

* Sat Feb 19 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk7

* Sat Feb 19 2005 Rik van Riel <riel@redhat.com>
- upgrade to newer Xen code, needs xen-20050218 to run

* Sat Feb 19 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk6

* Fri Feb 18 2005 David Woodhouse <dwmw2@redhat.com>
- Add SMP kernel for PPC32

* Fri Feb 18 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk5

* Tue Feb 15 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk3

* Mon Feb 14 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk2

* Sun Feb 13 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4-bk1

* Sat Feb 12 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc4

* Fri Feb 11 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc3-bk8

* Thu Feb 10 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc3-bk7

* Wed Feb  9 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc3-bk6

* Tue Feb  8 2005 Dave Jones <davej@redhat.com>
- Enable old style and new style USB initialisation.
- More PPC jiggery pokery hackery.
- 2.6.11-rc3-bk5

* Mon Feb  7 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc3-bk4
- Various patches to unbork PPC.
- Display taint bits on VM error.

* Mon Feb  7 2005 Rik van Riel <riel@redhat.com>
- upgrade to latest upstream Xen bits, upgrade those to 2.6.11-rc3-bk2

* Sat Feb  5 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc3-bk2

* Fri Feb  4 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc3-bk1

* Wed Feb  2 2005 Dave Jones <davej@redhat.com>
- Stop the input layer spamming the console. (#146906)
- 2.6.11-rc3

* Tue Feb  1 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc2-bk10
- Reenable periodic slab checker.

* Tue Feb  1 2005 Rik van Riel <riel@redhat.com>
- update to latest xen-unstable source snapshot
- add agpgart patch from upstream xen tree
- port Ingo's latest execshield updates to Xen

* Mon Jan 31 2005 Rik van Riel <riel@redhat.com>
- enable SMP support in xenU kernel, use the xen0 kernel for the
  unprivileged domains if the SMP xenU breaks on your system

* Thu Jan 27 2005 Dave Jones <davej@redhat.com>
- Drop VM hack that broke in yesterdays rebase.

* Wed Jan 26 2005 Dave Jones <davej@redhat.com>
- Drop 586-SMP kernels.  These are a good candidate for
  fedora-extras when it appears. The number of people
  actually using this variant is likely to be very very small.
- 2.6.11-rc2-bk4

* Tue Jan 25 2005 Dave Jones <davej@redhat.com>
- 2.6.11-rc2-bk3

* Sun Jan 23 2005 Dave Jones <davej@redhat.com>
- Updated periodic slab debug check from Manfred.
- Enable PAGE_ALLOC debugging again, it should now be fixed.
- 2.6.11-rc2-bk1

* Fri Jan 21 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11-rc2

* Fri Jan 21 2005 Rik van Riel <riel@redhat.com>
- make exec-shield segment limits work inside the xen kernels

* Thu Jan 20 2005 Dave Jones <davej@redhat.com>
- Rebase to -bk8

* Wed Jan 19 2005 Dave Jones <davej@redhat.com>
- Re-add diskdump/netdump based on Jeff Moyers patches.
- Rebase to -bk7

* Tue Jan 18 2005 Jeremy Katz <katzj@redhat.com>
- fixup xen0 %%post to use new grubby features for multiboot kernels
- conflict with older mkinitrd for kernel-xen0

* Tue Jan 18 2005 Dave Jones <davej@redhat.com>
- -bk6

* Mon Jan 17 2005 Dave Jones <davej@redhat.com>
- First stab at kernel-devel packages. (David Woodhouse).

* Mon Jan 17 2005 Rik van Riel <riel@redhat.com>
- apply dmi fix, now xenU boots again

* Fri Jan 14 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11-bk2

* Thu Jan 13 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11-bk1

* Wed Jan 12 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.11rc1

* Tue Jan 11 2005 Rik van Riel <riel@redhat.com>
- fix Xen compile with -bk14

* Tue Jan 11 2005 Dave Jones <davej@redhat.com>
- Update to -bk14
- Print tainted information in slab corruption messages.

* Tue Jan 11 2005 Rik van Riel <riel@redhat.com>
- merge fix for the Xen TLS segment fixup issue

* Tue Jan 11 2005 Dave Jones <davej@redhat.com>
- Depend on hardlink, not kernel-utils.

* Mon Jan 10 2005 Dave Jones <davej@redhat.com>
- Update to -bk13, reinstate GFP_ZERO patch which hopefully
  is now fixed.
- Add another Lexar card reader to the whitelist. (#143600)
- Package asm-m68k for asm-ppc includes. (don't ask). (#144604)

* Sat Jan  8 2005 Dave Jones <davej@redhat.com>
- Periodic slab debug is incompatable with pagealloc debug.
  Disable the latter.

* Fri Jan  7 2005 Dave Jones <davej@redhat.com>
- Santa came to Notting's house too. (another new card reader)
- Rebase to 2.6.10-bk10

* Thu Jan  6 2005 Rik van Riel <riel@redhat.com>
- update to latest xen-unstable tree
- fix up Xen compile with -bk9, mostly pudding

* Thu Jan  6 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.10-bk9

* Tue Jan  4 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.10-bk7
- Add periodic slab debug checker.

* Sun Jan  2 2005 Dave Jones <davej@redhat.com>
- Rebase to 2.6.10-bk5

* Sat Jan  1 2005 Dave Jones <davej@redhat.com>
- Fix probing of vesafb. (#125890)
- Reenable EDD.
- Don't assume existance of ~/.gnupg (#142201)

* Fri Dec 31 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.10-bk4

* Thu Dec 30 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.10-bk3

* Tue Dec 28 2004 Dave Jones <davej@redhat.com>
- Drop bogus ethernet slab cache.

* Sun Dec 26 2004 Dave Jones <davej@redhat.com>
- Santa brought a new card reader that needs whitelisting.

* Fri Dec 24 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.10

* Wed Dec 22 2004 Dave Jones <davej@redhat.com>
- Re-add missing part of the exit() race fix. (#142505, #141896)

* Tue Dec 21 2004 Dave Jones <davej@redhat.com>
- Fix two silly bugs in the AGP posting fixes.

* Fri Dec 17 2004 Dave Jones <davej@redhat.com>
- Fix bio error propagation.
- Clear ebp on sysenter return.
- Extra debugging info on OOM kill.
- exit() race fix.
- Fix refcounting order in sd/sr, fixing cable pulls on USB storage.
- IGMP source filter fixes.
- Fix ext2/3 leak on umount.
- fix missing wakeup in ipc/sem
- Fix another tux corner case bug.
- NULL out ptrs in airo driver after kfree'ing them.

* Thu Dec 16 2004 Dave Jones <davej@redhat.com>
- Better version of the PCI Posting fixes for AGPGART.
- Add missing cache flush to the AGP code.
- Drop netdump and common crashdump code.

* Mon Dec 13 2004 Dave Jones <davej@redhat.com>
- Drop diskdump. Aiming for a better kexec based solution for FC4.

* Sun Dec 12 2004 Dave Jones <davej@redhat.com>
- fix false ECHILD result from wait* with zombie group leader.

* Sat Dec 11 2004 Dave Jones <davej@redhat.com>
- Workaround broken pci posting in AGPGART.
- Compile 686 kernel tuned for pentium4.
  | Needs benchmarking across various CPUs under
  | various workloads to find out if its worth keeping.
- Make sure VC resizing fits in s16.

* Fri Dec 10 2004 Dave Jones <davej@redhat.com>
- Prevent block device queues from being shared in viocd. (#139018)
- Libata updates. (#132848, #138405)
- aacraid: remove aac_handle_aif (#135527)
- fix uninitialized variable in waitid(2). (#142505)
- Fix CMSG validation checks wrt. signedness.
- Fix memory leak in ip_conntrack_ftp
- [IPV4]: Do not leak IP options.
- ppc64: Align PACA buffer for hypervisor's use. (#141817)
- ppc64: Indicate that the veth link is always up. (#135402)
- ppc64: Quiesce OpenFirmware stdin device at boot. (#142009)
- SELinux: Fix avc_node_update oops. (#142353)
- Fix CCISS ioctl return code.
- Make ppc64's pci_alloc_consistent() conform to documentation. (#140047)
- Enable EDD
- Enable ETH1394. (#138497)
- Workaround E1000 post-maturely writing back to TX descriptors. (#133261)
- Fix the previous E1000 errata workaround.
- Several IDE fixes from 2.6.9-ac
- vm pageout throttling. (#133858)
- Fix Tux from oopsing. (#140918)
- Fix Tux/SELinux incompatability (#140916)
- Fix Tux/IPV6 problem. (#140916)
- ide: Fix possible oops on boot.
- Make spinlock debugging panic instead of printk.
- Update Emulex lpfc driver to 8.0.16
- Selected patches from 2.6.9-ac12
- ppc64: Fix inability to find space for TCE table (#138844)
- Fix compat fcntl F_GETLK{,64} (#141680)
- blkdev_get_blocks(): handle eof
- Another card reader for the whitelist. (#134094)
- Disable tiglusb module. (#142102)
- E1000 64k-alignment fix. (#140047)
- Disable tiglusb module. (#142102)
- ID updates for cciss driver.
- Fix overflows in USB Edgeport-IO driver. (#142258)
- Fix wrong TASK_SIZE for 32bit processes on x86-64. (#141737)
- Fix ext2/ext3 xattr/mbcache race. (#138951)
- Fix bug where __getblk_slow can loop forever when pages are partially mapped. (#140424)
- Add missing cache flushes in agpgart code.

* Thu Dec  9 2004 Dave Jones <davej@redhat.com>
- Drop the 4g/4g hugemem kernel completely.

* Wed Dec  8 2004 Rik van Riel <riel@redhat.com>
- make Xen inherit config options from x86

* Mon Dec  6 2004 Rik van Riel <riel@redhat.com>
- apparently Xen works better without serial drivers in domain0 (#141497)

* Sun Dec  5 2004 Rik van Riel <riel@redhat.com>
- Fix up and reenable Xen compile.
- Fix bug in install part of BuildKernel. 

* Sat Dec  4 2004 Dave Jones <davej@redhat.com>
- Enable both old and new megaraid drivers.
- Add yet another card reader to usb scsi whitelist. (#141367)

* Fri Dec  3 2004 Dave Jones <davej@redhat.com>
- Sync all patches with latest updates in FC3.
- Fix up xen0/xenU uninstall.
- Temporarily disable xen builds.

* Wed Dec  1 2004 Rik van Riel <riel@redhat.com>
- replace VM hack with the upstream version
- more Xen bugfixes

* Tue Nov 30 2004 Rik van Riel <riel@redhat.com>
- upgrade to later Xen sources, with upstream bugfixes
- export direct_remap_area_pages for Xen

* Mon Nov 29 2004 Dave Jones <davej@redhat.com>
- Add another card reader to whitelist. (#141022)

* Fri Nov 26 2004 Rik van Riel <riel@redhat.com>
- add Xen kernels for i686, plus various bits and pieces to make them work

* Mon Nov 15 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-ac9

* Sat Nov 13 2004 Dave Jones <davej@redhat.com>
- Drop some bogus patches.

* Thu Nov 11 2004 Dave Jones <davej@redhat.com>
- NFS: Fix dentry refcount accounting error
- Fix single-stepping on PPC64
- Integrate kernel-devel changes
- SELinux: netif fixes.
- SELinux: add DAC check to setxattr() hook.
- SELinux: sidtab locking fix.
- SELinux: mediate send_sigurg().
- SELinux: fix setscheduler hook deadlock.
- ide-floppy: Supresses error messages resulting from Medium not present
- Various IA64 updates from 2.6.10rc1
- nfsd: make sure getxattr inode op is non-NULL before calling it.
- Handle NULL dev->dev_addr in SIOCGIFHWADDR correctly. (#137648)
- Fix NFSD domainname size limit.
- nfsd4: nfsd oopsed when encountering a conflict with a local lock
- nfsd4: fix putrootfh return
- nfsd: Insecure port warning shows decimal IPv4 address
- Disable sw irqbalance/irqaffinity for e7520/e7320/e7525 (#136419)
- Fix exec-shield non-PIE/non-prelinked bug
- ext3 reservations: fix goal hit accounting.
- Fix problems with non-power-of-two sector size discs. (#135094)
- Fix possible oops in netpoll (#132153)
- Add missing MODULE_VERSION tags to various modules. (#136399)
- Add USB card reader de jour. (#124048)
- Remove SG_IO deprecation warning (#136179)
- Make sure that modules get signed with the right key.
- Remove SG_IO deprecation warning (#136179)
- s390: Fix fake_ll for qeth device. (#136175)
- s390: zfcp: Kernel stack frame for zfcp_cfdc_dev_ioctl() is too big
- s390: Use slab allocator for DASD I/O pages.
- PPC64: HVSI udbg support
- PPC64: Make HVSI console survive FSP reset
- PPC64: Make PCI hostbridge hotplugging work
- PPC64: Fix IBM VSCSI problems (#138124)
- Rebase -ac patch to 2.6.9-ac8.

* Wed Nov  3 2004 Dave Jones <davej@redhat.com>
- Reenable token-ring drivers (#122602)

* Tue Nov  2 2004 Dave Jones <davej@redhat.com>
- Reenable SLIP. (#124223)
- Add USB card reader de jour. (#124048)

* Mon Nov  1 2004 Dave Jones <davej@redhat.com>
- Fix memory leak on x86-64 in mixed 32/64 mode. (#132947)
- Yet another USB card reader for the whitelist. (#137722)

* Fri Oct 29 2004 Dave Jones <davej@redhat.com>
- Fix raid5 oops (#127862)
- Stop E820 BIOS entries being corrupted by EDID info. (#137510)

* Thu Oct 28 2004 Dave Jones <davej@redhat.com>
- Remove the possibility of some false OOM kills. (#131251)
- Add more USB card readers to SCSI whitelist (#131546)
- Disable CONFIG_SCHED_SMT for iseries.

* Wed Oct 27 2004 Dave Jones <davej@redhat.com>
- Reenable ISA NIC support (#136569)

* Tue Oct 26 2004 Dave Jones <davej@redhat.com>
- Reenable Initio 9100U(W) SCSI driver. (#137153)

* Mon Oct 25 2004 Dave Jones <davej@redhat.com>
- Add another USB card reader to SCSI whitelist (#132923)

* Fri Oct 22 2004 Dave Jones <davej@redhat.com>
- Fix PPC NUMA (#130716).
- Fix autoraid for S390 (#123842/#130339)
- Selected bits from 2.6.9-ac3
  - Fix syncppp/async ppp problems with new hangup
  - Fix broken parport_pc unload
  - Stop i8xx_tco making some boxes reboot on load
  - Fix cpia/module tools deadlock
  - Security fix for smbfs leak/overrun

* Thu Oct 21 2004 Dave Jones <davej@redhat.com>
- Misc security fixes from 2.6.9-ac2

* Wed Oct 20 2004 Dave Jones <davej@redhat.com>
- Fix ia64 module loading. (#136365)
- Enable discontigmem for PPC64
- Disable a bunch of useless PPC config options
- Enable PACK_STACK on s390.

* Tue Oct 19 2004 Dave Jones <davej@redhat.com>
- Fix NFS badness (#132726)
- Drop bogus USB workaround. (#131127)

* Mon Oct 18 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9
- Speedtouch USB DSL modem driver update.
- Cleanup some iseries config options.

* Fri Oct 15 2004 Dave Jones <davej@redhat.com>
- 2.6.9-rc4-bk3
- Fix up a bunch of unresolved symbols that crept in recently.
- Remove bogus O_NONBLOCK patch which broke lots of userspace.
- Fix booting on PPC64 by reserving initrd pages.

* Thu Oct 14 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc4-bk2
- librtas needs to work around the /dev/mem restrictions.
- EXT3 reservations use-before-initialised bugfix.
- support O_NONBLOCK for read,pread,readv of regular files.
- EDD blows up some x86-64's. Disable again.

* Wed Oct 13 2004 Dave Jones <davej@redhat.com>
- Make EDD driver modular on x86-64 too.
- Various mkinitrd spec changes (Jeremy Katz)
- Enable a bunch more PPC64 config options. (Dave Howells)
- Enable ACPI cpufreq driver for x86-64 too.

* Tue Oct 12 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc4-bk1
- Tux update.
- Update netdump/diskdump patches
- PowerPC 64 netboot changes.
- Various CONFIG_ option diddling.
- Fix up the find_isa_irq_pin() oops on reboot for x86-64 too. 

* Mon Oct 11 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc4
- Enable CONFIG_MICROCODE for x86-64

* Fri Oct  8 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc3-bk8

* Thu Oct  7 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc3-bk7
- Fix up PPC/PPC64 compilation failures due to new binutils. (David Woodhouse)

* Wed Oct  6 2004 Dave Jones <davej@redhat.com>
- Rebase to 2.6.9-rc3-bk6
- Add xattr support for tmpfs.

* Mon Oct  4 2004 Stephen C. Tweedie <sct@redhat.com>
- Update ext3 online resize to 2.6.9-rc3-mm2 upstream
- Reenable ext3 online resize in .spec

* Tue Sep 28 2004 Jeremy Katz <katzj@redhat.com>
- add patch from Roland McGrath/James Morris to fix mprotect hook bug (#133505)

* Mon Sep 20 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc2-bk5

* Thu Sep 16 2004 Arjan van de Ven <arjanv@redhat.com>
- fix tux for x86-64 and ppc64

* Tue Sep 14 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc2
- add diskdump

* Fri Sep 10 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk17 ; make ppc32 build

* Tue Sep 07 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk13

* Mon Sep 06 2004 Arjan van de Ven <arjanv@redhat.com>
- disable online resize again
- hopefully fix Quake3 interaction with execshield
- add Alan's borken-bios-IRQ workaround patch

* Sat Sep 04 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk11

* Tue Aug 31 2004 Arjan van de Ven <arjanv@redhat.com>
- fix execshield buglet with legacy binaries
- 2.6.9-rc1-bk7

* Mon Aug 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk6

* Sat Aug 28 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk4, now with i915 DRM driver

* Fri Aug 27 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.9-rc1-bk2 

* Mon Aug 23 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8.1-bk2

* Sat Aug 21 2004 Arjan van de Ven <arjanv@redhat.com>
- attempt to fix early-udev bug

* Fri Aug 13 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc4-bk3
- split execshield up some more

* Fri Aug 13 2004 Dave Jones <davej@redhat.com>
- Update SCSI whitelist again with some more card readers.

* Mon Aug 9 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc3-bk3

* Wed Aug 4 2004 Arjan van de Ven <arjanv@redhat.com>
- Add the flex-mmap bits for s390/s390x (Pete Zaitcev)
- Add flex-mmap for x86-64 32 bit emulation
- 2.6.8-rc3

* Mon Aug 2 2004 Arjan van de Ven <arjanv@redhat.com>
- Add Rik's token trashing control patch

* Sun Aug 1 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc2-bk11

* Fri Jul 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc2-bk8

* Wed Jul 28 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc2-bk6
- make a start at splitting up the execshield patchkit

* Fri Jul 16 2004 Arjan van de Ven <arjanv@redhat.com>
- ppc32 embedded updates

* Thu Jul 15 2004 Arjan van de Ven <arjanv@redhat.com>
- make USB modules again and add Alan's real fix for the SMM-meets-USB bug
- 2.6.8-rc1-bk4

* Wed Jul 14 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.8-rc1-bk3

* Tue Jul 13 2004 Arjan van de Ven <arjanv@redhat.com>
- add "enforcemodulesig" boot option to make the kernel load signed modules only

* Mon Jul 12 2004 Arjan van de Ven <arjanv@redhat.com>
- updated voluntary preempt
- 2.6.8-rc1

* Wed Jul 7 2004 Arjan van de Ven <arjanv@redhat.com>
- fix boot breakage that was hitting lots of people (Dave Jones)

* Tue Jul 6 2004 Arjan van de Ven <arjanv@redhat.com>
- add voluntary preemption patch from Ingo
- 2.6.7-bk19

* Tue Jun 29 2004 Arjan van de Ven <arjanv@redhat.com>
- make a start at gpg signed modules support

* Sat Jun 27 2004 Arjan van de Ven <arjanv@redhat.com>
- experiment with making the hardlink call in post more efficient
- 2.6.7-bk9

* Thu Jun 24 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-bk7
- Add wli's patch to allocate memory bottom up not top down
- change some config options in the kernel-sourcecode package that are
  good for rpm kernel builds but not for custom user builds to more appropriate 
  default values.
- reenable kernel-sourcecode again for a few builds 

* Wed Jun 23 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-bk5
- fix tux unresolved symbols (#126532)

* Mon Jun 21 2004 Arjan van de Ven <arjanv@redhat.com>
- make kernel-doc and kernel-sourcecode builds independent of eachother
- disable kernel-sourcecode builds entirely, we'll be replacing it with documentation
  on how to use the src.rpm instead for building your own kernel.

* Sat Jun 19 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-bk2

* Sun Jun 13 2004 Arjan van de Ven <arjanv@redhat.com>
- add patch from DaveM to fix the ppp-keeps-iface-busy bug

* Sat Jun 12 2004 Arjan van de Ven <arjanv@redhat.com>
- add fix from Andi Kleen/Linus for the fpu-DoS

* Thu Jun 10 2004 Arjan van de Ven <arjanv@redhat.com>
- disable mlock-uses-rlimit patch, it has a security hole and needs more thought
- revert airo driver to the FC2 one since the new one breaks

* Tue Jun 8 2004 Dave Jones <davej@redhat.com>
- Update to 2.6.7rc3

* Fri Jun 4 2004 Arjan van de Ven <arjanv@redhat.com>
- fix the mlock-uses-rlimit patch

* Wed Jun 2 2004 David Woodhouse <dwmw2@redhat.com>
- Add ppc64 (Mac G5)

* Wed Jun 2 2004 Arjan van de Ven <arjanv@redhat.com>
- add a forward port of the mlock-uses-rlimit patch
- add NX support for x86 (Intel, Ingo)

* Tue Jun 1 2004 Arjan van de Ven <arjanv@redhat.com>
- refresh ext3 reservation patch

* Sun May 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.7-rc2
- set the ACPI OS name to "Microsoft Windows XP" for better compatibility

* Thu May 27 2004 Pete Zaitcev <zaitcev@redhat.com>
- Fix qeth and zfcp (s390 drivers): align qib by 256, embedded into qdio_irq.

* Thu May 27 2004 Dave Jones <davej@redhat.com>
- Fix the crashes on boot on Asus P4P800 boards. (#121819)

* Wed May 26 2004 Dave Jones <davej@redhat.com>
- Lots more updates to the SCSI whitelist for various
  USB card readers. (#112778, among others..)

* Wed May 26 2004 Arjan van de Ven <arjanv@redhat.com>
- back out ehci suspend/resume patch, it breaks
- add fix for 3c59x-meets-kudzu bug from Alan

* Tue May 25 2004 Arjan van de Ven <arjanv@redhat.com>
- try improving suspend/resume by restoring more PCI state
- 2.6.7-rc1-bk1

* Mon May 24 2004 Dave Jones <davej@redhat.com>
- Add yet another multi-card reader to the whitelist (#85851)

* Sun May 23 2004 Dave Jones <davej@redhat.com>
- Add another multi-card reader to the whitelist (#124048)

* Wed May 19 2004 Arjan van de Ven <arjanv@redhat.com>
- put firewire race fix in (datacorruptor)

* Tue May 18 2004 Dave Jones <davej@redhat.com>
- Fix typo in ibmtr driver preventing compile (#123391)

* Mon May 17 2004 Arjan van de Ven <arjanv@redhat.com>
- update to 2.6.6-bk3
- made kernel-source and kernel-doc noarch.rpm's since they are not
  architecture specific.

* Sat May 08 2004 Arjan van de Ven <arjanv@redhat.com>
- fix non-booting on Transmeta cpus (Peter Anvin)
- fix count leak in message queues

* Fri May 07 2004 Arjan van de Ven <arjanv@redhat.com>
- more ide cache flush work
- patch from scsi-bk to fix sd refcounting

* Thu May 06 2004 Arjan van de Ven <arjanv@redhat.com>
- some more ide cache flush fixes 

* Wed May 05 2004 Arjan van de Ven <arjanv@redhat.com>
- fix bug 122504
- convert b44 to ethtool ops (jgarzik)
- make IDE do a cache-flush on shutdown (me/Alan)

* Tue May 04 2004 Arjan van de Ven <arjanv@redhat.com>
- work around i810/i830 DRM issue

* Fri Apr 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.6-rc3-bk1
- make amd64 boot again
- fix vm86-vs-4g4g interaction (Ingo)

* Thu Apr 22 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.6-rc2
 
* Tue Apr 20 2004 Arjan van de Ven <arjanv@redhat.com>
- add the ext3 online resize patch

* Mon Apr 19 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.6-rc1-bk3
- add the objrmap vm from the -mm tree; it needs testing

* Thu Apr 15 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-bk2
- disable DISCONTIGMEM on ia64 for performance
- fix sleep_on use in reiserfs (Chris Mason)

* Tue Apr 13 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-mc4
- reenable sg driver for scsi tape changers and such
- the sk98lin driver oopses on module unload, preven that

* Mon Apr 12 2004 Arjan van de Ven <arjanv@redhat.com>
- fix "bad pmd" bug with patch from Ingo

* Fri Apr 09 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-mc3
- finish up the -mc2 merge
- latest 4g/4g patch from Ingo
- latest execshield patch from Ingo
- fix a few framebuffer bugs

* Thu Apr 08 2004 Arjan van de Ven <arjanv@redhat.com>
- first attempt at a 2.6.5-mc2 merge

* Thu Apr 08 2004 Dave Jones <davej@redhat.com>
- Add in missing SiS AGP fix.

* Tue Apr 06 2004 Dave Jones <davej@redhat.com>
- More agpgart fixes.

* Fri Apr 02 2004 Arjan van de Ven <arjanv@redhat.com>
- fix another 4g/4g-vs-resume bug

* Tue Mar 30 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc3
- fix PCI posting bug in i830 DRM

* Mon Mar 29 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2-bk8

* Mon Mar 29 2004 Dave Jones <davej@redhat.com>
- Include latest agpgart fixes.

* Thu Mar 25 2004 Arjan van de Ven <arjanv@redhat.com>
- more DRM fixes
- add the fsync patches from akpm

* Tue Mar 23 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2-bk3
- fix direct userspace memory access in i830 drm driver

* Mon Mar 22 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2-bk2
- some stackbloat reductions from Dave and me

* Sat Mar 20 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.5-rc2

* Tue Mar 16 2004 Dave Jones <davej@redhat.com>
- 2.6.5-rc1

* Mon Mar 15 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.4-bk3
- fix oops in toshiba_acpi (Barry K. Nathan)

* Sat Mar 13 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.4-bk2 merge 

* Thu Mar 11 2004 Arjan van de Ven <arjanv@redhat.com>
- renable sonypi driver that was off accidentally
- 2.6.4-final 
- fix the oops on alsa module unloads

* Wed Mar 10 2004 Arjan van de Ven <arjanv@redhat.com>
- add ppc64/iseries, ppc32 (powermac/ibook) and ia64 architectures
- 2.6.4-rc3 

* Tue Mar 09 2004 Arjan van de Ven <arjanv@redhat.com>
- 2.6.4-rc2-bk5
- fix nfs-vs-selinux issue
- fix typo in URL as per #117849

* Mon Mar 08 2004 Arjan van de Ven <arjanv@redhat.com>
- fix race in lp.c (#117710)
- 2.6.4-rc2-bk3
- attempt to fix S3 suspend-to-ram with 4g/4g split

* Sat Mar 06 2004 Arjan van de Ven <arjanv@redhat.com>
- fix reiserfs
- set HZ to 1000 again for some tests

* Wed Feb 25 2004 Arjan van de Ven <arjanv@redhat.com>
- merge back a bunch of fedora fixes
- disable audit

* Tue Feb 24 2004 Arjan van de Ven <arjanv@redhat.com>
- audit bugfixes
- update tux to a working version
- 2.6.3-bk5 merge

* Fri Feb 20 2004 Arjan van de Ven <arjanv@redhat.com>
- re-add and enable the Auditing patch
- switch several cpufreq modules to built in since detecting in userspace
  which to use is unpleasant

* Thu Jul 03 2003 Arjan van de Ven <arjanv@redhat.com>
- 2.6 start

