'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) mainwindow.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS iwidgets::mainwindow iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::mainwindow \- Create and manipulate a mainwindow widget
.SH SYNOPSIS
\fBiwidgets::mainwindow\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- iwidgets::Shell <- iwidgets::Mainwindow
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
background  cursor               disabledForeground  font
foreground  highlightBackground  highlightColor      highlightThickness\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBballoonBackground\fR	\fBballoonDelay1\fR	\fBballoonDelay2\fR	\fBballonFont\fR
\fBballoonForeground\fR
.fi
.LP
See the "toolbar" manual entry for details on the above associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBtitle\fR 
.fi
.LP
See the "Toplevel" manual entry for details on the above inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBheight\fR	\fBmaster\fR	\fBmodality\fR	\fBpadX\fR
\fBpadY\fR	\fBwidth\fR
.fi
.LP
See the "shell" manual entry for details on the above inherited options.

.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBhelpLine\fR
Class:	\fBHelpLine\fR
Command-Line Switch:	\fB-helpline\fR
.fi
.IP
Specifies whether or not to display the help line.  The value
may be given in any of the forms acceptable to Tk_GetBoolean.
The default is yes.
.LP
.nf
Name:	\fBmenuBarBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-menubarbackground\fR
.fi
.IP
Specifies the normal background color for the menubar.
.LP
.nf
Name:	\fBmenuBarFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-menubarfont\fR
.fi
.IP
Specifies the font to use when drawing text inside the menubar.
.LP
.nf
Name:	\fBmenuBarForeround\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-menubarforeground\fR
.fi
.IP
Specifies the normal foreground color for the menubar.
.LP
.nf
Name:	\fBstatusLine\fR
Class:	\fBStatusLine\fR
Command-Line Switch:	\fB-statusline\fR
.fi
.IP
Specifies whether or not to display the status line.  The value
may be given in any of the forms acceptable to Tk_GetBoolean.
The default is yes.
.LP
.nf
Name:	\fBtoolBarBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-toolbarbackground\fR
.fi
.IP
Specifies the normal background color for the toolbar.
.LP
.nf
Name:	\fBtoolBarFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-toolbarfont\fR
.fi
.IP
Specifies the font to use when drawing text inside the toolbar.
.LP
.nf
Name:	\fBtoolBarForeround\fR
Class:	\fBForeground\fR
Command-Line Switch:	\fB-toolbarforeground\fR
.fi
.IP
Specifies the normal foreground color for the toolbar.
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::mainwindow\fR command creates a mainwindow shell which contains
a menubar, toolbar, mousebar, childsite, status line, and help line.  
Each item may be filled and configured to suit individual needs.

.SH "METHODS"
.PP
The \fBiwidgets::mainwindow\fR command create a new Tcl command whose
name is \fIpathName\fR.  This command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for mainwindow widgets:
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" manual entry for details on the above inherited methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::mainwindow\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the pathname of the child site widget.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::mainwindow\fR
command.
.TP
\fIpathName \fBmenubar\fR ?\fIargs\fR?
The \fBmenubar\fR method provides access to the menubar.  Invoked with
no arguments it returns the pathname of the menubar.  With arguments,
they are evaluated against the menubar which in effect provides
access to the entire API of the menubar.  See the "menubar" manual
entry for details on the commands available in the menubar.
.TP
\fIpathName \fBmousebar\fR ?\fIargs\fR?
The \fBmousebar\fR method provides access to the mousebar which is a 
vertical toolbar.  Invoked with no arguments it returns the pathname 
of the mousebar.  With arguments, they are evaluated against the mousebar 
which in effect provides access to the entire API of the underlying 
toolbar.  See the "toolbar" manual entry for details on the commands 
available in the mousebar.
.TP
\fIpathName \fBmsgd\fR ?\fIargs\fR?
The \fBmsgd\fR method provides access to the messagedialog contained
in the mainwindow.  Invoked with no arguments it returns the pathname 
of the messagedialog.  With arguments, they are evaluated against the 
messagedialog which in effect provides access to the entire API of the 
messagedialog.  See the "messagedialog" manual
entry for details on the commands available in the messagedialog.
.TP
\fIpathName \fBtoolbar\fR ?\fIargs\fR?
The \fBtoolbar\fR method provides access to the toolbar.  Invoked with
no arguments it returns the pathname of the toolbar.  With arguments,
they are evaluated against the toolbar which in effect provides
access to the entire API of the toolbar.  See the "toolbar" manual
entry for details on the commands available in the toolbar.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBhelp\fR
Class:	\fBLabel\fR
.fi
.IP
The help component provides a location for displaying any help
strings provided in the menubar, toolbar, or mousebar.  See the "label" 
widget manual entry for details on the help component item.
.LP
.nf
Name:	\fBmenubar\fR
Class:	\fBMenubar\fR
.fi
.IP
The menubar component is the menubar located at the top of the window.
See the "menubar" widget manual entry for details on the menubar 
component item.
.LP
.nf
Name:	\fBmousebar\fR
Class:	\fBToolbar\fR
.fi
.IP
The mousebar component is the vertical toolbar located on the right side
of the window.  See the "toolbar" widget manual entry for details on 
the mousebar component item.
.LP
.nf
Name:	\fBmsgd\fR
Class:	\fBMessagedialog\fR
.fi
.IP
The msgd component is a messagedialog which may be reconfigured as needed 
and used repeatedly throughout the application.  See the "messagedialog" 
widget manual entry for details on the messagedialog component item.
.LP
.nf
Name:	\fBstatus\fR
Class:	\fBLabel\fR
.fi
.IP
The status component provides a location for displaying application
status information.  See the "label" widget manual entry for details 
on the status component item.
.LP
.nf
Name:	\fBtoolbar\fR
Class:	\fBToolbar\fR
.fi
.IP
The toolbar component is the horizontal toolbar located on the top 
of the window.  See the "toolbar" widget manual entry for details on 
the toolbar component item.
.fi

.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 iwidgets::mainwindow .mw

 #
 # Add a File menubutton
 #
 .mw menubar add menubutton file -text "File" -underline 0 -padx 8 -pady 2 \\
    -menu {options -tearoff no
	   command new -label "New" -underline 0 \\
	       -helpstr "Create a new file"
	   command open -label "Open ..." -underline 0 \\
	       -helpstr "Open an existing file"
	   command save -label "Save" -underline 0 \\
	       -helpstr "Save the current file"
	   command saveas -label "Save As ..." -underline 5 \\
	       -helpstr "Save the file as a differnet name"
	   command print -label "Print" -underline 0 \\
	       -helpstr "Print the file"
           separator sep1
	   command close -label "Close" -underline 0 \\
	       -helpstr "Close the file"
	   separator sep2
	   command exit -label "Exit" -underline 1 \\
	       -helpstr "Exit this application" 
    }

 #
 # Install a scrolledtext widget in the childsite.
 #
 iwidgets::scrolledtext [.mw childsite].st
 pack [.mw childsite].st -fill both -expand yes

 #
 # Activate the main window.
 #
 .mw activate
.DE
.SH AUTHOR
Mark L. Ulferts
.DE
John A. Tucker
.LP
.SH KEYWORDS
mainwindow, shell, widget
