/* Target-dependent code for the Matsushita MN10300 for GDB, the GNU debugger.
   Copyright 2003
   Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include "defs.h"
#include "gdbcore.h"
#include "gdb_string.h"
#include "regcache.h"
#include "mn10300-tdep.h"

#include <stdlib.h>

/* Transliterated from <asm-mn10300/elf.h>...  */
#define ELF_NGREG 28
#define ELF_NFPREG 32

typedef unsigned char elf_greg_t[4];
typedef elf_greg_t elf_gregset_t[ELF_NGREG];

typedef unsigned char elf_fpreg_t[4];
typedef struct
{
  elf_fpreg_t fpregs[ELF_NFPREG];
  unsigned char fpcr[4];
} elf_fpregset_t;

/* elf_gregset_t register indices stolen from include/asm-mn10300/ptrace.h.  */
#define ELF_GREGSET_T_REG_INDEX_A3	0
#define ELF_GREGSET_T_REG_INDEX_A2	1
#define ELF_GREGSET_T_REG_INDEX_D3	2
#define	ELF_GREGSET_T_REG_INDEX_D2	3
#define ELF_GREGSET_T_REG_INDEX_MCVF	4
#define	ELF_GREGSET_T_REG_INDEX_MCRL	5
#define ELF_GREGSET_T_REG_INDEX_MCRH	6
#define	ELF_GREGSET_T_REG_INDEX_MDRQ	7
#define	ELF_GREGSET_T_REG_INDEX_E1	8
#define	ELF_GREGSET_T_REG_INDEX_E0	9
#define	ELF_GREGSET_T_REG_INDEX_E7	10
#define	ELF_GREGSET_T_REG_INDEX_E6	11
#define	ELF_GREGSET_T_REG_INDEX_E5	12
#define	ELF_GREGSET_T_REG_INDEX_E4	13
#define	ELF_GREGSET_T_REG_INDEX_E3	14
#define	ELF_GREGSET_T_REG_INDEX_E2	15
#define	ELF_GREGSET_T_REG_INDEX_SP	16
#define	ELF_GREGSET_T_REG_INDEX_LAR	17
#define	ELF_GREGSET_T_REG_INDEX_LIR	18
#define	ELF_GREGSET_T_REG_INDEX_MDR	19
#define	ELF_GREGSET_T_REG_INDEX_A1	20
#define	ELF_GREGSET_T_REG_INDEX_A0	21
#define	ELF_GREGSET_T_REG_INDEX_D1	22
#define	ELF_GREGSET_T_REG_INDEX_D0	23
#define ELF_GREGSET_T_REG_INDEX_ORIG_D0	24
#define	ELF_GREGSET_T_REG_INDEX_EPSW	25
#define	ELF_GREGSET_T_REG_INDEX_PC	26

/* Unpack an elf_gregset_t into GDB's register cache.  */

static void
supply_gregset (elf_gregset_t *gregsetp)
{
  elf_greg_t *regp = *gregsetp;
  char zerobuf[MAX_REGISTER_SIZE];
  int regi;

  memset (zerobuf, 0, MAX_REGISTER_SIZE);

  regcache_raw_supply (current_regcache, E_D0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D0));
  regcache_raw_supply (current_regcache, E_D1_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D1));
  regcache_raw_supply (current_regcache, E_D2_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D2));
  regcache_raw_supply (current_regcache, E_D3_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D3));
  regcache_raw_supply (current_regcache, E_A0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A0));
  regcache_raw_supply (current_regcache, E_A0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A1));
  regcache_raw_supply (current_regcache, E_A2_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A2));
  regcache_raw_supply (current_regcache, E_A3_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A3));
  regcache_raw_supply (current_regcache, E_SP_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_SP));
  regcache_raw_supply (current_regcache, E_PC_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_PC));
  regcache_raw_supply (current_regcache, E_MDR_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_MDR));
  regcache_raw_supply (current_regcache, E_PSW_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_EPSW));
  regcache_raw_supply (current_regcache, E_LIR_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_LIR));
  regcache_raw_supply (current_regcache, E_LAR_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_LAR));
  regcache_raw_supply (current_regcache, E_MDRQ_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MDRQ));
  regcache_raw_supply (current_regcache, E_E0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_E0));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 1, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E1));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 2, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E2));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 3, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E3));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 4, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E4));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 5, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E5));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 6, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E6));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 7, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E7));

  /* ssp, msp, and usp are inaccessible.  */
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 8, zerobuf);
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 9, zerobuf);
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 10, zerobuf);

  regcache_raw_supply (current_regcache, E_MCRH_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MCRH));
  regcache_raw_supply (current_regcache, E_MCRL_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MCRL));
  regcache_raw_supply (current_regcache, E_MCVF_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MCVF));

  /* The two unused registers beyond fpcr are inaccessible.  */
  regcache_raw_supply (current_regcache, E_FPCR_REGNUM + 1, zerobuf);
  regcache_raw_supply (current_regcache, E_FPCR_REGNUM + 2, zerobuf);
}

/* Unpack an elf_fpregset_t into GDB's register cache.  */

static void
supply_fpregset (elf_fpregset_t *fpregsetp)
{
  register int regi;

  for (regi = 0; regi < ELF_NFPREG; regi++)
    regcache_raw_supply (current_regcache, E_FS0_REGNUM + regi, (char *)&fpregsetp->fpregs[regi]);

  regcache_raw_supply (current_regcache, E_FPCR_REGNUM, (char *)&fpregsetp->fpcr);

}

/*  Use a local version of this function to get the correct types for
    regsets, until multi-arch core support is ready.  */

static void
fetch_core_registers (char *core_reg_sect, unsigned core_reg_size,
		      int which, CORE_ADDR reg_addr)
{
  elf_gregset_t gregset;
  elf_fpregset_t fpregset;

  if (which == 0)
    {
      if (core_reg_size == sizeof (gregset))
	{
	  memcpy ((char *) &gregset, core_reg_sect, sizeof (gregset));
	  supply_gregset (&gregset);
	}
      else
	{
	  warning ("wrong size gregset struct in core file");
	}
    }
  else if (which == 2)
    {
      if (NUM_REGS <= E_FS0_REGNUM + 31)
	{
	  warning ("Wrong mn10300 architecture for core file.\n"
	           "Hint: try \"set architecture am33-2\" before loading core file.");
	}
      else if (core_reg_size == sizeof (fpregset))
	{
	  memcpy ((char *) &fpregset, core_reg_sect, sizeof (fpregset));
	  supply_fpregset (&fpregset);
	}
      else
	{
	  warning ("wrong size fpregset struct in core file");
	}
    }
}

/* Register that we are able to handle ELF file formats using standard
   procfs "regset" structures.  */

static struct core_fns regset_core_fns =
{
  bfd_target_elf_flavour,		/* core_flavour */
  default_check_format,			/* check_format */
  default_core_sniffer,			/* core_sniffer */
  fetch_core_registers,			/* core_read_registers */
  NULL					/* next */
};

void
_initialize_mn10300_linux_tdep (void)
{
  deprecated_add_core_fns (&regset_core_fns);
}
