Summary: Creates an initial ramdisk image for preloading modules.
Name: mkinitrd
Version: 4.1.18
Release: 2
License: GPL
Group: System Environment/Base
Source: mkinitrd-%{version}.tar.bz2
ExclusiveOs: Linux
Prereq: dev
Requires: e2fsprogs, /bin/sh, fileutils, grep, mount, gzip, tar, /sbin/insmod.static, /sbin/losetup, mktemp >= 1.5-5, findutils, lvm2
Requires: filesystem >= 2.1.0, cpio
Conflicts: udev < 0:032
BuildRequires: popt
%ifarch i386
BuildRequires: dietlibc
%endif
%ifarch ppc
Requires: ppc64-utils >= 0.3-1
%endif
BuildRoot: %{_tmppath}/%{name}-root

%description
Mkinitrd creates filesystem images for use as initial ramdisk (initrd)
images.  These ramdisk images are often used to preload the block
device modules (SCSI or RAID) needed to access the root filesystem.

In other words, generic kernels can be built without drivers for any
SCSI adapters which load the SCSI driver as a module.  Since the
kernel needs to read those modules, but in this case it isn't able to
address the SCSI adapter, an initial ramdisk is used.  The initial
ramdisk is loaded by the operating system loader (normally LILO) and
is available to the kernel as soon as the ramdisk is loaded.  The
ramdisk image loads the proper SCSI adapter and allows the kernel to
mount the root filesystem.  The mkinitrd program creates such a
ramdisk using information found in the /etc/modules.conf file.

%prep
%setup -q

%build
make
make test
if [ $? != 0 ]; then exit 1; fi

%install
rm -rf $RPM_BUILD_ROOT
make BUILDROOT=$RPM_BUILD_ROOT mandir=%{_mandir} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%attr(755,root,root) /sbin/mkinitrd
%attr(644,root,root) %{_mandir}/man8/mkinitrd.8*
%attr(755,root,root) /sbin/nash
%attr(644,root,root) %{_mandir}/man8/nash.8*
%config %attr(755,root,root) /sbin/installkernel
%attr(755,root,root) /sbin/new-kernel-pkg
%attr(755,root,root) /sbin/grubby
%attr(644,root,root) %{_mandir}/man8/grubby.8*

%changelog
* Sun Oct 24 2004 Jeremy Katz <katzj@redhat.com> - 4.1.18-2
- require cpio (#136814)

* Sun Oct 17 2004 Jeremy Katz <katzj@redhat.com> - 4.1.18-1
- fix UPDATEDEFAULT with new-kernel-pkg (#135997)

* Fri Oct 15 2004 Jeremy Katz <katzj@redhat.com> - 4.1.17-1
- run udevstart again instead of sleeping, this will ensure all 
  devices are created in all cases after modules have been 
  loaded (thanks to notting)

* Fri Oct 15 2004 Jeremy Katz <katzj@redhat.com> - 4.1.16-1
- mkinitrd: Sleep briefly to let udev finish creating devices

* Wed Oct 13 2004 Jeremy Katz <katzj@redhat.com> - 4.1.15-1
- new-kernel-pkg: set new kernels as default (#135161) when
  a) /etc/sysconfig/kernel contains UPDATEDEFAULT=yes
  b) --package foo is passed in and foo matches DEFAULTKERNEL 
     in /etc/sysconfig/kernel

* Thu Sep 30 2004 Jeremy Katz <katzj@redhat.com> - 4.1.14-1
- support changing root on the kernel command line with lvm (#133236)

* Wed Sep 22 2004 Jeremy Katz <katzj@redhat.com> - 4.1.12-1
- update to work with udev 032, conflict with old udev
- if udev is present, use it.  trying to avoid the use of udev if it's 
  installed is the road to things not working

* Fri Sep 10 2004 Jeremy Katz <katzj@redhat.com> - 4.1.11-1
- more fixing

* Wed Sep  8 2004 Jeremy Katz <katzj@redhat.com> - 4.1.10-1
- mkinitrd: mount tmpfs with the right permissions

* Tue Aug 31 2004 Jeremy Katz <katzj@redhat.com> - 4.1.9-1
- mkinitrd: use tmpfs instead of ramfs for udev stuff

* Fri Aug 27 2004 Jeremy Katz <katzj@redhat.com> - 4.1.8-1
- nash: and the hack to fix ppc broke other arches, conditionalize it (#130928)

* Wed Aug 25 2004 Jeremy Katz <katzj@redhat.com> - 4.1.6-1
- nash: fix another off by one (#130987)
- nash: hack to fix ppc booting (#130928)

* Tue Aug 25 2004 Karsten Hopp <karsten@redhat.com> - 4.1.5-1
- fix zfcp handling

* Tue Aug 24 2004 Jeremy Katz <katzj@redhat.com> - 4.1.4-1
- nash: create raid device if needed (think udev) before calling
  the raidautorun ioctl (#130561)

* Tue Aug 24 2004 Jeremy Katz <katzj@redhat.com> - 4.1.3-1
- nash: make echo behavior consistent with other shells
- more fixes from Steve Grubb (#129673)

* Mon Aug 23 2004 Karsten Hopp <karsten@redhat.de> 4.1.2-1
- mkinitrd: add support for zfcp devices (mainframe)

* Thu Aug 19 2004 Jeremy Katz <katzj@redhat.com> - 4.1.1-1
- don't remove lost+found (#130327)
- don't try to mount/umount /sys on 2.4 (#130298)

* Tue Aug 17 2004 Jeremy Katz <katzj@redhat.com> - 4.1.0-1
- mkinitrd: if using udev for the initrd, set things up appropriately 
  (based on patches from Harald Hoyer and Thomas Woerner)
- nash: support for echo -n
- nash: better error message on exec failures
- nash: exec udev if we're called as a hotplug handler

* Mon Aug 16 2004 Jeremy Katz <katzj@redhat.com> - 4.0.6-1
- various fixes from a code review by Steve Grubb which should fix 
  some of the lingering problems (#129673)
- nash: warning fix from Michal Jaegermann (#129673)
- grubby: removal with (hd0,0)

* Thu Aug 12 2004 Jeremy Katz <katzj@redhat.com> - 4.0.5-1
- nash: oops, let's try that again

* Wed Aug 11 2004 Jeremy Katz <katzj@redhat.com> - 4.0.4-1
- nash: fix mounting by label in some cases (tracked down by 
  Erik Jacobson, #129581, #129673, #129667, #129635)

* Tue Aug 10 2004 Jeremy Katz <katzj@redhat.com>  4.0.3-1
- grubby: more (hd0,0) support (#125156)
- mkinitrd.8: update manpage (#129585)
- nash: fix some warnings

* Wed Aug  4 2004 Jeremy Katz <katzj@redhat.com> 4.0.2-1
- nash: support bind mounting
- grubby: support the (hd0,0)/path syntax for kernels and initrds in
  grub.conf (#114758, #125156, #120906)

* Wed Aug  4 2004 Jeremy Katz <katzj@redhat.com> - 4.0.1-1
- improve handling of arguments to init with initramfs (#129057)

* Mon Aug  2 2004 Jeremy Katz <katzj@redhat.com> - 4.0.0-1
- create an initramfs on 2.6 kernels instead of an initrd
- use new mount magic instead of pivot_root 
  on 2.6 kernels
- try to handle the case of modules going away on kernel upgrades a 
  little bit more nicely (#123994)
- avoid over-zealous creation of /dev/mapper/control (#127115)
- improve nash(8) manpage (#127413)

* Fri Jun 18 2004 Jeremy Katz <katzj@redhat.com> - 3.5.24-1
- fix usb-storage detection with 2.6 (#126309)

* Tue May 18 2004 Jeremy Katz <katzj@redhat.com> - 3.5.23-1
- add support for RAID6

* Wed May 12 2004 Jeremy Katz <katzj@redhat.com>
- add support for multipath personality from Tom Callaway (#120379)

* Thu May  6 2004 Jeremy Katz <katzj@redhat.com> - 3.5.22-1
- bump initrd size (#122325)

* Wed Apr 14 2004 Jeremy Katz <katzj@redhat.com> - 3.5.21-1
- new-kernel-package: add patch from Ryan Tilder to allow setting new 
  kernel as default (#117605)
- mkinitrd: i2o_pci isn't in 2.6 (#120827)
- new-kernel-pkg: conditionalize kernel binary name for 2.6 vs 2.4 
  on ppc/ppc64 (as it's vmlinuz in 2.6 instead of the 
  vmlinux from 2.4) (#120868)

* Tue Apr 13 2004 Jeremy Katz <katzj@redhat.com> - 3.5.20-1
- mkinitrd: minor regex fix for some kernel names (#120624)

* Mon Feb  9 2004 Jeremy Katz <katzj@redhat.com> - 3.5.19-1
- nash/mkinitrd: quiet mode for nash and necessary mkinitrd changes 
  to work with it
- mkinitrd: add lxo's patch for copying lvm.conf (#112099)
- new-kernel-pkg: allow specifying the banner used in the boot loader config
  on the command line (#114809)

* Tue Jan 13 2004 Jeremy Katz <katzj@redhat.com> 
- mkinitrd: add patch from Alex Kiernan for modules with multiple 
  deps in 2.6 (#113306)

* Thu Jan  8 2004 Jeremy Katz <katzj@redhat.com> 3.5.18-1
- new-kernel-pkg: add a --kernel-arguments option (#113125)

* Tue Jan  6 2004 Jeremy Katz <katzj@redhat.com> 
- fix ybin path (#112939)

* Sun Jan  4 2004 Jeremy Katz <katzj@redhat.com> 3.5.17-1
- mkinitrd: handle multiple spaces in modules.conf (from Lubomir Bulej)
- nash: rebuild against new dietlibc fixing problems with root=LABEL= (#112623)
- mkinitrd: determine kernel version and adjust modulefile appropriately 
  so that we look at /etc/modprobe.conf for 2.6 kernels
- mkinitrd: first pass at getting lvm working on 2.4 -> 2.6 upgrade

* Wed Dec 24 2003 Jeremy Katz <katzj@redhat.com> 
- mkinitrd: quiet strip by default

* Mon Dec 22 2003 Jeremy Katz <katzj@redhat.com> 3.5.16.1-1
- make stripping less aggressive

* Mon Dec 22 2003 Jeremy Katz <katzj@redhat.com> 3.5.16-1
- fixing handling of non-lvm case when /dev/mapper/control isn't present
- add patch from Al Viro to get root dev in numeric form by grokking sysfs

* Tue Dec  9 2003 Jeremy Katz <katzj@redhat.com> 
- strip modules if /usr/bin/strip exists (#111756)

* Fri Dec  5 2003 Jeremy Katz <katzj@redhat.com> 3.5.15-2
- require lvm2 so that it gets installed early enough

* Fri Dec  5 2003 Jeremy Katz <katzj@redhat.com> 3.5.15-1
- mkinitrd: add support for lvm2 (note: will not currently handle being
  on a running 2.4 kernel and installing 2.6 with lvm rootfs)

* Wed Dec  3 2003 Jeremy Katz <katzj@redhat.com> 
- nash: add mkdmnod for creating the device-mapper control node

* Thu Oct  2 2003 Jeremy Katz <katzj@redhat.com> 3.5.14-1
- fix dependency on /usr/bin/tail and /usr/bin/id

* Tue Sep 30 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- remove one more mktemp dir for "all loopback devices in use" case

* Tue Sep 23 2003 Jeremy Katz <katzj@redhat.com> 3.5.13-1
- fix getting modules from /lib/modules/$(uname -r)/updates

* Mon Sep 22 2003 Jeremy Katz <katzj@redhat.com> 3.5.12-1
- argument checking and usage for /sbin/installkernel  (#103109)

* Wed Sep  3 2003 Jeremy Katz <katzj@redhat.com> 3.5.11-1
- really only do grub configs on grub arches
- some usb mkinitrd fixes

* Fri Aug 29 2003 Jeremy Katz <katzj@redhat.com> 3.5.10-1
- clean up bogus warning in installkernel
- only try to do grub configs on arches which support grub (#103261)

* Thu Aug  7 2003 Matt Wilson <msw@redhat.com> 3.5.9-1
- add \n to error messages in grubby
- NUL terminate buffer returned from readlink properly
- symlinks are most likely relative, chdir to / before trying to
  follow them
- yaboot needs boot prefix
- silo needs boot prefix too

* Wed Jul 30 2003 Jeremy Katz <katzj@redhat.com> 
- grubby: don't segfault on label=\n (reported by dburcaw)

* Thu Jul 24 2003 Jeremy Katz <katzj@redhat.com> 
- grubby: patch from zaitcev for uninitialized variable that can get 
  hit in the zipl case

* Mon Jul 21 2003 Jeremy Katz <katzj@redhat.com> 3.5.8-1
- bump initrd size (#99525)

* Wed Jul  9 2003 Jeremy Katz <katzj@redhat.com> 3.5.7-1
- pick modules from /lib/modules/$(uname -r)/updates first
- be less confused by more than one module of a name

* Wed Jun 25 2003 Jeremy Katz <katzj@redhat.com> 3.5.6-1
- unbreak reading module options from modules.conf again (#97982)

* Fri Jun 20 2003 Bill Nottingham <notting@redhat.com> 3.5.5-1
- fix modules.dep usage for 2.5/2.6

* Fri Jun 20 2003 Jeremy Katz <katzj@redhat.com> 3.5.4-1
- handle more bizarre modules.conf constructs (notting)

* Thu Jun 12 2003 Jeremy Katz <katzj@redhat.com> 3.5.3-1
- mkinitrd: fix copying of pvs (#97314, #97289)
- mkinitrd: use pvscan instead of lvmdiskscan to find PVs to work 
  better on other arches
- mkinitrd: better check for dasd existence
- mkinitrd: make certain lvm-mod is included if root on lvm

* Wed Jun 11 2003 Jeremy Katz <katzj@redhat.com> 3.5.2-1
- mkinitrd: revert use of modprobe -c.  it breaks in the installer when we 
  don't have a modules.dep for the BOOT kernel
- nash: return pivot_root call correctly (#97753)

* Wed Jun 11 2003 Jeremy Katz <katzj@redhat.com> 3.5.1-1
- nash: fix syscall bits with gcc 3.3 on s390
- new-kernel-pkg: do depmod before mkinitrd (#97218)

* Tue Jun 10 2003 Jeremy Katz <katzj@redhat.com> 3.5.0-1
- mkinitrd: add patch from gc@mandrakesoft.com to determine module 
  deps from modules.dep (#87873)
- tweak patch to not break weird cases where module deps aren't all 
  you need :/
- grubby: don't remove the last kernel (#60041)
- mkinitrd: use modprobe -c to find module options (#89794)

* Tue May 20 2003 Matt Wilson <msw@redhat.com> 3.4.52-1
- use addSystemMap to build the image for iSeries (#91187)

* Fri May 16 2003 Jeremy Katz <katzj@redhat.com> 3.4.51-1
- grubby: error out gracefully if we run out of space (#85424)
- mkinitrd: copy parent dirs for pvs (#88962)
- mkinitrd: exit with an exit status if tar fails (#90123)
- new-kernel-pkg: only use the first entry for / (#90155)
- grubby: fix a buffer overflow  (#90444)

* Wed Apr 30 2003 Jeremy Katz <katzj@redhat.com> 3.4.50-1
- fix typo in new-kernel-pkg for iSeries

* Wed Apr 30 2003 Elliot Lee <sopwith@redhat.com>
- BuildRequires: popt
- Change grubby Makefile to static-link popt a bit more cleanly

* Thu Apr 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.49.1-1
- use Arjan's suggestion of vmlinitrd for the kernel + initrd combo file

* Thu Apr 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.49-2
- fix description referencing /etc/conf.modules (#89558)

* Thu Apr 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.49-2
- require ppc64-utils on ppc

* Fri Apr 18 2003 Jeremy Katz <katzj@redhat.com> 3.4.49-1
- new-kernel-pkg: on iSeries, we don't have a boot loader, just make the 
  kernel + initrd combo file (/boot/vmlinux-version.img)

* Mon Apr 07 2003 Karsten Hopp <karsten@redhat.com> 3.4.48-1
- Fix segfault on mainframe

* Wed Mar 26 2003 Jeremy Katz <katzj@redhat.com> 3.4.47-1
- mkinitrd: fix using options for loading modules
- mkinitrd: don't use kernel parameters for dasd at mkinitrd time, 
  use what's in modules.conf

* Mon Mar 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.46-1
- new-kernel-pkg: add necessary bits for s390, some logic cleanups
- grubby: fix root detection for s390{,x}

* Sun Mar 23 2003 Jeremy Katz <katzj@redhat.com> 3.4.45-1
- grubby: add silo support (sparc)
- grubby: add zipl support (s390{,x})
- add grubby test cases for zipl support

* Wed Mar 19 2003 Jeremy Katz <katzj@redhat.com> 3.4.44.1-1
- fix dasd option reading

* Fri Mar 14 2003 Phil Knirsch <pknirsch@redhat.com> 3.4.44
- Added automatic dasd= parameters for kernel parameter on s390(x).

* Tue Mar  4 2003 Jeremy Katz <katzj@redhat.com> 3.4.43-1
- apply ppc patches for new-kernel-pkg and installkernel from Dan 
  Burcaw <dburcaw@terrasoftsolutions.com>
- man page tweak (#85471)

* Tue Feb 18 2003 Jeremy Katz <katzj@redhat.com> 3.4.42-1
- grubby: fix segfault from uninitialized variable (#84128)

* Tue Feb 11 2003 Jeremy Katz <katzj@redhat.com> 3.4.41-1
- nash: add readlink
- use readlink for rootdev to handle symlinks to root devs (#83391)

* Tue Feb  4 2003 Jeremy Katz <katzj@redhat.com> 3.4.40-1
- fix i2o module ordering (#83447)
- ifarch'd build requires of dietlibc now that the build system has a way to
  handle these

* Sat Feb 01 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- change one test from a number to a string test that could otherwise
  fail in not properly setup chroot environments

* Fri Jan 31 2003 <ewt@redhat.com>
- added support for yaboot
- test script runs tests for all platforms
- separated elilo configuration from lilo mode, allowing elilo specific
  tests to be run on any platform

* Sun Jan 26 2003 <ewt@redhat.com>
- grubby now shortens lilo titles to ensure they are less then 16 characters
  long (76236)
- mkinitrd would only turn on /dev/md0 if raid was needed; now it enables
  all raid devices listed in /proc/mdstat (82209)
- use product name from /etc/redhat-release to generate label in grub.conf
  (82352)

* Mon Jan 20 2003 Bill Nottingham <notting@redhat.com> 3.4.36-1
- don't error out running awk on /proc/mdstat if /proc/mdstat isn't
  there

* Tue Jan 14 2003 <ewt@redhat.com>
- all mkdev() actions will create directories as needed (some code in
  mkdevices is now obsolete; I'll remove it later) (#73317)
- added mkdev command to test the above
- support diratime/nodiratime mount options (#78738)
- grubby will follow symlinks when writing new config file (#78713)
- don't depend on raidtab, use /proc/mdstat instead (#80424) this covers
  both mkinitrd and grubby

* Sun Jan  5 2003 Jeremy Katz <katzj@redhat.com> 3.4.34-1
- grubby: fix segfault finding default if default doesn't have a root= (#66000)
- don't include usb modules by default.  pass --with-usb to get usb modules
- make sure kudzu exists before trying to exec it
- handle multiple scsi hosts being present (#77422)
- add /usr/sbin to default path (#79581)
- fix using --builtin= (#80448)
- grubby: preserve the mode on config files (#80776)

* Mon Dec 16 2002 Jeremy Katz <katzj@redhat.com>
- errno fixes

* Tue Dec 03 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- /sbin/new-kernel-pkg: fix a test to have correct ""

* Fri Nov 22 2002 Jeremy Katz <katzj@redhat.com>
- mkinitrd: more gzipped module fixes

* Thu Nov 21 2002 Jeremy Katz <katzj@redhat.com>
- mkinitrd: add support for finding gzipped modules
- mkinitrd: don't be noisy if we don't have lvm-mod loaded

* Wed Nov  6 2002 Jeremy Katz <katzj@redhat.com>
- grubby: don't bail when looking for root in appends of lilo-style configs
- include grubby on x86_64

* Thu Sep 26 2002 Nalin Dahyabhai <nalin@redhat.com>
- fix some syntax errors
- use grep's -q flag to save a redirect in places where we're not redirecting
  stderr

* Thu Sep  5 2002 Jeremy Katz <katzj@redhat.com>
- grubby could segfault by going into its lilo checking if it couldn't find 
  a default to copy (default had no root= and --bad-image-okay wasn't 
  being used)

* Mon Sep  2 2002 Jeremy Katz <katzj@redhat.com>
- nash: create directories if needed in mkdevices command (#73090)
- grubby: handle lilo case of non-linux default (#72202)

* Sat Aug 31 2002 Jeremy Katz <katzj@redhat.com>
- grubby: fix for case like 'append = " hdc=ide-scsi "' (#68802)

* Fri Aug 30 2002 Bill Nottingham <notting@redhat.com>
- fix firewire stuff (#72916)

* Fri Aug 23 2002 Bill Nottingham <notting@redhat.com>
- fix mpt fusion stuff

* Tue Aug 13 2002 Jeremy Katz <katzj@redhat.com>
- /boot/efi/redhat -> /boot/efi/EFI/redhat on ia64

* Sun Aug 11 2002 Jeremy Katz <katzj@redhat.com>
- fix grubby to work correctly on ia64

* Thu Aug 08 2002 Michael Fulbright <msf@redhat.com>
- added sleep command to nash and fixed creating initrd with / or /boot on usb

* Tue Jul 30 2002 Jeremy Katz <katzj@redhat.com>
- grubby: adding kernels to lilo.conf when not using root=LABEL will work 
  now too

* Fri Jul 26 2002 Erik Troan <ewt@redhat.com>
- didn't close /proc/partitions in mkdevices

* Thu Jul 25 2002 Jeremy Katz <katzj@redhat.com>
- grubby: fix adding kernels to lilo when using root=LABEL

* Wed Jul 24 2002 Erik Troan <ewt@redhat.com>
- added and used mkdevices command (68959)

* Wed Jul 17 2002 Erik Troan <ewt@redhat.com>
- do proper probing to check root=LABEL
- --bootloader-probe didn't support /etc/sysconfig/grub

* Fri Jul 12 2002 Erik Troan <ewt@redhat.com>
- don't sanity check root=LABEL right now; probing might make sense?

* Wed Jul 10 2002 Erik Troan <ewt@redhat.com>
- --ifneeded is obsolete; we always need initrds
- grubby lets you specify multiple indexes for --info
- grubby lets you select kernels by title
- added showlabels to nash
- new-kernel-pkg sets the root device from /etc/fstab rather then inheriting it
- new-kernel-pkg removes all entries w/ a duplicate label (67459)

* Mon Jul 08 2002 Erik Troan <ewt@redhat.com>
- usb root device code could fail, causing no initrd to be made

* Thu Jun 27 2002 Erik Troan <ewt@redhat.com>
- grubby didn't add new kernels properly

* Thu Jun 27 2002 Erik Troan <ewt@redhat.com>
- support root on usb devices

* Wed Jun 26 2002 Erik Troan <ewt@redhat.com>
- other= in lilo.conf wasn't being parsed out properly

* Mon Jun 24 2002 Erik Troan <ewt@redhat.com>
- changed --add-kernel implementation so that --args gets handled properly

* Sun Jun 23 2002 Erik Troan <ewt@redhat.com>
- added loadinitrd (used by mkbootdisk) on ia32 and sparc
- modules "off" and "null" should be ignored (67086)
- mkrootdev looks for root=LABEL=/ in /proc/cmdline, so root by label
  works again (fully determined by root= kernel parameter)
- added --update-kernel and --remove-args arguments to grubby
- kernel specification of ALL supported by grubby
- DEFAULT accepted much more consistently
- grubby --info displays info on all kernels specified, not just the first
- ext3 need mbcache now (67354)
- grubby allows config file entry numbers to be used as kernel paths
- support /etc/sysconfig/grub.conf
- display lba info from lilo.conf file in --info

* Thu Jun 13 2002 Jeremy Katz <katzj@redhat.com>
- don't run lilo twice on kernel removal in new-kernel-pkg
- don't run grubby to add/remove kernels from new-kernel-pkg if 
  bootloader config doesn't 

* Tue Jun 11 2002 Erik Troan <ewt@redhat.com>
- added --bootloader-probe to grubby
- wrote a man page for grubby
- include grubby on ia64
- updated new-kernel-pkg to work with lilo/elilo
- added --info=DEFAULT option

* Mon Jun 10 2002 Jeremy Katz <katzj@redhat.com>
- start raid before lvm so that you can have root on lvm on raid (#66175)

* Tue Jun 04 2002 Erik Troan <ewt@redhat.com>
- failed to initialize a variable in grubby

* Fri May 31 2002 Erik Troan <ewt@redhat.com>
- added --grub option so grub tests could run on ia64
- added some basic tests of lilo default directive handling

* Wed May 29 2002 Jeremy Katz <katzj@redhat.com>
- require lvm

* Tue May 28 2002 Bill Nottingham <notting@redhat.com>
- fix umounting of /initrd when pivoting

* Tue May 28 2002 Erik Troan <ewt@redhat.com>
- marked /sbin/installkernel as %config (53006)
- run make test during build

* Wed May 22 2002 Erik Troan <ewt@redhat.com>
- added --nopivot (53679)
- honor INSTALL_PATH in installkernel (32833)
- installkernel versions old kernels as well (52756)
- lilo support added to grubby

* Tue May 21 2002 Erik Troan <ewt@redhat.com>
- cleaned up usage message
- added --omit-lvm-modules to man page
- added --builtin option (65250)
- skip comments in fstab (65249)
- added findlodev to nash, use that to pick block device (63421)
- support -o option in nash's mount (59185)
- look for xfs_dmapi (60066)
- added > support for executed commands (61180)
- grubby copies permissions from old config file (59227)
- use options from fstab for root filesystem (56071)
- try and be better about returning nonzero on error (60203)
- make modprobe symlink properly to avoid kernel message (62145)
- support linear raid (12775)
- support fallback option in grub config (54794)
- comments in template entries not handled quite right (65198)

* Sat Apr 20 2002 Erik Troan <ewt@redhat.com>
- grubby does a better job of not adding superfluous default= lines

* Wed Apr 17 2002 Erik Troan <ewt@redhat.com>
- preload works again

* Wed Apr 10 2002 Jeremy Katz <katzj@redhat.com>
- revert to not mounting by label

* Fri Apr  5 2002 Jeremy Katz <katzj@redhat.com>
- include pbrown's changes to load parport_pc when needing ppa.o (#35360)

* Thu Apr  4 2002 Jeremy Katz <katzj@redhat.com>
- fix redirection bug (#62623)
- create proper link of /sbin->/bin in initrd (#62199)

* Thu Mar 28 2002 Jeremy Katz <katzj@redhat.com>
- prereq dev package so that we always have the dev package before we get run

* Fri Mar 22 2002 Jeremy Katz <katzj@redhat.com>
- duh, that won't work.  fix it
- don't require lvm tools right now

* Thu Mar 21 2002 Jeremy Katz <katzj@redhat.com>
- fix nash to create directories for devices like cciss and ida

* Tue Feb  5 2002 Bill Nottingham <notting@redhat.com>
- run mkinitrd with -f in new-kernel-pkg
- don't run lilo in /sbin/installkernel

* Fri Feb  1 2002 Jeremy Katz <katzj@redhat.com>
- require lvm

* Thu Jan 31 2002 Jeremy Katz <katzj@redhat.com>
- clean up warnings for when /proc isn't mounted

* Tue Jan 29 2002 Jeremy Katz <katzj@redhat.com>
- fix probing for LVM usage to require a volume group to exist before adding
  the module
- --omit-lvm-modules will omit LVM modules
- add support for root device being LVM

* Wed Jan 16 2002 Erik Troan <ewt@redhat.com>
- look for a non /tmpfs directory
- added support for xfs
- use with raid md.o if it exists
- fixed bug in echo
- use find form nash rather then /usr (mkinitrd shouldn't need /usr
  mounted)

* Fri Jan 11 2002 Erik Troan <ewt@redhat.com>
- added support for mounting root filesystem by label
- switched to dietlibc from minilibc
- fix so --preload= works [33675,57560,44377]
- added info on --image-version and --nocompress to man page [57560]
- set fileystem check interval to 0 in case the system clock
  is borked [51454]
- give a proper error when run by a user other then root [27218,53159]
- grubby statically linked against popt [55305]
- cleaned up verbose output a bit [21791]

* Tue Dec 18 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add LVM module when LVM is used

* Wed Sep  5 2001 Jeremy Katz <katzj@redhat.com>
- grubby shouldn't blow away default=saved lines (#52981)

* Fri Aug 31 2001 Jeremy Katz <katzj@redhat.com>
- fix new-kernel-pkg --mkinitrd for ia64

* Thu Aug 30 2001 Erik Troan <ewt@redhat.com>
- fixed bug handling invalid default (MF #52889)
- in some cases we would set the default to point at a removed image

* Wed Aug 29 2001 Erik Troan <ewt@redhat.com>
- minor grubby fixes

* Tue Aug 28 2001 Jeremy Katz <katzj@redhat.com>
- let new-kernel-pkg be able to do more (initrds, modules.*)
- include grubby only on x86

* Mon Aug 27 2001 Jeremy Katz <katzj@redhat.com>
- more grubby fixups for having a /boot
- added new-kernel-pkg

* Sun Aug 26 2001 Erik Troan <ewt@redhat.com>
- added grubby
- added installkernel

* Fri Aug  3 2001 Matt Wilson <msw@redhat.com>
- make consoles with the correct minor numbers
- applied patch from hjl to fix fstab parsing (#50819)

* Fri Jul 20 2001 Jeremy Katz <katzj@redhat.com>
- skip errors finding jbd as a module if we're skipping them trying to find
  ext3 so that you can build a kernel with ext3 built-in and still use an
  initrd

* Wed Jul 11 2001 Bill Nottingham <notting@redhat.com>
- don't print errors if /etc/raidtab doesn't exist
- or /etc/{modules.conf,conf.modules}, for that matter

* Fri Jul  6 2001 Matt Wilson <msw@redhat.com>
- don't dig through /etc/fstab to find out if we have a filesystem on
  a RAID device, it's usually mounted by label so /dev/mdN isn't there
  at all (#46525)

* Tue Jun 26 2001 Bill Nottingham <notting@redhat.com>
- require filesystem >= 2.1.0, otherwise we don't boot

* Thu Jun 21 2001 Erik Troan <ewt@redhat.com>
- added a bunch of commands to nash
- use pivot_root
- support ext3

* Fri Jun 08 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- delete the exclusivearch line completely

* Fri Mar 23 2001 Matt Wilson <msw@redhat.com>
- reset the state of findmodule after getting the modules we need

* Wed Feb 28 2001 Matt Wilson <msw@redhat.com>
- changed the Requires on mktemp from >= 1.5 to >= 1.5-5 (which included
  -d support) (#30127)

* Fri Feb 23 2001 Erik Troan <ewt@redhat.com>
- let nash be invoked as modprobe to avoid a modprobe failure to exec
- nash will try to run arbitrary commands now (removing insmod as a special 
  case)

* Mon Feb 12 2001 Matt Wilson <msw@redhat.com>
- add findutils to Requires line (#27269)

* Thu Feb  8 2001 Matt Wilson <msw@redhat.com>
- added checks to load the modules i2o_block needs

* Wed Feb  7 2001 Bill Nottingham <notting@redhat.com>
- fix utterly broken build

* Wed Jan 31 2001 Helge Deller <hdeller@redhat.com>
- added mandir to nash Makefile (RH 6.x compatibility) 

* Tue Jan 30 2001 Erik Troan <ewt@redhat.com>
- added dependency on mktemp

* Thu Jan 25 2001 Erik Troan <ewt@redhat.com>
- we need to insert xor.o before raid5.o

* Wed Jan 24 2001 Matt Wilson <msw@redhat.com>
- code in RAID_AUTORUN ioctl fallback
- fixed raidstart check flag from -z to -n

* Tue Jan 23 2001 Erik Troan <ewt@redhat.com>
- switched to using nash from sash

* Tue Jan 23 2001 Matt Wilson <msw@redhat.com>
- added patch from twaugh to avoid blindly adding scsi_mod
  and sd_mod to initrd if they are not needed (#24114)

* Thu Jan 11 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Enlarge initrds, needed for systems with both IDE and SCSI
  (Bug #23846)
- Version 2.[6789] probably shouldn't identify itself as 2.6
  with --version. ;)
- bzip2 source

* Wed Dec 20 2000 Erik Troan <ewt@redhat.com>
- let the kernel autoload ide-cd

* Fri Dec 08 2000 Erik Troan <ewt@redhat.com>
- added modular ide support

* Wed Aug 30 2000 Nalin Dahyabhai <nalin@redhat.com>
- use mktemp to create temporary files and directories

* Sat Aug 05 2000 Erik Troan <ewt@redhat.com>
- changes from Keith Owens for 2.4

* Tue Jul  4 2000 Matt Wilson <msw@redhat.com>
- build on alpha

* Mon Jun 26 2000 Bill Nottingham <notting@redhat.com>
- ignore 'unknown' aliases (they shouldn't be there anyways)

* Thu Jun  1 2000 Bill Nottingham <notting@redhat.com>
- build on ia64
- bump up initrd size on ia64
- modules.confiscation, /usr/man -> /usr/share/man

* Tue May  2 2000 Nalin Dahyabhai <nalin@redhat.com>
- make RPM pick up man page, regardless of compression

* Tue Feb 29 2000 Matt Wilson <msw@redhat.com>
- add requirement for /sbin/losetup

* Mon Feb  7 2000 Matt Wilson <msw@redhat.com>
- gzip manpage

* Thu Feb  3 2000 Matt Wilson <msw@redhat.com>
- gzip manpage

* Mon Jan 10 2000 Erik Troan <ewt@redhat.com>
- use sash, not ash

* Mon Jan  3 2000 Matt Wilson <msw@redhat.com>
- use ash.static for /bin/sh, not sash

* Sat Jan 1 2000 Erik Troan <ewt@redhat.com>
- configure loopback devices

* Tue Sep 28 1999 Bill Nottingham <notting@redhat.com>
- sparc fixup from jakub

* Wed Sep 22 1999 Michael K. Johnson <johnsonm@redhat.com>
- fix cleanup (blush!)

* Tue Sep 21 1999 Michael K. Johnson <johnsonm@redhat.com>
- now works when /usr is not mounted (do not rely on /usr/bin/install)
- slight cleanups, better usage message

* Thu Jul 29 1999 Michael K. Johnson <johnsonm@redhat.com>
- Now automatically includes necessary raid modules
- --omit-raid-modules now omits raid modules
- tiny doc updates

* Thu Jul 29 1999 Bill Nottingham <notting@redhat.com>
- updates from bugzila (#4243, #4244)

* Sat Mar 27 1999 Matt Wilson <msw@redhat.com>
- --omit-scsi-modules now omits all scsi modules
- updated documentation
- mkinitrd now grabs scsi_hostadapter modules from anywhere -
  some RAID controller modules live in block/

* Thu Feb 25 1999 Matt Wilson <msw@redhat.com>
- updated description

* Mon Jan 11 1999 Matt Wilson <msw@redhat.com>
- Ignore the absence of scsi modules, include them if they are there, but
  don't complain if they are not.
- changed --no-scsi-modules to --omit-scsi-modules (as it should have been)

* Thu Nov  5 1998 Jeff Johnson <jbj@redhat.com>
- import from ultrapenguin 1.1.

* Tue Oct 20 1998 Jakub Jelinek <jj@ultra.linux.cz>
- fix for combined sparc/sparc64 insmod, also pluto module is really
  fc4:soc:pluto and we don't look at deps, so special case it.

* Sat Aug 29 1998 Erik Troan <ewt@redhat.com>
- replaced --needs-scsi-mods (which is now the default) with
  --omit-scsi-mods

* Fri Aug  7 1998 Jeff Johnson <jbj@redhat.com>
- correct obscure regex/shell interaction (hardwires tabs on line 232)

* Mon Jan 12 1998 Erik Troan <ewt@redhat.com>
- added 'make archive' rule to Makefile
- rewrote install procedure for more robust version handling
- be smarter about grabbing options from /etc/conf.modules

* Mon Oct 20 1997 Erik Troan <ewt@redhat.com>
- made it use /bin/ash.static

* Wed Apr 16 1997 Erik Troan <ewt@redhat.com>
- Only use '-s' to install binaries if /usr/bin/strip is present.
- Use an image size of 2500 if binaries can't be stripped (1500 otherwise)
- Don't use "mount -o loop" anymore -- losetup the proper devices manually
- Requires losetup, e2fsprogs

* Wed Mar 12 1997 Michael K. Johnson <johnsonm@redhat.com>
- Fixed a bug in parsing options.
- Changed to use a build tree, then copy the finished tree into the
  image after it is built.
- Added patches derived from ones written by Christian Hechelmann which
  add an option to put the kernel version number at the end of the module
  name and use install -s to strip binaries on the fly.
