/* ee-reg.h -- Definitions for symbolic names for the ee/dvp assembler.
   Copyright (C) 1997, 1998, 1999, 2000 Free Software Foundation.

   This file is part of GAS, the GNU Assembler.

   GAS is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GAS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GAS; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef	SRS_REG_H
#define	SRS_REG_H

#define	MREG_GPR 	1
#define	MREG_COP0	2
#define	MREG_COP0C	4	// not used - need it for insn decode
#define	MREG_COP1	8
#define	MREG_COP1C	16
#define	MREG_COP2	32
#define	MREG_VF		MREG_COP2
#define	MREG_COP2C	64
#define	MREG_VI		MREG_COP2C

#define	MREG_COP	(MREG_COP0|MREG_COP1|MREG_COP1C|MREG_COP2|MREG_COP2C)
#define	MREG_ANY	0xffff

/* names can be $<num> $defname or defname
   or user_name.. 
   user_name is set by .setreg/.getreg, cleared by .endreg */

typedef	struct
{
  char *DefName;	/* default name			*/
  char *Alt0Name;	/* alternative user name	*/
  char *Alt1Name;	/* alternative user name	*/
  char *UserName;	/* set by getreg/endreg		*/
} rName;

#define	NUM_RNAMES	(sizeof(rName)/sizeof(char *))

struct myreg
{
  union						
  {
    rName rn;
    char *nt[NUM_RNAMES];
  } Name;
  struct myreg *PrevInPool;
  struct myreg *NextInPool;
  unsigned short reg_no;
  unsigned short RegType;
  char IsPooled;
  char IsPoolable;
  char IsAllocd;		/* currently allocated */
  char *complete_chars;
};

typedef	struct myreg ee_reg;

/* Returns register number corresponding to NAME with type FIND_MASK.
 * The width of the register is in SIZE. Returns -1 if NAME is not found.
 */
int ee_find_reg PARAMS ((char* name, unsigned short find_mask, int* size));

ee_reg* ee_find_reg_struct PARAMS ((char* name, unsigned short msk, int* sz));

#endif
