;;  calmrisc16
;;   Copyright (C) 2001 by  Red Hat, Incorporated. All rights reserved.
;; 
;; Permission to use, copy, modify, and distribute this software
;; is freely granted, provided that this notice is preserved.
;; 
;; The 'target-independent' memmove version is not 16-bit clean, and we can
;; do a lot better with target specific code anyways.
	.file "memmove.S"

	.section .text
	.align 1
	.global _memmove
_memmove:
	ldw a8,@[sp+2]
	ldw a9,@[sp+6]
	ldw r6,@[sp+10]
	ldw r7,@[sp+12]
	ld r1,r9
	ld r0,e9
	sub r1,r8
	ld r2,e8
	sbc r0,r2
	add r1,r7
	adc r0,r6
	brtd .Lbackwards
	ld r10,#1
	tst r9,r10
	jpt ___memcpy_6789_even
	jmp ___memcpy_6789_odd
.Lbackwards:
	add r8,r7
	adc r2,r6
	ld e8,r2
	ld r2,e9
	add r9,r7
	adc r2,r6
	ld e9,r2
	;; We know that one of r6 and r7 must be non-zero, since otherwise
	;; the length would be zero, and we'd use memcpy.
	sub r7,#1
	brf .Loop_check_r6
.Loop:
	sub a9,#1
	sub a8,#1
	ldb r2,@[a9+0]
	bnzd r7,.Loop
	ldb @[a8+0],r2
.Loop_check_r6:
	sub r6,#1
	brt .Loop
	jmp a14
