/*************************************************************************
**
** Copyright 1991 Integrated Device Technology, Inc.
**	All Rights Reserved
**
** idt_csu.s -- IDT stand alone startup code
**
**************************************************************************/
#include "iregdef.h" 
#include "idtcpu.h"  
#include "idtmon.h"  
#include "saunder.h"



.extern _fbss,4		  /* this is defined by the linker */
.extern end,4		  /* this is defined by the linker */



#ifndef	XDS
	.text		  /* for MIPS c compiler	*/
#else
	.data		  /* for IDT/c define _fdata	*/
	.globl	__fdata
__fdata:
	.word	3106	  /* magic			*/
	.bss		  /* define _fbss		*/
	.globl	__fbss
__fbss:
	.word	3107	  /* magic			*/
	.text		  /* define _ftext		*/
	.globl	__ftext
__ftext:
#endif

#define TMP_STKSIZE  1024 

/**************************************************************************
**
**  start - Stand alone start up code required for R3000
**
**  Loaded so that it accepts R3000 control on RESET
**
**	1)  Initialize the STATUS Register
**		a) Clear parity error bit
**		b)  set co_processor 1 usable bit ON
**		c)  clear all IntMask Enables
**		d)  set kernel/disabled mode
**	2)  Initialize Cause Register
**		a)  clear software interrupt bits       
**	3)  Determine FPU installed or not (3051)
**		if not, clear CoProcessor 1 usable bit
**	4)  Clear bss area
**	5)  MUST allocate temporary stack until memory size determined
**	    It MUST be uncached to prevent overwriting when caches swapped
**      6)  Install exception handlers
**		UTLB miss at 80000000; general exceptions at 80000080
**	7)  Determine memory and cache sizes
**	8)  Establish permanent stack (cached or uncached as defined)
**	9)  Flush Instruction and Data caches
**     10)  If there is a Translation Lookaside Buffer, Clear the TLB
**     11)  Execute initialization code if the IDT/c library is to be used
** 
**  jump to user's "main()"
**
**	
***************************************************************************/

FRAME(start,sp,0,ra)


/**************************************************************************
**
**    Initialize Control Registers:
**
**        MUST indicate FPA enabled in order to test if FPA present
**		then set for use depending on result 
**
***************************************************************************/ 

	.globl	_start	
_start:
	.globl	__start
__start:
	.set	noreorder
	li	v0,SR_PE|SR_CU1	        /* reset parity error and set */
					/* cp1 usable */
	mtc0	v0,C0_SR		/* clr IntMsks/ kernel/disabled mode */
	mtc0	zero,C0_CAUSE		/* clear software interrupts */


/*
**	check to see if an fpu is really plugged in 
*/
	li	t3,0xaaaa5555		/*  put a's and 5's in t3	*/
	mtc1	t3,fp0			/* try to write them into fp0   */	
	mtc1	zero,fp1		/* try to write zero in fp	*/
	mfc1	t0,fp0
	mfc1	t1,fp1
	nop
	bne	t0,t3,1f		/* branch if no match  */
	nop
	bne	t1,zero,1f		/* double check for positive id   */
	nop
	j	2f			/* status register already correct  */
	nop
1:
	li	v0, SR_PE		/* reset parity error/NO cp1 usable */
	mtc0	v0, C0_SR		/* reset status register */
2:
     #ifndef XDS			 
	la  	gp, _gp			
     #endif XDS

	la	v0,_fbss 		/* clear bss before using it */
	la	v1,end 			/* end of bss */
3:	sw	zero,0(v0)
	bltu	v0,v1,3b
	add	v0,4

/************************************************************************
**
** 	Temporary Stack - needed to  handle stack saves until
**			  memory size is determined and permanent stack set
**
**			  MUST be uncached to avoid confusion at cache
**			       switching during memory sizing
**
*************************************************************************/
	or	v0, K1BASE		/* switch to uncached */
	add	v1, v0, TMP_STKSIZE 	/* end of bss + length of tmp stack */
	sub	v1, v1, (4*4)		/* overhead */
	move	sp, v1			/* set sp to top of stack */
4:	sw	zero, 0(v0)
	bltu	v0, v1, 4b		/* clear out temp stack */
	add	v0, 4
	
	jal	init_exc_vecs		/* install exception handlers */ 
	nop				/* MUST do before memory probes */

	la	v0, 5f
	li	v1, K1BASE		/* force into uncached space */
	or	v0, v1			/* during memory/cache probes */
	j	v0
	nop
5:
	jal	config_memory		/* memory size */
	nop
	move	a0, v0			/* save size in structure */
	jal	config_Icache
	nop
	jal	config_Dcache		/* determine size of D & I caches */
	nop	
	move	v0, a0			/* mem_size */



/**************************************************************************
**
**  Permanent Stack - now know top of memory, put permanent stack there	
**
***************************************************************************/ 

	la	t2, _fbss		/* cache mode as linked */
	and	t2, 0xF0000000		/* isolate segment */
	la	t1, 6f
	or  	t1, t2
	j	t1			/* back to original cache mode */
	nop
6:
	or 	v0, t2			/* stack back to original cache mode */
	addiu   v0,v0,-16		/* overhead */
	move	sp, v0			/* now replace count w top of memory */
	move	v1, v0
	subu	v1, P_STACKSIZE 	/* clear requested stack size */

7:	sw	zero, 0(v1)		/* clear P_STACKSIZE  stack */
	bltu	v1,v0,7b
	add	v1, 4
	.set	reorder

	jal	flush_Icache	
	jal	flush_Dcache		/* flush Data & Instruction caches */



/**************************************************************************
**
**	If this chip supports a Translation Lookaside Buffer, clear it
**
***************************************************************************/ 

	.set	noreorder
	mfc0	t1,  C0_SR		/* look at Status Register */
	nop
	.set 	reorder
	li	t2, SR_TS		/* TLB Shutdown bit */
	and 	t1,t2      		/* TLB Shutdown if 1 */
	bnez	t1, 8f			/* skip clearing if no TLB */	
	jal	init_tlb		/* clear the tlb */


/************************************************************************
**
**  Initialization required if using IDT/c or libidtc.a, standard C Lib 
**
**  can SKIP if not necessary for application
**
************************************************************************/
8:

	jal	_init_sbrk
	jal	_init_file
/***********************  END I/O initialization **********************/


	move	ra,zero
	jal	main

	move	a0,v0
	jal	exit

ENDFRAME(start)

/* defined in newlib
	.globl	_cleanup
_cleanup:
	jr	ra
*/
