/*
** Copyright 1989 by IDT Integrated Device Tecnology, Inc.
**
** idt_entrypt.h Header file used to link standalone programs
**		 with the IDT prom monitor.
**
** these routines access IDT prom monitor routines, and may be used
** by standalone programs that would like to use prom io
*/

/*
** PROM_LINK -- link to prom entry point
*/
#ifndef XDS
#define	PROM_LINK(name,entry)		\
	.globl	name;			\
	.ent	name;			\
name:	la	$2,+entry;		\
	j	$2;			\
	.end name	
#else
#define PROM_LINK(name,entry)		\
	.globl _##name;			\
_##name: la	$2,+entry;		\
	j	$2;			\

#endif XDS


#define	PROM_ENTRY(x)	(0xbfc00000+((x)*8))

#define PROM_RESET	PROM_ENTRY(0)
#define PROM_NOT_IMP	PROM_ENTRY(1)
#define PROM_RESTART	PROM_ENTRY(2)
#define PROM_REINIT	PROM_ENTRY(3)
#define	PROM_OPEN	PROM_ENTRY(6)
#define	PROM_READ	PROM_ENTRY(7)
#define	PROM_WRITE	PROM_ENTRY(8)
#define	PROM_IOCTL	PROM_ENTRY(9)
#define	PROM_CLOSE	PROM_ENTRY(10)
#define	PROM_GETCHAR	PROM_ENTRY(11)
#define	PROM_PUTCHAR	PROM_ENTRY(12)
#define	PROM_SHOWCHAR	PROM_ENTRY(13)
#define	PROM_GETS	PROM_ENTRY(14)
#define	PROM_PUTS	PROM_ENTRY(15)
#define	PROM_PRINTF	PROM_ENTRY(16)
#define	PROM_RETURN	PROM_ENTRY(17)
#define PROM_FLUSHCACHE	PROM_ENTRY(28)
#define PROM_CLEARCACHE	PROM_ENTRY(29)
#define PROM_SETJMP	PROM_ENTRY(30)
#define PROM_LONGJMP	PROM_ENTRY(31)
#define PROM_UTLBEXC	PROM_ENTRY(32)
#define PROM_ATOB	PROM_ENTRY(35)
#define PROM_STRCMP	PROM_ENTRY(36)
#define PROM_STRLEN	PROM_ENTRY(37)
#define PROM_STRCPY	PROM_ENTRY(38)
#define PROM_STRCAT	PROM_ENTRY(39)
#define PROM_CMDPARSE	PROM_ENTRY(40)
#define PROM_GETRANGE	PROM_ENTRY(41)
#define PROM_TOKEN	PROM_ENTRY(42)
#define PROM_HELP	PROM_ENTRY(43)
#define PROM_NORMEXC	PROM_ENTRY(48)
#define PROM_GETMCONF	PROM_ENTRY(55)
#define PROM_SETMCONF	PROM_ENTRY(56)
#define PROM_NEWCMD	PROM_ENTRY(64)
#define PROM_NEWDEV	PROM_ENTRY(65)
#define PROM_FASTINT	PROM_ENTRY(66)
#define PROM_NORMINT	PROM_ENTRY(67)
