/*
 * Test the library maths functions using trusted precomputed test
 * vectors.
 * 
 * These vectors were originally generated on a sun3 with a 68881 using 80
 * bit precision, but ...
 * 
 * Each function is called with a variety of interesting arguments. Note that
 * many of the polynomials we use behave badly when the domain is
 * stressed, so the numbers in the vectors depend on what is useful to
 * test - eg sin(1e30) is pointless - the arg has to be reduced modulo pi,
 * and after that there's no bits of significance left to evaluate with -
 * any number would be just as precise as any other.
 * 
 */

#include "test.h"
#include <math.h>
#include <ieeefp.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <stdio.h>

int             inacc;

int             merror;
double          mretval = 64;
int             traperror = 1;
char           *mname;

int             verbose;

/* To test exceptions - we trap them all and return a known value */
int
_DEFUN(matherr, (e),
       struct exception *e)
{
    if (traperror) {
	merror = e->type + 12;
	mname = e->name;
	e->retval = mretval;
	errno = merror + 24;
	return 1;
    }
    return 0;
}

void
_DEFUN(translate_to, (file, r),
       FILE * file _AND
       double r)
{
    __ieee_double_shape_type bits;
    bits.value = r;
    fprintf(file, "0x%08x, 0x%08x", bits.parts.msw, bits.parts.lsw);
}

int
_DEFUN(ffcheck, (is, p, name, serrno, merror),
       double is _AND
       one_line_type * p _AND
       char *name _AND
       int serrno _AND
       int merror)
{
    /* Make sure the answer isn't to far wrong from the correct value */
    __ieee_double_shape_type correct, isbits;
    int             mag;
    isbits.value = is;

    correct.parts.msw = p->qs[0].msw;
    correct.parts.lsw = p->qs[0].lsw;

    mag = mag_of_error(correct.value, is);

    if (mag < p->error_bit) {
	inacc++;

	printf("%s:%d, inaccurate answer: bit %d (%08x%08x %08x%08x) (%g %g)\n",
	       name, p->line, mag,
	       correct.parts.msw,
	       correct.parts.lsw,
	       isbits.parts.msw,
	       isbits.parts.lsw,
	       correct.value, is);
    } else {
	printf("%s:%d, correct answer: bit %d (%08x%08x %08x%08x) (%g %g)\n",
	       name, p->line, mag,
	       correct.parts.msw,
	       correct.parts.lsw,
	       isbits.parts.msw,
	       isbits.parts.lsw,
	       correct.value, is);
    }

#if 0
    if (p->merror != merror) {
	printf("testing %s.c:%d, matherr wrong: %d %d\n",
	       name, p->line, merror, p->merror);
    }
    if (p->errno_val != errno) {
	printf("testing %s.c:%d, errno wrong: %d %d\n",
	       name, p->line, errno, p->errno_val);

    }
#endif

    return mag;
}

double
_DEFUN(thedouble, (msw, lsw),
       long msw _AND
       long lsw)
{
    __ieee_double_shape_type x;

    x.parts.msw = msw;
    x.parts.lsw = lsw;
    return x.value;
}

int             calc;
int             reduce;

_DEFUN(frontline, (f, mag, p, result, merror, errno, args, name),
       FILE * f _AND
       int mag _AND
       one_line_type * p _AND
       double result _AND
       int merror _AND
       int errno _AND
       char *args _AND
       char *name)
{
    if (reduce && p->error_bit < mag) {
	fprintf(f, "{%2d,", p->error_bit);
    } else {
	fprintf(f, "{%2d,", mag);
    }

    fprintf(f, "%2d,%3d,", merror, errno);
    fprintf(f, "__LINE__, ");

    if (calc) {
	translate_to(f, result);
    } else {
	translate_to(f, thedouble(p->qs[0].msw, p->qs[0].lsw));
    }

    fprintf(f, ", ");

    fprintf(f, "0x%08x, 0x%08x", p->qs[1].msw, p->qs[1].lsw);

    if (args[2]) {
	fprintf(f, ", ");
	fprintf(f, "0x%08x, 0x%08x", p->qs[2].msw, p->qs[2].lsw);
    }
    fprintf(f, "},	/* %g=f(%g", result,
	    thedouble(p->qs[1].msw, p->qs[1].lsw));

    if (args[2]) {
	fprintf(f, ", %g", thedouble(p->qs[2].msw, p->qs[2].lsw));
    }
    fprintf(f, ")*/\n");
}

_DEFUN(finish, (f, vector, result, p, args, name),
       FILE * f _AND
       int vector _AND
       double result _AND
       one_line_type * p _AND
       char *args _AND
       char *name)
{
    int             mag;

    mag = ffcheck(result, p, name, merror, errno);
    if (vector) {
	frontline(f, mag, p, result, merror, errno, args, name);
    }
}

int             redo;

_DEFUN(run_vector_1, (vector, p, func, name, args),
       int vector _AND
       one_line_type * p _AND
       char *func _AND
       char *name _AND
       char *args)
{
    FILE           *f;
    int             mag;
    double          result;

    if (vector) {

	VECOPEN(name, f);
    printf("FILE *f = %s\n", f);

	if (redo) {
	    double          k;

	    for (k = -.2; k < .2; k += 0.00132) {

		fprintf(f, "{1,1, 1,1, 0,0,0x%08x,0x%08x, 0x%08x, 0x%08x},\n",
			k, k + 4);

	    }

	    for (k = -1.2; k < 1.2; k += 0.01) {

		fprintf(f, "{1,1, 1,1, 0,0,0x%08x,0x%08x, 0x%08x, 0x%08x},\n",
			k, k + 4);

	    }
	    for (k = -M_PI * 2; k < M_PI * 2; k += M_PI / 2) {

		fprintf(f, "{1,1, 1,1, 0,0,0x%08x,0x%08x, 0x%08x, 0x%08x},\n",
			k, k + 4);

	    }

	    for (k = -30; k < 30; k += 1.7) {

		fprintf(f, "{2,2, 1,1, 0,0, 0x%08x,0x%08x, 0x%08x, 0x%08x},\n",
			k, k + 4);

	    }
	    VECCLOSE(f, name, args);
	    return;
	}
    }
    newfunc(name);
    while (p->line) {
	double          arg1 = thedouble(p->qs[1].msw, p->qs[1].lsw);
	double          arg2 = thedouble(p->qs[2].msw, p->qs[2].lsw);

	double          r;
	double          rf;

	errno = 0;
	merror = 0;
	mname = 0;

	line(p->line);

	merror = 0;
	errno = 123;

	if (strcmp(args, "dd") == 0) {
	    typedef double  _EXFUN((*pdblfunc), (double));

	    /* Double function returning a double */

	    result = ((pdblfunc) (func)) (arg1);

	    finish(f, vector, result, p, args, name);
	} else if (strcmp(args, "ff") == 0) {
	    float           arga;
	    double          a;

	    typedef float _EXFUN((*pdblfunc), (float));

	    /* Double function returning a double */

	    if (arg1 < FLT_MAX) {
		arga = arg1;
		result = ((pdblfunc) (func)) (arga);
		finish(f, vector, result, p, args, name);
	    }
	} else if (strcmp(args, "ddd") == 0) {
	    typedef double  _EXFUN((*pdblfunc), (double, double));

	    result = ((pdblfunc) (func)) (arg1, arg2);
	    finish(f, vector, result, p, args, name);
	} else if (strcmp(args, "fff") == 0) {
	    double          a,
	                    b;

	    float           arga;
	    float           argb;

	    typedef float _EXFUN((*pdblfunc), (float, float));

	    if (arg1 < FLT_MAX && arg2 < FLT_MAX) {
		arga = arg1;
		argb = arg2;
		result = ((pdblfunc) (func)) (arga, argb);
		finish(f, vector, result, p, args, name);
	    }
	} else if (strcmp(args, "did") == 0) {
	    typedef double  _EXFUN((*pdblfunc), (int, double));

	    result = ((pdblfunc) (func)) ((int) arg1, arg2);
	    finish(f, vector, result, p, args, name);
	} else if (strcmp(args, "fif") == 0) {
	    double          a,
	                    b;

	    float           arga;
	    float           argb;

	    typedef float _EXFUN((*pdblfunc), (int, float));

	    if (arg1 < FLT_MAX && arg2 < FLT_MAX) {
		arga = arg1;
		argb = arg2;
		result = ((pdblfunc) (func)) ((int) arga, argb);
		finish(f, vector, result, p, args, name);
	    }
	}
	p++;
    }
    if (vector) {
	VECCLOSE(f, name, args);
    }
}

/*
 * These have to be played with to get to compile on machines which don't
 * have the fancy <foo>f entry points
 */

#if 0
float
_DEFUN(cosf, (a), float a)
{
    return cos((double) a);
}

float
_DEFUN(sinf, (a), float a)
{
    return sin((double) a);
}

float
_DEFUN(log1pf, (a), float a)
{
    return log1p((double) a);
}

float
_DEFUN(tanf, (a), float a)
{
    return tan((double) a);
}

float
_DEFUN(ceilf, (a), float a)
{
    return ceil(a);
}

float
_DEFUN(floorf, (a), float a)
{
    return floor(a);
}

#endif

/* ndef HAVE_FLOAT */
#if 0

float
fmodf(a, b)
    float           a,
                    b;
{
    return fmod(a, b);
}

float
hypotf(a, b)
    float           a,
                    b;
{
    return hypot(a, b);
}

float
acosf(a)
    float           a;
{
    return acos(a);
}

float
acoshf(a)
    float           a;
{
    return acosh(a);
}

float
asinf(a)
    float           a;
{
    return asin(a);
}

float
asinhf(a)
    float           a;
{
    return asinh(a);
}

float
atanf(a)
    float           a;
{
    return atan(a);
}

float
atanhf(a)
    float           a;
{
    return atanh(a);
}

float
coshf(a)
    float           a;
{
    return cosh(a);
}

float
erff(a)
    float           a;
{
    return erf(a);
}

float
erfcf(a)
    float           a;
{
    return erfc(a);
}

float
expf(a)
    float           a;
{
    return exp(a);
}

float
fabsf(a)
    float           a;
{
    return fabs(a);
}

float
gammaf(a)
    float           a;
{
    return gamma(a);
}

float
j0f(a)
    float           a;
{
    return j0(a);
}

float
j1f(a)
    float           a;
{
    return j1(a);
}

float
log10f(a)
    float           a;
{
    return log10(a);
}

float
logf(a)
    float           a;
{
    return log(a);
}

float
sinhf(a)
    float           a;
{
    return sinh(a);
}

float
sqrtf(a)
    float           a;
{
    return sqrt(a);
}

float
tanhf(a)
    float           a;
{
    return tanh(a);
}

float
y0f(a)
    float           a;
{
    return y0(a);
}

float
y1f(a)
    float           a;
{
    return y1(a);
}

#endif

int
_DEFUN_VOID(randi)
{
  static int next;
  next = (next * 1103515245) + 12345;
  return ((next >> 16) & 0xffff);
}

double _DEFUN_VOID(randx)
{
  double res;
  
  do 
  {
    union {
	short parts[4];
	double res;
      } u;
    
    u.parts[0] = randi();
    u.parts[1] = randi();
    u.parts[2] = randi();
    u.parts[3] = randi();
    res = u.res;
    
  } while (!finite(res));
  
  return res ;
}

/* Return a random double, but bias for numbers closer to 0 */
double _DEFUN_VOID(randy)
{
  int pow;
  double r= randx();
  r = frexp(r, &pow);
  return ldexp(r, randi() & 0x1f);
}
