%define	_vararpwatch	%{_localstatedir}/arpwatch
%define PCAP_UID 77
%define PCAP_GID 77

%define releaseno 7
%define arpwatch_release %{releaseno}
%define pcap_release %{releaseno}
%define tcpdump_release %{releaseno}

%define pcap_major 0
%define pcap_minor 8
%define pcap_subminor 3
%define pcap_version %{pcap_major}.%{pcap_minor}.%{pcap_subminor}

%define tcpdump_version 3.8.2

Summary: A network traffic monitoring tool.
Name: tcpdump
Version: %{tcpdump_version}
%define	tcpdump_dir	tcpdump-%{tcpdump_version}
%define tcpslice_dir	tcpslice
Release: %{tcpdump_release}

# XXX epoch is necessary to obsolete tcpdump-3.4a5
Epoch: 14

License: BSD
URL: http://www.tcpdump.org
Group: Applications/Internet
Source0: http://www.tcpdump.org/release/tcpdump-%{tcpdump_version}.tar.gz
Source1: http://www.tcpdump.org/release/libpcap-%{pcap_version}.tar.gz
Source2: ftp://ftp.ee.lbl.gov/arpwatch-2.1a13.tar.gz
Source3: arpwatch.init
Source4: tcpslice-CVS.20010207.tar.gz
Source5: arpwatch.sysconfig
Source6: rpc.tar.gz

Patch5: tcpdump-3.6.2-tcpslice-time.patch
Patch7: tcpdump-3.8.1-redhat.patch
Patch10: tcpdump-3.6.1-portnumbers.patch
Patch15: tcpdump-3.6.2-ip6opts.patch
Patch16: tcpdump-3.8.1-sctp.patch
Patch17: tcpdump-3.7.2-sctpdef.patch
Patch18: tcpdump-3.8.2-gcc34.patch

Patch34: arpwatch-2.1a4-fhs.patch
Patch35: arpwatch-2.1a10-man.patch
Patch38: arpwatch-drop.patch
Patch39: arpwatch-drop-man.patch
Patch41: arpwatch-addr.patch

Patch50: libpcap-shared.patch
Patch52: tcpdump-3.7.2-s390.patch
Patch53: libpcap-0.8.3-ppp.patch

Patch70: tcpslice-CVS.20010207-bpf.patch


Prefix: %{_prefix}
BuildRequires: glibc-kernheaders >= 2.2.0 openssl-devel flex bison
Requires: kernel >= 2.2.0
BuildRoot: %{_tmppath}/%{name}-root

%description
Tcpdump is a command-line tool for monitoring network traffic.
Tcpdump can capture and display the packet headers on a particular
network interface or on all interfaces.  Tcpdump can display all of
the packet headers, or just the ones that match particular criteria.

Install tcpdump if you need a program to monitor network traffic.

%package -n libpcap
# if you change the Version, don't forget to edit libpcap-shared.patch
# could be sed'd automatically
Version: %{pcap_version}
Release: %{pcap_release}
%define	libpcap_dir	libpcap-%{pcap_version}
Summary: A system-independent interface for user-level packet capture.
Group: Development/Libraries
License: BSD
URL: http://www.tcpdump.org
Requires: kernel >= 2.2.0 openssl

%description -n libpcap
Libpcap provides a portable framework for low-level network
monitoring.  Libpcap can provide network statistics collection,
security monitoring and network debugging.  Since almost every system
vendor provides a different interface for packet capture, the libpcap
authors created this system-independent API to ease in porting and to
alleviate the need for several system-dependent packet capture modules
in each application.

Install libpcap if you need to do low-level network traffic monitoring
on your network.

%package -n arpwatch
Version: 2.1a13
Release: %{arpwatch_release}
%define	arpwatch_dir	arpwatch-2.1a13
Summary: Network monitoring tools for tracking IP addresses on a network.
Group: Applications/System
License: BSD
URL: http://www.tcpdump.org
Prereq: /sbin/chkconfig /sbin/service

%description -n arpwatch
The arpwatch package contains arpwatch and arpsnmp.  Arpwatch and
arpsnmp are both network monitoring tools.  Both utilities monitor
Ethernet or FDDI network traffic and build databases of Ethernet/IP
address pairs, and can report certain changes via email.

Install the arpwatch package if you need networking monitoring devices
which will automatically keep track of the IP addresses on your
network.

%prep
%setup -q -c -a 1 -a 2 -a 4

%patch5 -p1 -b .tcpslicetime
%patch7 -p1 -b .rh

pushd %libpcap_dir
%patch50 -p1 -b .shared 
%patch52 -p1 -b .s390
%patch53 -p0 -b .ppp
popd

pushd %tcpdump_dir
%patch10 -p1 -b .portnumbers
%patch15 -p1 -b .ip6opts
%patch16 -p1 -b .sctp
%patch17 -p1 -b .sctpdef
%patch18 -p1 -b .gcc34
tar xzf %{SOURCE6}
popd

pushd %arpwatch_dir
%patch34 -p1 -b .fhs
%patch35 -p1 -b .arpsnmpman
%patch38 -p1 -b .droproot
%patch39 -p0 -b .droprootman
%patch41 -p1 -b .mailuser
popd

pushd tcpslice
%patch70 -p1 -b .bpf
popd


%build
pushd %libpcap_dir
unset CFLAGS
%configure --enable-ipv6

DEFS="-g -D_U_=\"\" -fPIC -DHAVE_CONFIG_H"
%ifarch alpha sparc sparc64
DEFS="$DEFS -DHAVE_ETHER_HOSTTON=1 -DLBL_ALIGN=1"
%endif
make DEFS="$DEFS" \
	LIBMAJOR="%{pcap_major}" \
	LIBMINOR="%{pcap_minor}" \
	LIBSUBMINOR="%{pcap_subminor}"

popd

pushd %tcpslice_dir
%configure
make
popd

pushd %tcpdump_dir
unset CFLAGS
%define	optflags $RPM_OPT_FLAGS -DIP_MAX_MEMBERSHIPS=20 
%configure --enable-ipv6 --with-user=pcap
%undefine optflags

DEFS="-g  -D_U_=\"\" -DHAVE_CONFIG_H"
%ifarch alpha sparc sparc64
DEFS="$DEFS -DHAVE_ETHER_HOSTTON=1 -DLBL_ALIGN=1 -DHAVE_ETHER_NTOA=1"
%endif
%ifarch sparc sparc64
DEFS="$DEFS -DWORDS_BIGENDIAN"
%endif

make DEFS="$DEFS"
popd

pushd %arpwatch_dir
unset CFLAGS
%configure
make ARPDIR=%{_vararpwatch}
popd

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{3,8}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}

pushd %libpcap_dir
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}/net
make DESTDIR=${RPM_BUILD_ROOT} includedir=%{_includedir} \
	LIBMAJOR="%{pcap_major}" \
	LIBMINOR="%{pcap_minor}" \
	LIBSUBMINOR="%{pcap_subminor}"  \
	install
chmod +x ${RPM_BUILD_ROOT}%{_libdir}/libpcap.so.*
popd

pushd %tcpslice_dir
install -m755 tcpslice ${RPM_BUILD_ROOT}%{_sbindir}
install -m644 tcpslice.1 ${RPM_BUILD_ROOT}%{_mandir}/man8/tcpslice.8
popd

pushd %tcpdump_dir
install -m755 tcpdump ${RPM_BUILD_ROOT}%{_sbindir}
install -m644 tcpdump.1 ${RPM_BUILD_ROOT}%{_mandir}/man8/tcpdump.8
popd

pushd %arpwatch_dir
make DESTDIR=${RPM_BUILD_ROOT} install install-man
mkdir -p ${RPM_BUILD_ROOT}%{_vararpwatch}
for n in arp2ethers arpfetch massagevendor massagevendor-old; do
	install -m755 $n ${RPM_BUILD_ROOT}%{_vararpwatch}
done
for n in *.awk *.dat missingcodes.txt; do
	install -m644 $n ${RPM_BUILD_ROOT}%{_vararpwatch}
done
( cd ${RPM_BUILD_ROOT}
  mkdir -p ./etc/rc.d/init.d
  install -c -m755 $RPM_SOURCE_DIR/arpwatch.init ./etc/rc.d/init.d/arpwatch
  mkdir -p ./etc/sysconfig
  install -c -m644 $RPM_SOURCE_DIR/arpwatch.sysconfig ./etc/sysconfig/arpwatch
)
popd

( cd ${RPM_BUILD_ROOT}
  strip .%{_sbindir}/* || :
)

%clean
rm -rf ${RPM_BUILD_ROOT}

%pre
/usr/sbin/groupadd -g %{PCAP_GID} pcap  2> /dev/null
/usr/sbin/useradd -u %{PCAP_UID} -g %{PCAP_GID} -s /sbin/nologin -M -r \
	-d %{_vararpwatch} pcap 2> /dev/null \
	|| /usr/bin/chsh pcap /sbin/nologin 2> /dev/null
exit 0

%post -n arpwatch
/sbin/chkconfig --add arpwatch

%pre -n arpwatch
/usr/sbin/groupadd -g %{PCAP_GID} pcap  2> /dev/null
/usr/sbin/useradd -u %{PCAP_UID} -g %{PCAP_GID} \
	-s /sbin/nologin -M -r -d %{_vararpwatch} pcap 2> /dev/null \
	|| /usr/bin/chsh pcap /sbin/nologin 2> /dev/null
exit 0

%postun -n arpwatch
/sbin/service arpwatch condrestart >/dev/null 2>&1 || :

%preun -n arpwatch
if [ "$1" = "0" ]; then
	/sbin/service arpwatch stop > /dev/null 2>&1
	/sbin/chkconfig --del arpwatch
fi
exit 0

%post -n libpcap -p /sbin/ldconfig

%postun -n libpcap -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc	%tcpdump_dir/LICENSE %tcpdump_dir/README %tcpdump_dir/CHANGES
%{_sbindir}/tcpdump
%{_sbindir}/tcpslice
%{_mandir}/man8/tcpslice.8*
%{_mandir}/man8/tcpdump.8*

%files -n libpcap
%defattr(-,root,root)
%doc	%libpcap_dir/LICENSE %libpcap_dir/README %libpcap_dir/CHANGES
%{_includedir}/*
%{_libdir}/libpcap.*
%{_mandir}/man3/pcap.3*

%files -n arpwatch
%defattr(-,root,root)
%doc	%arpwatch_dir/README %arpwatch_dir/CHANGES
%{_sbindir}/arpwatch
%{_sbindir}/arpsnmp
%{_mandir}/man8/arpwatch.8*
%{_mandir}/man8/arpsnmp.8*
%config	/etc/rc.d/init.d/arpwatch
%config(noreplace) /etc/sysconfig/arpwatch
%defattr(-,pcap,pcap)
%dir	%{_vararpwatch}
%verify(not md5 size mtime) %config(noreplace) %{_vararpwatch}/arp.dat
%verify(not md5 size mtime) %config %{_vararpwatch}/ethercodes.dat
%config	%{_vararpwatch}/missingcodes.txt
%{_vararpwatch}/*.awk
%{_vararpwatch}/arp2ethers
%{_vararpwatch}/arpfetch
%{_vararpwatch}/massagevendor
%{_vararpwatch}/massagevendor-old

%changelog
* Wed Oct 12 2004 Harald Hoyer <harald@redhat.com> - 14:3.8.2-7
- fixed nfs protocol parsing for 64 bit architectures (bug 132781)

* Wed Sep 15 2004 Harald Hoyer <harald@redhat.com> - 14:3.8.2-6
- added libpcap-0.8.3-ppp.patch for ppp (bug 128053)

* Wed Jun 23 2004 Elliot Lee <sopwith@redhat.com>
- added flex to BuildRequires

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sun May 30 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- simplify rpm scripts

* Tue Apr  6 2004 Harald Hoyer <harald@redhat.com> - 14:3.8.2-3
- added LICENSE files

* Wed Mar 31 2004 Harald Hoyer <harald@redhat.com> - 14:3.8.2-2
- update to libpcap-0.8.3 (tcpdump-3.8.3 seems to be older that 3.8.2!!)

* Tue Mar 30 2004 Harald Hoyer <harald@redhat.com> - 14:3.8.2-1
- update to tcpdump-3.8.2, libpcap-0.8.2, arpwatch-2.1a13
- patched tcpdump configure for gcc34 optimizations
- removed obsolete patches

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Jan 23 2004 Harald Hoyer <harald@redhat.de> 14:3.8.1-4/17
- fixed arpwatch version
- fixed libpcap library version
- fixed tcpdump droproot

* Tue Jan 20 2004 Harald Hoyer <harald@redhat.de> 14:3.8.1-3
- corrected tcpslice (bpf.h issue)

* Tue Jan 13 2004 Harald Hoyer <harald@redhat.de> 14:3.8.1-2
- more security issues (patch 18)

* Fri Jan 09 2004 Phil Knirsch <pknirsch@redhat.com> 14:3.8.1-1
- Updated to latest version because of security issue

* Fri Aug 29 2003 Harald Hoyer <harald@redhat.de> 14:3.7.2-7
- build libpcap shared library with gcc and not ld

* Tue Jul 22 2003 Phil Knirsch <pknirsch@redhat.com> 14:3.7.2-6.1
- rebuilt

* Mon Jul 21 2003 Phil Knirsch <pknirsch@redhat.com> 14:3.7.2-6
- rebuilt

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 21 2003 Harald Hoyer <harald@redhat.de> 14:3.7.2-5
- add proper attributes for arp.dat, ethercodes

* Tue May 20 2003 Harald Hoyer <harald@redhat.de> 14:3.7.2-4
- take ethercodes.dat from the arpwatch package now

* Tue May  6 2003 Harald Hoyer <harald@redhat.de> 14:3.7.2-3
- compile tcpdump with autoheader #90208

* Thu May  1 2003 Elliot Lee <sopwith@redhat.com> 14:3.7.2-2
- Add sctpdef patch to fix ppc64 builds

* Thu Feb 27 2003 Phil Knirsch <pknirsch@redhat.com> 14:3.7.2-1
- Update to upstream version 3.7.2

* Sat Feb 01 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- sanitized rpm scripts

* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 12:3.6.3-20
- rebuilt

* Tue Jan  7 2003 Nalin Dahyabhai <nalin@redhat.com> 12:3.6.3-19/0.6.2-19/2.1a11-19
- rebuild

* Sat Jan  4 2003 Jeff Johnson <jbj@redhat.com> 12:3.6.3-18/0.6.2-18/2.1a11-18
- set execute bits on library so that requires are generated.

* Wed Dec 11 2002 Harald Hoyer <harald@redhat.de> 12:3.6.3-17/0.6.2-17/2.1a11-17
- common release no. across all subpackages

* Wed Dec 11 2002 Harald Hoyer <harald@redhat.de> 12:3.6.3-5/0.6.2-16/2.1a11-16
- print_bgp security fix

* Mon Nov 18 2002 Tim Powers <timp@redhat.com>
- rebuild on all arches

* Fri Aug  2 2002 Harald Hoyer <harald@redhat.de> 12:3.6.3-3/0.6.2-16/2.1a11-16
- added man page descriptions for the new parameters

* Thu Aug  1 2002 Harald Hoyer <harald@redhat.de> 12:3.6.3-2
- added arpwatch options to specify sender and recipient (#70386)

* Tue Jul 23 2002 Harald Hoyer <harald@redhat.de> 12:3.6.3-1
- removed prestripping

* Thu May 16 2002 Harald Hoyer <harald@redhat.de> 12:3.6.2-13
- added official 3.6.3 fix
- fixed 6.2 compat #63113

* Wed Jan 23 2002 Harald Hoyer <harald@redhat.de> 12:3.6.2-12
- tcpdump-3.6.2-snaplen.patch added to fix #55145

* Tue Dec 18 2001 Harald Hoyer <harald@redhat.de> 12:3.6.2-10
- took old purge patch for filters
- fixed #54225,#58346
- drop root by default #49635
- fixed #54593
- fixed #57711

* Fri Aug 31 2001 Harald Hoyer <harald@redhat.de> 12:3.6.2-9
- took better fix for #52654 from tcpdump cvs

* Thu Aug 30 2001 Harald Hoyer <harald@redhat.de> 11:3.6.2-8
- fixed #52654

* Thu Jul 19 2001 Harald Hoyer <harald@redhat.de> 10:3.6.2-7
- added shared library to libpcap (#47174)
- afs printing security patch (#49294)

* Wed Jun 20 2001 Harald Hoyer <harald@redhat.de>
- use initgroups, instead of setgroups

* Mon Jun 18 2001 Harald Hoyer <harald@redhat.de>
- added dropgroup patches (#44563)

* Mon May 07 2001 Harald Hoyer <harald@redhat.de>
- switched to Pekka's tcpdump-3.6.2 package
- incremented epoch

* Sat Apr 14 2001 Pekka Savola <pekkas@netcore.fi>
- fix building of tcpslice on glibc 2.2.2 (time.h)
- disable /etc/init.d requirement and fix %post scripts in arpwatch

* Wed Feb 14 2001 Harald Hoyer <harald@redhat.de>
- glibc sys/time -> time include patch

* Wed Feb  7 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add space to this check

* Wed Feb 07 2001 Harald Hoyer <harald@redhat.com>
- added check for presence of /etc/sysconfig/arpwatch (#23172)

* Wed Feb  7 2001 Pekka Savola <pekkas@netcore.fi>
- update to 3.6.2, 0.6.2 and new CVS of tcpslice.
- i18n'ize arpwatch init script

* Fri Feb  2 2001 Trond Eivind Glomsrd <teg@redhat.com>
- i18nize initscript

* Mon Jan 29 2001 Harald Hoyer <harald@redhat.com>
- fixed EINTR stopping for e.g. SIGSTOP. (#22008)
- added -u option for tcpdump (#20231)
- new arpwatch version (#23172)
- added "all" and "one" interface for -i (#20907)
- added arpwatch sysconfig (#23172)

* Mon Jan 22 2001 Harald Hoyer <harald@redhat.com>
- more (potential) overflows in libpcap. #21373
- documentation fix for #20906

* Sun Jan 14 2001 Pekka Savola <pekkas@netcore.fi>
- use --enable-ipv6
- Add two patches from CVS to enhance 802.2 printing, and more importantly,
  to be able to specify 'no stp'

* Sat Jan 13 2001 Pekka Savola <pekkas@netcore.fi>
- Make SMB printing output a lot more quiet unless in verbose mode.
- Make -n resolve port/protocol numbers but not hostnames, -nn for no
  resolving at all
- Separate droproot patch from a more generic man/usage fix one
- Add non-promiscuous mode -by default patch, but don't apply it by default

* Thu Jan 11 2001 Pekka Savola <pekkas@netcore.fi>
- Update to tcpdump 3.6.1 and libpcap 0.6.1 releases.

* Mon Jan  8 2001 Pekka Savola <pekkas@netcore.fi>
- Update to 20010108 CVS, disable some upstreamed patches.
- Change some additional .1 pages to .8.
- Add droproot patch, some --usage and man page fixes.

* Mon Jan  1 2001 Pekka Savola <pekkas@netcore.fi>
- Initial packaging with latest tcpdump.org CVS tcpdump-3.6 and libpcap-0.6.
- add earlier print-domain.c, the latest is segfaulting
- don't unnecesessarily include snprintf.o, it didn't compile with gcc 2.96 anyway
- don't use savestr, require openssl, tweak tweak tweak
- add tcpslice, patch it a bit for egcs detection

* Sun Dec 31 2000 Pekka Savola <pekkas@netcore.fi>
- tcpdump: spice up the manpage about interfaces
- tcpdump: add 'all' and 'any' keywords to -i, saner default behaviour.
- upgrade arpwatch to 2.1a10

* Sun Nov 26 2000 Jeff Johnson <jbj@redhat.com>
- more (potential) overflows in libpcap.

* Sun Nov 12 2000 Jeff Johnson <jbj@redhat.com>
- eliminate still more buffer overflows (from FreeBSD) (#20069).

* Thu Nov  2 2000 Jeff Johnson <jbj@redhat.com>
- eliminate more buffer overflows (from FreeBSD) (#20069).
- 802.1q ether type incorrect (#19850).
- add -u flag to drop arpwatch privs (#19696).

* Sun Oct 15 2000 Jeff Johnson <jbj@redhat.com>
- updated ethercodes.dat

* Thu Oct 12 2000 Jeff Johnson <jbj@redhat.com>
- fix arpwatch tmp race (#18943).

* Fri Aug 11 2000 Bill Nottingham <notting@redhat.com>
- fix condrestart

* Fri Aug 11 2000 Jeff Johnson <jbj@redhat.com>
- correct arpsnmp man pages (#15442).
- don't print harmless ENOPROTOOPT message (#13518).

* Fri Aug  4 2000 Jeff Johnson <jbj@redhat.com>
- rebuild with final kernel headers (#13518).

* Sat Jul 22 2000 Jeff Johnson <jbj@redhat.com>
- add STP patch (#14112).

* Fri Jul 14 2000 Matt Wilson <msw@redhat.com>
- source /etc/init.d/functions
- back out /etc/init.d/arpwatch, place file in /etc/rc.d
- move initscript to /etc/init.d
- changed initscript to use start() and stop() functions
- added condrestart to init script
- added %%post %%preun %%postun scripts to register arpwatch script
- added Prereq: for all things needed in post/preun/postun

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jul 11 2000 Jeff Johnson <jbj@redhat.com>
- updated man page and help (pekkas@netcore.fi) (#10739 et al).

* Sun Jun 18 2000 Jeff Johnson <jbj@redhat/com>
- FHS packaging.

* Tue May  9 2000 Bill Nottingham <notting@redhat.com>
- minor tweaks for ia64 (prototypes)

* Thu Feb 17 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Compile shared libpcap with -fPIC (Bug #6342)

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix descriptions
- man pages are compressed

* Wed Dec 22 1999 Jeff Johnson <jbj@redhat.com>
- remove sparc64 SIOCGIFNAME hack, not needed with (at least) kernel 2.2.12-40.
- upgrade to ANK ss991030 snapshot with pcap magic fix (#6773).
- add getprotobyname lookup (#6725).
- getservbyname port lookup appears functional (#7569).
- remove uid 2090 backdoor (sorry Dave) (#7116).

* Thu Sep 09 1999 Cristian Gafton <gafton@redhat.com>
- fox the pcap.h header

* Fri Aug 20 1999 Jeff Johnson <jbj@redhat.com>
- prevent segfault on obscure spoofed ip header (#4634).

* Wed Aug 18 1999 Jeff Johnson <jbj@redhat.com>
- add defattr to arpwatch (#4591).

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging

* Sun Aug  8 1999 Jeff Johnson <jbj@redhat.com>
- add -DWORDS_BIGINDIAN to tcpdump compile on sparc sparc61.

* Tue Aug  3 1999 Jeff Johnson <jbj@redhat.com>
- include A. Kuznetsov's patches to libpcap/tcpdump.
- added arpsnmp to package (#3258).
- arp2ethers written for different of awk (#4326).

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 10)

* Fri Mar 19 1999 Jeff Johnson <jbj@redhat.com>
- strip binaries.

* Wed Jan 13 1999 Bill Nottingham <notting@redhat.com>
- autoconf fixes for arm

* Tue Sep 29 1998 Jeff Johnson <jbj@redhat.com>
- libpcap description typo.

* Sat Sep 19 1998 Jeff Johnson <jbj@redhat.com>
- fix arpwatch summary line.

* Mon Aug 17 1998 Jeff Johnson <jbj@redhat.com>
- enable arpwatch

* Mon Aug  3 1998 Jeff Johnson <jbj@redhat.com>
- separate package for libpcap.
- update tcpdump to 3.4, libpcap to 0.4.
- added arpwatch (but disabled for now)

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sat May  2 1998 Alan Cox <alan@rehat.com>
- Added the SACK printing fix so you can dump Linux 2.1+.

* Tue Oct 21 1997 Erik Troan <ewt@redhat.com>
- updated to release 3.4a5
- uses a buildroot and %attr 

* Thu Jul 17 1997 Erik Troan <ewt@redhat.com>
- built against glibc
