Summary: SELinux library and simple utilities
Name: libselinux
Version: 1.19.1
Release: 8
License: Public domain (uncopyrighted)
Group: System Environment/Libraries
Source: http://www.nsa.gov/selinux/archives/libselinux-%{version}.tgz
Patch: libselinux-rhat.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

libselinux provides an API for SELinux applications to get and set
process and file security contexts and to obtain security policy
decisions.  Required for any applications that use the SELinux API.

%package devel
Summary: Header files and libraries used to build SELinux
Group: Development/Libraries
Requires: libselinux = %{version}

%description devel
The selinux-devel package contains the static libraries and header files
needed for developing SELinux applications. 

%prep
%setup -q
%patch -p1 -b .rhat

%build
make CFLAGS="-g %{optflags}"

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{_lib} 
mkdir -p ${RPM_BUILD_ROOT}/%{_libdir} 
mkdir -p ${RPM_BUILD_ROOT}%{_includedir} 
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
make DESTDIR="${RPM_BUILD_ROOT}" LIBDIR="${RPM_BUILD_ROOT}%{_libdir}" SHLIBDIR="${RPM_BUILD_ROOT}/%{_lib}" BINDIR="${RPM_BUILD_ROOT}%{_sbindir}" install

# Nuke the files we don't want to distribute
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/compute_*
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/deftype
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/execcon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/getcon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/getconlist
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/getenforcemode
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/getfilecon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/getpidcon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/matchpathcon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/mkdircon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/policyvers
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/setfilecon
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/selinuxconfig
rm -f ${RPM_BUILD_ROOT}%{_sbindir}/selinuxdisable

%clean
rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files devel
%defattr(-,root,root)
%{_libdir}/libselinux.a
%{_libdir}/libselinux.so
%dir %{_includedir}/selinux
%{_includedir}/selinux/
%{_mandir}/man3/*

%files
%defattr(-,root,root,0755)
/%{_lib}/libselinux.so.*
%{_sbindir}/*
%{_mandir}/man8/*

%changelog
* Thu Nov 24 2004 Dan Walsh <dwalsh@redhat.com> 1.19.1-8
- Bump for FC-3

* Thu Nov 24 2004 Dan Walsh <dwalsh@redhat.com> 1.19.1-7
- Bump for RHEL4

* Thu Nov 18 2004 Dan Walsh <dwalsh@redhat.com> 1.19.1-6
- Add avcstat program

* Mon Nov 15 2004 Dan Walsh <dwalsh@redhat.com> 1.19.1-4
- Add lots of missing man pages

* Fri Nov 12 2004 Dan Walsh <dwalsh@redhat.com> 1.19.1-2
- Fix output of getsebool.

* Tue Nov 9 2004 Dan Walsh <dwalsh@redhat.com> 1.19.1-1
- Update from upstream, fix setsebool -P segfault

* Fri Nov 5 2004 Steve Grubb <sgrubb@redhat.com> 1.18.1-5
- Add a patch from upstream. Fixes signed/unsigned issues, and 
  incomplete structure copy.

* Thu Nov 4 2004 Dan Walsh <dwalsh@redhat.com> 1.18.1-4
- More fixes from sgrubb, better syslog

* Thu Nov 4 2004 Dan Walsh <dwalsh@redhat.com> 1.18.1-3
- Have setsebool and togglesebool log changes to syslog

* Wed Nov 3 2004 Steve Grubb <sgrubb@redhat.com> 1.18.1-2
- Add patch to make setsebool update bool on disk
- Make togglesebool have a rollback capability in case it blows up inflight

* Tue Nov 2 2004 Dan Walsh <dwalsh@redhat.com> 1.18.1-1
- Upgrade to latest from NSA

* Thu Oct 28 2004 Steve Grubb <sgrubb@redhat.com> 1.17.15-2
- Changed the location of the utilities to /usr/sbin since
   normal users can't use them anyways.

* Wed Oct 27 2004 Steve Grubb <sgrubb@redhat.com> 1.17.15-2
- Updated various utilities, removed utilities that are for testing,
  added man pages.

* Fri Oct 15 2004 Dan Walsh <dwalsh@redhat.com> 1.17.15-1
- Add -g flag to make
- Upgrade to latest  from NSA
	* Added rpm_execcon.

* Fri Oct 1 2004 Dan Walsh <dwalsh@redhat.com> 1.17.14-1
- Upgrade to latest  from NSA
	* Merged setenforce and removable context patch from Dan Walsh.
	* Merged build fix for alpha from Ulrich Drepper.
	* Removed copyright/license from selinux_netlink.h - definitions only.

* Fri Oct 1 2004 Dan Walsh <dwalsh@redhat.com> 1.17.13-3
- Change setenforce to accept Enforcing and Permissive

* Wed Sep 22 2004 Dan Walsh <dwalsh@redhat.com> 1.17.13-2
- Add alpha patch

* Mon Sep 20 2004 Dan Walsh <dwalsh@redhat.com> 1.17.13-1
- Upgrade to latest  from NSA

* Thu Sep 16 2004 Dan Walsh <dwalsh@redhat.com> 1.17.12-2
- Add selinux_removable_context_path

* Tue Sep 14 2004 Dan Walsh <dwalsh@redhat.com> 1.17.12-1
- Update from NSA
	* Add matchmediacon

* Tue Sep 14 2004 Dan Walsh <dwalsh@redhat.com> 1.17.11-1
- Update from NSA
	* Merged in matchmediacon changes.

* Fri Sep 10 2004 Dan Walsh <dwalsh@redhat.com> 1.17.10-1
- Update from NSA
	* Regenerated headers for new nscd permissions.

* Wed Sep 8 2004 Dan Walsh <dwalsh@redhat.com> 1.17.9-2
- Add matchmediacon

* Wed Sep 8 2004 Dan Walsh <dwalsh@redhat.com> 1.17.9-1
- Update from NSA
	* Added get_default_context_with_role.

* Thu Sep 2 2004 Dan Walsh <dwalsh@redhat.com> 1.17.8-2
- Clean up spec file
	* Patch from Matthias Saou

* Thu Sep 2 2004 Dan Walsh <dwalsh@redhat.com> 1.17.8-1
- Update from NSA
	* Added set_matchpathcon_printf.	

* Wed Sep 1 2004 Dan Walsh <dwalsh@redhat.com> 1.17.7-1
- Update from NSA
	* Reworked av_inherit.h to allow easier re-use by kernel. 

* Tue Aug 31 2004 Dan Walsh <dwalsh@redhat.com> 1.17.6-1
- Add strcasecmp in selinux_config
- Update from NSA
	* Changed avc_has_perm_noaudit to not fail on netlink errors.
	* Changed avc netlink code to check pid based on patch by Steve Grubb.
	* Merged second optimization patch from Ulrich Drepper.
	* Changed matchpathcon to skip invalid file_contexts entries.
	* Made string tables private to libselinux.
	* Merged strcat->stpcpy patch from Ulrich Drepper.
	* Merged matchpathcon man page from Dan Walsh.
	* Merged patch to eliminate PLTs for local syms from Ulrich Drepper.
	* Autobind netlink socket.
	* Dropped compatibility code from security_compute_user.
	* Merged fix for context_range_set from Chad Hanson.
	* Merged allocation failure checking patch from Chad Hanson.
	* Merged avc netlink error message patch from Colin Walters.


* Mon Aug 30 2004 Dan Walsh <dwalsh@redhat.com> 1.17.5-1
- Update from NSA
	* Merged second optimization patch from Ulrich Drepper.
	* Changed matchpathcon to skip invalid file_contexts entries.
	* Made string tables private to libselinux.
	* Merged strcat->stpcpy patch from Ulrich Drepper.
	* Merged matchpathcon man page from Dan Walsh.
	* Merged patch to eliminate PLTs for local syms from Ulrich Drepper.
	* Autobind netlink socket.
	* Dropped compatibility code from security_compute_user.
	* Merged fix for context_range_set from Chad Hanson.
	* Merged allocation failure checking patch from Chad Hanson.
	* Merged avc netlink error message patch from Colin Walters.

* Mon Aug 30 2004 Dan Walsh <dwalsh@redhat.com> 1.17.4-1
- Update from NSA
- Add optflags

* Fri Aug 26 2004 Dan Walsh <dwalsh@redhat.com> 1.17.3-1
- Update from NSA

* Thu Aug 26 2004 Dan Walsh <dwalsh@redhat.com> 1.17.2-1
- Add matchpathcon man page
- Latest from NSA
	* Merged patch to eliminate PLTs for local syms from Ulrich Drepper.
	* Autobind netlink socket.
	* Dropped compatibility code from security_compute_user.
	* Merged fix for context_range_set from Chad Hanson.
	* Merged allocation failure checking patch from Chad Hanson.
	* Merged avc netlink error message patch from Colin Walters.

* Tue Aug 24 2004 Dan Walsh <dwalsh@redhat.com> 1.17.1-1
- Latest from NSA
	* Autobind netlink socket.
	* Dropped compatibility code from security_compute_user.
	* Merged fix for context_range_set from Chad Hanson.
	* Merged allocation failure checking patch from Chad Hanson.
	* Merged avc netlink error message patch from Colin Walters.

* Sun Aug 22 2004 Dan Walsh <dwalsh@redhat.com> 1.16.1-1
- Latest from NSA

* Thu Aug 19 2004 Colin Walters <walters@redhat.com> 1.16-1
- New upstream version

* Tue Aug 17 2004 Dan Walsh <dwalsh@redhat.com> 1.15.7-1
- Latest from Upstream

* Mon Aug 16 2004 Dan Walsh <dwalsh@redhat.com> 1.15.6-1
- Fix man pages

* Mon Aug 16 2004 Dan Walsh <dwalsh@redhat.com> 1.15.5-1
- Latest from Upstream

* Fri Aug 13 2004 Dan Walsh <dwalsh@redhat.com> 1.15.4-1
- Latest from Upstream

* Thu Aug 12 2004 Dan Walsh <dwalsh@redhat.com> 1.15.3-2
- Add man page for boolean functions and SELinux

* Sat Aug 8 2004 Dan Walsh <dwalsh@redhat.com> 1.15.3-1
- Latest from NSA

* Mon Jul 19 2004 Dan Walsh <dwalsh@redhat.com> 1.15.2-1
- Latest from NSA

* Mon Jul 19 2004 Dan Walsh <dwalsh@redhat.com> 1.15.1-3
- uppercase getenforce returns, to make them match system-config-securitylevel

* Thu Jul 15 2004 Dan Walsh <dwalsh@redhat.com> 1.15.1-2
- Remove old path patch

* Thu Jul 8 2004 Dan Walsh <dwalsh@redhat.com> 1.15.1-1
- Update to latest from NSA
- Add fix to only get old path if file_context file exists in old location

* Wed Jun 30 2004 Dan Walsh <dwalsh@redhat.com> 1.14.1-1
- Update to latest from NSA

* Wed Jun 16 2004 Dan Walsh <dwalsh@redhat.com> 1.13.4-1
- add nlclass patch
- Update to latest from NSA

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sat Jun 13 2004 Dan Walsh <dwalsh@redhat.com> 1.13.3-2
- Fix selinux_config to break once it finds SELINUXTYPE.

* Fri May 28 2004 Dan Walsh <dwalsh@redhat.com> 1.13.2-1
-Update with latest from NSA

* Thu May 27 2004 Dan Walsh <dwalsh@redhat.com> 1.13.1-1
- Change to use new policy mechanism

* Mon May 17 2004 Dan Walsh <dwalsh@redhat.com> 1.12-2
- add man patch

* Thu May 14 2004 Dan Walsh <dwalsh@redhat.com> 1.12-1
- Update with latest from NSA

* Wed May 5 2004 Dan Walsh <dwalsh@redhat.com> 1.11.4-1
- Update with latest from NSA

* Thu Apr 22 2004 Dan Walsh <dwalsh@redhat.com> 1.11.3-1
- Add changes for relaxed policy 
- Update to match NSA 

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11.2-1
- Add relaxed policy changes 

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11-4
- Sync with NSA

* Thu Apr 15 2004 Dan Walsh <dwalsh@redhat.com> 1.11-3
- Remove requires glibc>2.3.4

* Wed Apr 14 2004 Dan Walsh <dwalsh@redhat.com> 1.11-2
- Fix selinuxenabled man page.

* Wed Apr 7 2004 Dan Walsh <dwalsh@redhat.com> 1.11-1
- Upgrade to 1.11

* Wed Apr 7 2004 Dan Walsh <dwalsh@redhat.com> 1.10-2
- Add memleaks patch

* Wed Apr 7 2004 Dan Walsh <dwalsh@redhat.com> 1.10-1
- Upgrade to latest from NSA and add more man pages

* Thu Apr 1 2004 Dan Walsh <dwalsh@redhat.com> 1.9-1
- Update to match NSA
- Cleanup some man pages

* Tue Mar 30 2004 Dan Walsh <dwalsh@redhat.com> 1.8-1
- Upgrade to latest from NSA

* Thu Mar 25 2004 Dan Walsh <dwalsh@redhat.com> 1.6-6
- Add Russell's Man pages

* Thu Mar 25 2004 Dan Walsh <dwalsh@redhat.com> 1.6-5
- Change getenforce to also check is_selinux_enabled

* Thu Mar 25 2004 Dan Walsh <dwalsh@redhat.com> 1.6-4
- Add ownership to /usr/include/selinux

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.6-3
- fix location of file_contexts file.

* Wed Mar 10 2004 Dan Walsh <dwalsh@redhat.com> 1.6-2
- Fix matchpathcon to use BUFSIZ

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Feb 23 2004 Dan Walsh <dwalsh@redhat.com> 1.4-11
- add matchpathcon

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Jan 23 2004 Dan Walsh <dwalsh@redhat.com> 1.4-9
- Add rootok patch

* Wed Jan 14 2004 Dan Walsh <dwalsh@redhat.com> 1.4-8
- Updated getpeernam patch

* Tue Jan 13 2004 Dan Walsh <dwalsh@redhat.com> 1.4-7
- Add getpeernam patch

* Thu Dec 18 2003 Dan Walsh <dwalsh@redhat.com> 1.4-6
- Add getpeercon patch

* Thu Dec 18 2003 Dan Walsh <dwalsh@redhat.com> 1.4-5
- Put mntpoint patch, because found fix for SysVinit

* Wed Dec 17 2003 Dan Walsh <dwalsh@redhat.com> 1.4-4
- Add remove mntpoint patch, because it breaks SysVinit

* Wed Dec 17 2003 Dan Walsh <dwalsh@redhat.com> 1.4-3
- Add mntpoint patch for SysVinit

* Fri Dec 12 2003 Dan Walsh <dwalsh@redhat.com> 1.4-2
- Add -r -u -t to getcon 

* Sat Dec 6 2003 Dan Walsh <dwalsh@redhat.com> 1.4-1
- Upgrade to latest from NSA

* Mon Oct 27 2003 Dan Walsh <dwalsh@redhat.com> 1.3-2
- Fix x86_64 build

* Wed Oct 21 2003 Dan Walsh <dwalsh@redhat.com> 1.3-1
- Latest tarball from NSA.

* Tue Oct 21 2003 Dan Walsh <dwalsh@redhat.com> 1.2-9
- Update with latest changes from NSA

* Mon Oct 20 2003 Dan Walsh <dwalsh@redhat.com> 1.2-8
- Change location of .so file

* Wed Oct 8 2003 Dan Walsh <dwalsh@redhat.com> 1.2-7
- Break out into development library

* Wed Oct  8 2003 Dan Walsh <dwalsh@redhat.com> 1.2-6
- Move location of libselinux.so to /lib

* Fri Oct  3 2003 Dan Walsh <dwalsh@redhat.com> 1.2-5
- Add selinuxenabled patch

* Wed Oct  1 2003 Dan Walsh <dwalsh@redhat.com> 1.2-4
- Update with final NSA 1.2 sources.

* Fri Sep  12 2003 Dan Walsh <dwalsh@redhat.com> 1.2-3
- Update with latest from NSA.

* Fri Aug  28 2003 Dan Walsh <dwalsh@redhat.com> 1.2-2
- Fix to build on x86_64

* Thu Aug  21 2003 Dan Walsh <dwalsh@redhat.com> 1.2-1
- update for version 1.2

* Wed May 27 2003 Dan Walsh <dwalsh@redhat.com> 1.0-1
- Initial version

