/* Target-dependent code for the Matsushita MN10300 for GDB, the GNU debugger.
   Copyright 2003
   Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include "defs.h"
#include "gdbcore.h"
#include "gdb_string.h"
#include "regcache.h"
#include "mn10300-tdep.h"
#include "osabi.h"
#include "frame.h"
#include "trad-frame.h"
#include "tramp-frame.h"

#include <stdlib.h>

/* Transliterated from <asm-mn10300/elf.h>...  */
#define ELF_NGREG 28
#define ELF_NFPREG 32

typedef unsigned char elf_greg_t[4];
typedef elf_greg_t elf_gregset_t[ELF_NGREG];

typedef unsigned char elf_fpreg_t[4];
typedef struct
{
  elf_fpreg_t fpregs[ELF_NFPREG];
  unsigned char fpcr[4];
} elf_fpregset_t;

/* elf_gregset_t register indices stolen from include/asm-mn10300/ptrace.h.  */
#define ELF_GREGSET_T_REG_INDEX_A3	0
#define ELF_GREGSET_T_REG_INDEX_A2	1
#define ELF_GREGSET_T_REG_INDEX_D3	2
#define	ELF_GREGSET_T_REG_INDEX_D2	3
#define ELF_GREGSET_T_REG_INDEX_MCVF	4
#define	ELF_GREGSET_T_REG_INDEX_MCRL	5
#define ELF_GREGSET_T_REG_INDEX_MCRH	6
#define	ELF_GREGSET_T_REG_INDEX_MDRQ	7
#define	ELF_GREGSET_T_REG_INDEX_E1	8
#define	ELF_GREGSET_T_REG_INDEX_E0	9
#define	ELF_GREGSET_T_REG_INDEX_E7	10
#define	ELF_GREGSET_T_REG_INDEX_E6	11
#define	ELF_GREGSET_T_REG_INDEX_E5	12
#define	ELF_GREGSET_T_REG_INDEX_E4	13
#define	ELF_GREGSET_T_REG_INDEX_E3	14
#define	ELF_GREGSET_T_REG_INDEX_E2	15
#define	ELF_GREGSET_T_REG_INDEX_SP	16
#define	ELF_GREGSET_T_REG_INDEX_LAR	17
#define	ELF_GREGSET_T_REG_INDEX_LIR	18
#define	ELF_GREGSET_T_REG_INDEX_MDR	19
#define	ELF_GREGSET_T_REG_INDEX_A1	20
#define	ELF_GREGSET_T_REG_INDEX_A0	21
#define	ELF_GREGSET_T_REG_INDEX_D1	22
#define	ELF_GREGSET_T_REG_INDEX_D0	23
#define ELF_GREGSET_T_REG_INDEX_ORIG_D0	24
#define	ELF_GREGSET_T_REG_INDEX_EPSW	25
#define	ELF_GREGSET_T_REG_INDEX_PC	26

/* Unpack an elf_gregset_t into GDB's register cache.  */

static void
supply_gregset (elf_gregset_t *gregsetp)
{
  elf_greg_t *regp = *gregsetp;
  char zerobuf[MAX_REGISTER_SIZE];
  int regi;

  memset (zerobuf, 0, MAX_REGISTER_SIZE);

  regcache_raw_supply (current_regcache, E_D0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D0));
  regcache_raw_supply (current_regcache, E_D1_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D1));
  regcache_raw_supply (current_regcache, E_D2_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D2));
  regcache_raw_supply (current_regcache, E_D3_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_D3));
  regcache_raw_supply (current_regcache, E_A0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A0));
  regcache_raw_supply (current_regcache, E_A0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A1));
  regcache_raw_supply (current_regcache, E_A2_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A2));
  regcache_raw_supply (current_regcache, E_A3_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_A3));
  regcache_raw_supply (current_regcache, E_SP_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_SP));
  regcache_raw_supply (current_regcache, E_PC_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_PC));
  regcache_raw_supply (current_regcache, E_MDR_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_MDR));
  regcache_raw_supply (current_regcache, E_PSW_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_EPSW));
  regcache_raw_supply (current_regcache, E_LIR_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_LIR));
  regcache_raw_supply (current_regcache, E_LAR_REGNUM,    (char *) (regp + ELF_GREGSET_T_REG_INDEX_LAR));
  regcache_raw_supply (current_regcache, E_MDRQ_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MDRQ));
  regcache_raw_supply (current_regcache, E_E0_REGNUM,     (char *) (regp + ELF_GREGSET_T_REG_INDEX_E0));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 1, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E1));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 2, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E2));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 3, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E3));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 4, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E4));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 5, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E5));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 6, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E6));
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 7, (char *) (regp + ELF_GREGSET_T_REG_INDEX_E7));

  /* ssp, msp, and usp are inaccessible.  */
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 8, zerobuf);
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 9, zerobuf);
  regcache_raw_supply (current_regcache, E_E0_REGNUM + 10, zerobuf);

  regcache_raw_supply (current_regcache, E_MCRH_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MCRH));
  regcache_raw_supply (current_regcache, E_MCRL_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MCRL));
  regcache_raw_supply (current_regcache, E_MCVF_REGNUM,   (char *) (regp + ELF_GREGSET_T_REG_INDEX_MCVF));

  /* The two unused registers beyond fpcr are inaccessible.  */
  regcache_raw_supply (current_regcache, E_FPCR_REGNUM + 1, zerobuf);
  regcache_raw_supply (current_regcache, E_FPCR_REGNUM + 2, zerobuf);
}

/* Unpack an elf_fpregset_t into GDB's register cache.  */

static void
supply_fpregset (elf_fpregset_t *fpregsetp)
{
  register int regi;

  for (regi = 0; regi < ELF_NFPREG; regi++)
    regcache_raw_supply (current_regcache, E_FS0_REGNUM + regi, (char *)&fpregsetp->fpregs[regi]);

  regcache_raw_supply (current_regcache, E_FPCR_REGNUM, (char *)&fpregsetp->fpcr);

}

/*  Use a local version of this function to get the correct types for
    regsets, until multi-arch core support is ready.  */

static void
fetch_core_registers (char *core_reg_sect, unsigned core_reg_size,
		      int which, CORE_ADDR reg_addr)
{
  elf_gregset_t gregset;
  elf_fpregset_t fpregset;

  if (which == 0)
    {
      if (core_reg_size == sizeof (gregset))
	{
	  memcpy ((char *) &gregset, core_reg_sect, sizeof (gregset));
	  supply_gregset (&gregset);
	}
      else
	{
	  warning ("wrong size gregset struct in core file");
	}
    }
  else if (which == 2)
    {
      if (NUM_REGS <= E_FS0_REGNUM + 31)
	{
	  warning ("Wrong mn10300 architecture for core file.\n"
	           "Hint: try \"set architecture am33-2\" before loading core file.");
	}
      else if (core_reg_size == sizeof (fpregset))
	{
	  memcpy ((char *) &fpregset, core_reg_sect, sizeof (fpregset));
	  supply_fpregset (&fpregset);
	}
      else
	{
	  warning ("wrong size fpregset struct in core file");
	}
    }
}

/* Register that we are able to handle ELF file formats using standard
   procfs "regset" structures.  */

static struct core_fns regset_core_fns =
{
  bfd_target_elf_flavour,		/* core_flavour */
  default_check_format,			/* check_format */
  default_core_sniffer,			/* core_sniffer */
  fetch_core_registers,			/* core_read_registers */
  NULL					/* next */
};

static void
am33_linux_sigframe_cache_init (const struct tramp_frame *self,
                                struct frame_info *next_frame,
			        struct trad_frame_cache *this_cache,
			        CORE_ADDR func);

static const struct tramp_frame am33_linux_sigframe = {
  1,
  {
    /* mov     119,d0 */
    0x2c,
    0x77,
    0x00,
    /* syscall 0 */
    0xf0,
    0xe0,
    TRAMP_SENTINEL_INSN
  },
  am33_linux_sigframe_cache_init
};

static const struct tramp_frame am33_linux_rt_sigframe = {
  1,
  {
    /* mov     173,d0 */
    0x2c,
    0xad,
    0x00,
    /* syscall 0 */
    0xf0,
    0xe0,
    TRAMP_SENTINEL_INSN
  },
  am33_linux_sigframe_cache_init
};

/* Relevant struct definitions for signal handling...

From arch/mn10300/kernel/sigframe.h:

struct sigframe
{
	void (*pretcode)(void);
	int sig;
	struct sigcontext sc;
	struct fpucontext fpuctx;
	unsigned long extramask[_NSIG_WORDS-1];
	char retcode[8];
};

struct rt_sigframe
{
	void (*pretcode)(void);
	int sig;
	struct siginfo *pinfo;
	void *puc;
	struct siginfo info;
	struct ucontext uc;
	struct fpucontext fpuctx;
	char retcode[8];
};

From include/asm-mn10300/ucontext.h:

struct ucontext {
	unsigned long	  uc_flags;
	struct ucontext  *uc_link;
	stack_t		  uc_stack;
	struct sigcontext uc_mcontext;
	sigset_t	  uc_sigmask;
};

From include/asm-mn10300/sigcontext.h:

struct fpucontext {
	unsigned long	fs[32];
	unsigned long	fpcr;
};

struct sigcontext {
	unsigned long	d0;
	unsigned long	d1;
	unsigned long	d2;
	unsigned long	d3;
	unsigned long	a0;
	unsigned long	a1;
	unsigned long	a2;
	unsigned long	a3;
	unsigned long	e0;
	unsigned long	e1;
	unsigned long	e2;
	unsigned long	e3;
	unsigned long	e4;
	unsigned long	e5;
	unsigned long	e6;
	unsigned long	e7;
	unsigned long	lar;
	unsigned long	lir;
	unsigned long	mdr;
	unsigned long	mcvf;
	unsigned long	mcrl;
	unsigned long	mcrh;
	unsigned long	mdrq;
	unsigned long	sp;
	unsigned long	epsw;
	unsigned long	pc;
	struct fpucontext *fpucontext;
	unsigned long	oldmask;
}; */


#define AM33_SIGCONTEXT_D0 0
#define AM33_SIGCONTEXT_D1 4
#define AM33_SIGCONTEXT_D2 8
#define AM33_SIGCONTEXT_D3 12
#define AM33_SIGCONTEXT_A0 16
#define AM33_SIGCONTEXT_A1 20
#define AM33_SIGCONTEXT_A2 24
#define AM33_SIGCONTEXT_A3 28
#define AM33_SIGCONTEXT_E0 32
#define AM33_SIGCONTEXT_E1 36
#define AM33_SIGCONTEXT_E2 40
#define AM33_SIGCONTEXT_E3 44
#define AM33_SIGCONTEXT_E4 48
#define AM33_SIGCONTEXT_E5 52
#define AM33_SIGCONTEXT_E6 56
#define AM33_SIGCONTEXT_E7 60
#define AM33_SIGCONTEXT_LAR 64
#define AM33_SIGCONTEXT_LIR 68
#define AM33_SIGCONTEXT_MDR 72
#define AM33_SIGCONTEXT_MCVF 76
#define AM33_SIGCONTEXT_MCRL 80
#define AM33_SIGCONTEXT_MCRH 84
#define AM33_SIGCONTEXT_MDRQ 88
#define AM33_SIGCONTEXT_SP 92
#define AM33_SIGCONTEXT_EPSW 96
#define AM33_SIGCONTEXT_PC 100
#define AM33_SIGCONTEXT_FPUCONTEXT 104


static void
am33_linux_sigframe_cache_init (const struct tramp_frame *self,
                                struct frame_info *next_frame,
			        struct trad_frame_cache *this_cache,
			        CORE_ADDR func)
{
  CORE_ADDR sc_base, fpubase;
  int i;

  sc_base = frame_unwind_register_unsigned (next_frame, E_SP_REGNUM);
  if (self == &am33_linux_sigframe)
    {
      sc_base += 8;
    }
  else
    {
      sc_base += 12;
      sc_base = get_frame_memory_unsigned (next_frame, sc_base, 4);
      sc_base += 20;
    }

  trad_frame_set_reg_addr (this_cache, E_D0_REGNUM,
                           sc_base + AM33_SIGCONTEXT_D0);
  trad_frame_set_reg_addr (this_cache, E_D1_REGNUM,
                           sc_base + AM33_SIGCONTEXT_D1);
  trad_frame_set_reg_addr (this_cache, E_D2_REGNUM,
                           sc_base + AM33_SIGCONTEXT_D2);
  trad_frame_set_reg_addr (this_cache, E_D3_REGNUM,
                           sc_base + AM33_SIGCONTEXT_D3);

  trad_frame_set_reg_addr (this_cache, E_A0_REGNUM,
                           sc_base + AM33_SIGCONTEXT_A0);
  trad_frame_set_reg_addr (this_cache, E_A1_REGNUM,
                           sc_base + AM33_SIGCONTEXT_A1);
  trad_frame_set_reg_addr (this_cache, E_A2_REGNUM,
                           sc_base + AM33_SIGCONTEXT_A2);
  trad_frame_set_reg_addr (this_cache, E_A3_REGNUM,
                           sc_base + AM33_SIGCONTEXT_A3);

  trad_frame_set_reg_addr (this_cache, E_E0_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E0);
  trad_frame_set_reg_addr (this_cache, E_E1_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E1);
  trad_frame_set_reg_addr (this_cache, E_E2_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E2);
  trad_frame_set_reg_addr (this_cache, E_E3_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E3);
  trad_frame_set_reg_addr (this_cache, E_E4_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E4);
  trad_frame_set_reg_addr (this_cache, E_E5_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E5);
  trad_frame_set_reg_addr (this_cache, E_E6_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E6);
  trad_frame_set_reg_addr (this_cache, E_E7_REGNUM,
                           sc_base + AM33_SIGCONTEXT_E7);

  trad_frame_set_reg_addr (this_cache, E_LAR_REGNUM,
                           sc_base + AM33_SIGCONTEXT_LAR);
  trad_frame_set_reg_addr (this_cache, E_LIR_REGNUM,
                           sc_base + AM33_SIGCONTEXT_LIR);
  trad_frame_set_reg_addr (this_cache, E_MDR_REGNUM,
                           sc_base + AM33_SIGCONTEXT_MDR);
  trad_frame_set_reg_addr (this_cache, E_MCVF_REGNUM,
                           sc_base + AM33_SIGCONTEXT_MCVF);
  trad_frame_set_reg_addr (this_cache, E_MCRL_REGNUM,
                           sc_base + AM33_SIGCONTEXT_MCRL);
  trad_frame_set_reg_addr (this_cache, E_MDRQ_REGNUM,
                           sc_base + AM33_SIGCONTEXT_MDRQ);

  trad_frame_set_reg_addr (this_cache, E_SP_REGNUM,
                           sc_base + AM33_SIGCONTEXT_SP);
  trad_frame_set_reg_addr (this_cache, E_PSW_REGNUM,
                           sc_base + AM33_SIGCONTEXT_EPSW);
  trad_frame_set_reg_addr (this_cache, E_PC_REGNUM,
                           sc_base + AM33_SIGCONTEXT_PC);

  fpubase = get_frame_memory_unsigned (next_frame,
                                       sc_base + AM33_SIGCONTEXT_FPUCONTEXT, 4);
  if (fpubase)
    {
      for (i = 0; i < 32; i++)
	{
	  trad_frame_set_reg_addr (this_cache, E_FS0_REGNUM + i, fpubase + 4 * i);
	}
      trad_frame_set_reg_addr (this_cache, E_FPCR_REGNUM, fpubase + 4 * 32);
    }

  trad_frame_set_id (this_cache, frame_id_build (sc_base, func));
}


static void
am33_linux_init_osabi (struct gdbarch_info gdbinfo, struct gdbarch *gdbarch)
{
  tramp_frame_prepend_unwinder (gdbarch, &am33_linux_sigframe);
  tramp_frame_prepend_unwinder (gdbarch, &am33_linux_rt_sigframe);
}

void
_initialize_mn10300_linux_tdep (void)
{
  deprecated_add_core_fns (&regset_core_fns);
  gdbarch_register_osabi (bfd_arch_mn10300, 0,
                          GDB_OSABI_LINUX, am33_linux_init_osabi);
}
