/* include/asm-mn10300/rwlock.h
 *
 *	Helpers used by both rw spinlocks and rw semaphores.
 *
 *	Based in part on code from semaphore.h and
 *	spinlock.h Copyright 1996 Linus Torvalds.
 *
 *	Copyright 1999 Red Hat, Inc.
 *
 *	Written by Benjamin LaHaise.
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version
 *	2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_RWLOCK_H
#define _ASM_RWLOCK_H

#error these are NOT atomic

typedef struct { unsigned long a[100]; } __dummy_lock_t;
#define __dummy_lock(lock) (*(__dummy_lock_t *)(lock))

#define RW_LOCK_BIAS		 0x01000000
#define RW_LOCK_BIAS_STR	"0x01000000"

#define __build_read_lock_ptr(rw, helper)   \
	asm volatile("mov (%0),d3\n" \
		     "sub 1,d3\n" \
		     "mov d3,(%0)\n" \
		     "blt 1f\n" \
		     "bra 2f\n" \
		     "1:\tjmp 3f\n" \
		     "2:\n" \
		     ".section .text.lock,\"ax\"\n" \
		     "3:\tcall " helper "[],0\n\t" \
		     "jmp 2b\n" \
		     ".previous" \
		     ::"d" (rw) : "memory","d3","cc")

#define __build_read_lock_const(rw, helper)   \
	asm volatile("mov (%0),d3\n" \
		     "sub 1,d3\n" \
		     "mov d3,(%0)\n" \
		     "blt 1f\n" \
		     "bra 2f\n" \
		     "1:\tjmp 3f\n" \
		     "2:\n" \
		     ".section .text.lock,\"ax\"\n" \
		     "3:\tcall " helper "[],0\n\t" \
		     "jmp 2b\n" \
		     ".previous" \
		     ::"d" (rw) : "memory","d3","cc")

#define __build_read_lock(rw, helper)	do { \
						if (__builtin_constant_p(rw)) \
							__build_read_lock_const(rw, helper); \
						else \
							__build_read_lock_ptr(rw, helper); \
					} while (0)

#define __build_write_lock_ptr(rw, helper)   \
	asm volatile("mov (%0),d3\n" \
		     "sub 1,d3\n" \
		     "mov d3,(%0)\n" \
		     "blt 1f\n" \
		     "bra 2f\n" \
		     "1:\tjmp 3f\n" \
		     "2:\n" \
		     ".section .text.lock,\"ax\"\n" \
		     "3:\tcall " helper "[],0\n\t" \
		     "jmp 2b\n" \
		     ".previous" \
		     ::"d" (rw) : "memory","d3","cc")

#define __build_write_lock_const(rw, helper)   \
	asm volatile("mov (%0),d3\n" \
		     "sub 1,d3\n" \
		     "mov d3,(%0)\n" \
		     "blt 1f\n" \
		     "bra 2f\n" \
		     "1:\tjmp 3f\n" \
		     "2:\n" \
		     ".section .text.lock,\"ax\"\n" \
		     "3:\tcall " helper "[],0\n\t" \
		     "jmp 2b\n" \
		     ".previous" \
		     ::"d" (rw) : "memory","d3","cc")

#define __build_write_lock(rw, helper)	do { \
						if (__builtin_constant_p(rw)) \
							__build_write_lock_const(rw, helper); \
						else \
							__build_write_lock_ptr(rw, helper); \
					} while (0)

#endif /* _ASM_RWLOCK_H */
