#############################################################
#
# glib
#
#############################################################
ifneq ($(USE_CVS), true)
GLIB_SOURCE:=glib.tar.gz
GLIB_SITE:=ftp://ftp.gnu.org/non-gnu/glib
GLIB_CAT:=zcat
endif

GLIB_DIR:=$(BUILD_DIR)/glib
GLIB_LIBRARY:=libglib-1.2.so.0
GLIB_INCLUDE:=GlibLexer.h
GLIB_STAGING_LIBRARY:=usr/lib/$(GLIB_LIBRARY)
GLIB_STAGING_INCLUDE:=usr/include/$(GLIB_INCLUDE)

$(DL_DIR)/$(GLIB_SOURCE):

ifneq ($(USE_CVS),true)
glib-source: $(DL_DIR)/$(GLIB_SOURCE)
else
glib-source:
endif

GLIB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d glib $(CVS_TAG) $(CVS_PREFIX)glib

glib-checkout:
	@$(GLIB_CVSCO)

$(GLIB_DIR)/.unpacked: $(DL_DIR)/$(GLIB_SOURCE)
ifneq ($(USE_CVS), true)
	$(GLIB_CAT) $(DL_DIR)/$(GLIB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GLIB_CVSCO)
endif
	-cat $(SOURCE_DIR)/glib.patch | patch -p0 -d $(GLIB_DIR)
	-cat $(SOURCE_DIR)/glib-nouscore.patch | patch -p0 -d $(GLIB_DIR)
	cp $(SOURCE_DIR)/config.sub $(GLIB_DIR)
	touch  $(GLIB_DIR)/.unpacked

$(GLIB_DIR)/.configured: $(GLIB_DIR)/.unpacked
	cd $(GLIB_DIR); \
	rm -rf config.cache; \
	$(TARGET_CONFIGURE_OPTS) \
	CFLAGS="$(TARGET_CFLAGS)" \
	    ./configure \
	    --target=$(GNU_TARGET_NAME) \
	    --host=$(GNU_TARGET_NAME) \
	    --build=$(GNU_HOST_NAME) \
	    --prefix=/usr \
	    --exec-prefix=/usr
	touch  $(GLIB_DIR)/.configured

$(GLIB_DIR)/.libs/$(GLIB_LIBRARY): $(GLIB_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(GLIB_DIR)

$(TARGET_DIR)/$(GLIB_STAGING_LIBRARY): $(GLIB_DIR)/.libs/$(GLIB_LIBRARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(GLIB_DIR) install
	rm -f $(TARGET_DIR)/usr/lib/libglib*.la
	rm -f $(TARGET_DIR)/usr/lib/libgthread*.la
	rm -f $(TARGET_DIR)/usr/lib/libgmodule*.la
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(GLIB_DIR) install
	rm -f $(STAGING_DIR)/usr/lib/libglib*.la
	rm -f $(STAGING_DIR)/usr/lib/libgthread*.la
	rm -f $(STAGING_DIR)/usr/lib/libgmodule*.la
	sed -i -e "s,^\(prefix=\).*,\1$(STAGING_DIR)/usr,g" \
		-e "s,^\(exec_prefix=\).*,\1$(STAGING_DIR)/usr,g" \
		$(STAGING_DIR)/usr/bin/glib-config

glib: uclibc $(TARGET_DIR)/$(GLIB_STAGING_LIBRARY)

glib-clean:
	-$(MAKE) PATH=$$PATH:/sbin DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(GLIB_DIR) uninstall
	-$(MAKE) -C $(GLIB_DIR) clean

glib-dirclean:
	rm -rf $(GLIB_DIR)

