#############################################################
#
# libiconv
#
#############################################################
# only for uclibc build
ifneq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
LIBICONV_SOURCE:=libiconv.tar.gz
LIBICONV_SITE:=ftp://ftp.gnu.org/gnu/libiconv
LIBICONV_CAT:=zcat
endif

LIBICONV_DIR:=$(BUILD_DIR)/libiconv
LIBICONV_BINARY:=libiconv.a
LIBICONV_TARGET_BINARY:=usr/lib/libiconv.a

ifneq ($(USE_CVS),true)
libiconv-fetch:
	 $(WGET) -P $(DL_DIR) $(LIBICONV_SITE)/$(LIBICONV_SOURCE)

libiconv-source: $(DL_DIR)/$(LIBICONV_SOURCE)
else
libiconv-source:
endif

LIBICONV_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d libiconv $(CVS_TAG) $(CVS_PREFIX)libiconv

libiconv-checkout:
	@$(LIBICONV_CVSCO)

$(LIBICONV_DIR)/.unpacked: $(DL_DIR)/$(LIBICONV_SOURCE)
ifneq ($(USE_CVS),true)
	$(LIBICONV_CAT) $(DL_DIR)/$(LIBICONV_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LIBICONV_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(LIBICONV_DIR)/
	touch $(LIBICONV_DIR)/.unpacked

$(LIBICONV_DIR)/.configured: $(LIBICONV_DIR)/.unpacked
	(cd $(LIBICONV_DIR); rm -rf config.cache; \
		find . -name configure.ac | xargs touch; \
		find . -name aclocal.m4 | xargs touch; \
		find . -name Makefile.am | xargs touch; \
		find . -name Makefile.in | xargs touch; \
		ac_cv_linux_vers=2 \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--with-pcap=linux \
		--enable-ipv6 \
	);
	touch  $(LIBICONV_DIR)/.configured

$(LIBICONV_DIR)/$(LIBICONV_BINARY): $(LIBICONV_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(LIBICONV_DIR)

$(STAGING_DIR)/$(LIBICONV_TARGET_BINARY): $(LIBICONV_DIR)/$(LIBICONV_BINARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBICONV_DIR) install
	install -d $(DOC_DIR)/doc/libiconv
	@for f in README ; do \
		install -m0644 $(LIBICONV_DIR)/$$f $(DOC_DIR)/doc/libiconv/$$f ;\
	done
	rm -f $(STAGING_DIR)/lib/libiconv.la

$(TARGET_DIR)/$(LIBICONV_TARGET_BINARY): $(STAGING_DIR)/$(LIBICONV_TARGET_BINARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(LIBICONV_DIR) install
	install -d $(DOC_DIR)/doc/libiconv
	@for f in README ; do \
		install -m0644 $(LIBICONV_DIR)/$$f $(DOC_DIR)/doc/libiconv/$$f ;\
	done
	rm -f $(TARGET_DIR)/lib/libiconv.la

libiconv: uclibc $(TARGET_DIR)/$(LIBICONV_TARGET_BINARY)

libiconv-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBICONV_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/libiconv
	-$(MAKE) -C $(LIBICONV_DIR) clean

libiconv-dirclean:
	rm -rf $(LIBICONV_DIR)
endif

