#############################################################
#
# pango
#
#############################################################
ifneq ($(USE_CVS),true)
PANGO_SOURCE:=pango.tar.gz
PANGO_SITE:=xxxxxxxxxxxxxxxxxxxxxxxx
PANGO_CAT:=zcat
endif

PANGO_DIR:=$(BUILD_DIR)/pango

ifneq ($(USE_CVS),true)
pango-fetch:
	 $(WGET) -P $(DL_DIR) $(PANGO_SITE)/$(PANGO_SOURCE)

pango-source: $(DL_DIR)/$(PANGO_SOURCE)
else
pango-source:
endif

PANGO_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d pango $(CVS_TAG) $(CVS_PREFIX)pango

pango-checkout:
	@$(PANGO_CVSCO)

$(PANGO_DIR)/.unpacked: $(DL_DIR)/$(PANGO_SOURCE)
ifneq ($(USE_CVS),true)
	$(PANGO_CAT) $(DL_DIR)/$(PANGO_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PANGO_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(PANGO_DIR)/
	touch $(PANGO_DIR)/.unpacked

$(PANGO_DIR)/.configured: $(PANGO_DIR)/.unpacked
	(cd $(PANGO_DIR); rm -rf config.cache; automake -a; \
		EGREP=egrep \
		GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0/include" \
		GLIB_LIBS="-L$(STAGING_DIR)/usr/lib" autoconf; autoheader; \
		$(TARGET_CONFIGURE_OPTS) CC_FOR_BUILD=$(HOSTCC) \
		CFLAGS="$(TARGET_CFLAGS) -I$(STAGING_DIR)/usr/include -I$(STAGING_DIR)/usr/include/freetype2" \
		LDFLAGS="-L$(STAGING_DIR)/usr/lib" \
		ac_cv_path_FREETYPE_CONFIG=$(STAGING_DIR)/usr/bin/freetype-config \
		lt_cv_prog_cc_pic=' -fPIC -DPIC' \
		lt_cv_prog_cc_can_build_shared=yes \
		lt_cv_prog_cc_no_builtin= \
		lt_cv_prog_cc_shlib= \
		lt_cv_prog_cc_static=-static \
		lt_cv_prog_cc_static_works=yes \
		lt_cv_prog_cc_wl=-Wl, \
		STAGING_DIR=$(STAGING_DIR) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--without-qt \
		--x-includes=$(STAGING_DIR)/usr/X11R6/include \
		--x-libraries=$(STAGING_DIR)/usr/X11R6/lib \
		--disable-gtk-doc \
		--disable-glibtest \
	);
	touch  $(PANGO_DIR)/.configured

$(PANGO_DIR)/pango/.libs/libpango-1.0.so: $(PANGO_DIR)/.configured
	$(MAKE) CC_FOR_BUILD=$(HOSTCC)  \
		EGREP=egrep \
		GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
		GLIB_LIBS="-L$(STAGING_DIR)/usr/lib"  \
		XFT_CFLAGS="-I$(STAGING_DIR)/usr/X11R6/include -I$(STAGING_DIR)/usr/include/freetype2 -I$(STAGING_DIR)/usr/include/freetype2/config" \
		XFT_LIBS="-L$(STAGING_DIR)/usr/X11R6/lib -lXft -lX11 -lfreetype -lXrender -lfontconfig" \
		FREETYPE_LIBS="-lfontconfig -lfreetype -lxmlparse -lxmltok -lgmodule-2.0 -lgobject-2.0 -lglib-2.0" -C $(PANGO_DIR)

$(STAGING_DIR)/usr/lib/libpango-1.0.so: $(PANGO_DIR)/pango/.libs/libpango-1.0.so
	$(MAKE) \
	    EGREP=egrep \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=/usr \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/pango \
	    -C $(PANGO_DIR) install-strip;
	chmod a-x $(STAGING_DIR)/usr/lib/libpango*so*
	rm -f $(STAGING_DIR)/usr/lib/libpango*.la

$(TARGET_DIR)/usr/lib/libpango-1.0.so: $(STAGING_DIR)/usr/lib/libpango-1.0.so
	$(MAKE) \
	    EGREP=egrep \
	    GLIB_CFLAGS="-I$(STAGING_DIR)/usr/include/glib-2.0 -I$(STAGING_DIR)/lib/glib-2.0/include" \
	    GLIB_LIBS="-L$(STAGING_DIR)/usr/lib" \
	    CC_FOR_BUILD=$(HOSTCC)  \
	    prefix=$(STAGING_DIR) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=/usr \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/pango \
	    -C $(PANGO_DIR) install-strip;
ifeq ($(USE_GLIBC),true)
	install -m 0755 $(SOURCE_DIR)/firstboot.glibc $(TARGET_DIR)/sbin/firstboot
else
	install -m 0755 $(SOURCE_DIR)/firstboot.uclibc $(TARGET_DIR)/sbin/firstboot
endif
	chmod a-x $(TARGET_DIR)/usr/lib/libpango*so*
	rm -f $(TARGET_DIR)/usr/lib/libpango*.la
	mkdir -p $(DOC_DIR)/doc/pango
	@for f in COPYING README ; do \
		install -m0644 -D $(PANGO_DIR)/$$f $(DOC_DIR)/doc/pango/$$f ;\
	done

pango-clean:
	-$(MAKE) \
	    prefix=$(TARGET_DIR) \
	    exec_prefix=$(TARGET_DIR) \
	    bindir=$(TARGET_DIR)/bin \
	    sbindir=$(TARGET_DIR)/sbin \
	    libexecdir=$(TARGET_DIR)/usr/lib \
	    datadir=$(TARGET_DIR)/share \
	    sysconfdir=$(TARGET_DIR)/etc \
	    localstatedir=$(TARGET_DIR)/var \
	    libdir=$(TARGET_DIR)/usr/lib \
	    infodir=$(TARGET_DIR)/info \
	    mandir=$(TARGET_DIR)/man \
	    includedir=$(TARGET_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/pango \
	    -C $(PANGO_DIR) uninstall
	-$(MAKE)  \
	    prefix=$(STAGING_DIR) \
	    exec_prefix=$(STAGING_DIR) \
	    bindir=$(STAGING_DIR)/bin \
	    sbindir=$(STAGING_DIR)/sbin \
	    libexecdir=$(STAGING_DIR)/usr/lib \
	    datadir=$(STAGING_DIR)/share \
	    sysconfdir=$(STAGING_DIR)/etc \
	    localstatedir=$(STAGING_DIR)/var \
	    libdir=$(STAGING_DIR)/usr/lib \
	    infodir=$(STAGING_DIR)/info \
	    mandir=$(STAGING_DIR)/man \
	    includedir=$(STAGING_DIR)/usr/include \
	    strip=$(TARGET_CROSS)strip \
	    docdir=$(DOC_DIR)/doc/pango \
	    -C $(PANGO_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/pango
	$(MAKE) -C $(PANGO_DIR) clean


pango-dirclean:
	rm -rf $(PANGO_DIR)

pango: uclibc $(TARGET_DIR)/usr/lib/libpango-1.0.so


