#
# samba
#
######################################################
ifneq ($(USE_CVS),true)
SAMBA_SOURCE:=samba.tar.gz
SAMBA_SITE:=http://us1.samba.org/samba/ftp/
SAMBA_CAT:=zcat
SAMBA_DIR:=$(BUILD_DIR)/samba
else
# using CVS
SAMBA_DIR:=$(BUILD_DIR)/samba
endif

ifeq ($(USE_GLIBC),true)
SAMBA_CONFIG_PAM=--with-pam --with-pam_smbpass
SAMBA_POST=samba-pam samba-init
SAMBA_PREREQ=pam initscripts
else
SAMBA_CONFIG_PAM=--without-pam
endif

SAMBA_BINARY:=bin/smbmount
SAMBA_TARGET_BINARY:=usr/$(SAMBA_BINARY)

TARGET_LOGROTATE_DIR := $(TARGET_DIR)/etc/logrotate.d
TARGET_LIBSECURITY_DIR := $(TARGET_DIR)/lib/security
TARGET_SYSCONFIG_DIR := $(TARGET_DIR)/etc/sysconfig

ifneq ($(USE_CVS),true)
samba-fetch:
	$(WGET) -P $(DL_DIR) $(SAMBA_SITE)/$(SAMBA_SOURCE)

samba-source: $(DL_DIR)/$(SAMBA_SOURCE)
else
samba-source:
endif

SAMBA_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d samba $(CVS_TAG) $(CVS_PREFIX)samba

samba-checkout:
	@$(SAMBA_CVSCO)

$(SAMBA_DIR)/.unpacked: $(DL_DIR)/$(SAMBA_SOURCE)
ifneq ($(USE_CVS),true)
	$(SAMBA_CAT) $(DL_DIR)/$(SAMBA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SAMBA_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(SAMBA_DIR)/
	touch $(SAMBA_DIR)/.unpacked

$(SAMBA_DIR)/.configured: $(SAMBA_DIR)/.unpacked
	(cd $(SAMBA_DIR)/source; rm -rf config.cache; \
		samba_cv_HAVE_GETTIMEOFDAY_TZ=yes \
		samba_cv_HAVE_IFACE_IFCONF=yes \
		samba_cv_have_setresuid=yes \
		samba_cv_have_setresgid=yes \
		samba_cv_USE_SETRESUID=yes \
                $(TARGET_CONFIGURE_OPTS) \
                CFLAGS="$(TARGET_CFLAGS) -D_GNU_SOURCE" \
                ./configure \
                --target=$(GNU_TARGET_NAME) \
                --host=$(GNU_TARGET_NAME) \
                --build=$(GNU_HOST_NAME) \
                --prefix=/usr \
                --exec-prefix=/usr \
                --bindir=/usr/bin \
                --sbindir=/usr/sbin \
                --libexecdir=/usr/lib \
                --sysconfdir=/etc \
                --datadir=/usr/share \
                --localstatedir=/var \
                --mandir=/usr/man \
                --infodir=/usr/info \
		--with-configdir=/etc/samba \
		--with-privatedir=/etc/samba \
		--with-lockdir=/var/cache/samba \
                $(DISABLE_NLS) \
		--with-libsmbclient \
		--with-smbmount \
		--with-utmp \
		--with-syslog \
		--without-smbwrapper \
		--disable-xmltest \
		--disable-cups \
		$(SAMBA_CONFIG_PAM) \
        );
	touch $(SAMBA_DIR)/.configured

$(SAMBA_DIR)/source/$(SAMBA_BINARY): $(SAMBA_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(SAMBA_DIR)/source

$(TARGET_DIR)/$(SAMBA_TARGET_BINARY): $(SAMBA_DIR)/source/$(SAMBA_BINARY)
	install -d -m0755 $(TARGET_DIR)/var/cache/samba
	install -d -m0750 $(TARGET_DIR)/var/cache/samba/winbindd_privileged
	$(MAKE) CC=$(TARGET_CC) DESTDIR=$(STAGING_DIR) -C $(SAMBA_DIR)/source install
	touch $(TARGET_DIR)/touchme
	$(MAKE) CC=$(TARGET_CC) DESTDIR=$(TARGET_DIR) -C $(SAMBA_DIR)/source install
	rm -f $(TARGET_DIR)/sbin/mount.smbfs
	ln -s ../usr/bin/smbmount $(TARGET_DIR)/sbin/mount.smbfs
	install -d -m0755 $(TARGET_DIR)/etc/samba
	install -m0644 $(SAMBA_DIR)/packaging/RedHat/smb.conf \
		$(TARGET_DIR)/etc/samba/smb.conf
	install -m0644 $(SAMBA_DIR)/packaging/RedHat/smbusers \
		$(TARGET_DIR)/etc/samba/smbusers
	echo 127.0.0.1 localhost > $(TARGET_DIR)/etc/samba/lmhosts
	install -m0755 $(SAMBA_DIR)/source/script/mksmbpasswd.sh $(TARGET_DIR)/usr/bin
	install -m0755 $(SAMBA_DIR)/source/nsswitch/libnss_winbind.so $(TARGET_DIR)/lib/libnss_winbind.so.2
	ln -sf /lib/libnss_winbind.so.2 $(TARGET_DIR)/lib/libnss_winbind.so
	install -m0755 $(SAMBA_DIR)/source/nsswitch/libnss_wins.so $(TARGET_DIR)/lib/libnss_wins.so.2
	ln -sf /lib/libnss_wins.so.2 $(TARGET_DIR)/lib/libnss_wins.so
	@echo "Stripping samba binaries..."
	@for f in `find $(TARGET_DIR) -type f -newer $(TARGET_DIR)/touchme -exec file {} \; | \
		grep "ELF.*not stripped" | cut -d : -f 1` ; do \
	    $(STRIP) $$f ; \
	done 
	rm -f $(TARGET_DIR)/touchme
	@echo "done."
	mkdir -p $(DOC_DIR)/doc/samba
	for f in README COPYING WHATSNEW.txt ; do \
	    install -m0644 $(SAMBA_DIR)/$$f $(DOC_DIR)/doc/samba/ ; \
	done
	cp -a $(SAMBA_DIR)/docs/faq $(DOC_DIR)/doc/samba/
	cp -a $(SAMBA_DIR)/docs/htmldocs $(DOC_DIR)/doc/samba/
	cp -a $(SAMBA_DIR)/docs/Samba-HOWTO-Collection.pdf $(DOC_DIR)/doc/samba/
	-find $(DOC_DIR)/doc/samba -type d -name CVS | xargs rm -rf
	if [ ! -d $(TARGET_LOGROTATE_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LOGROTATE_DIR); \
	fi
	install -m0644 $(SOURCE_DIR)/samba.log $(TARGET_LOGROTATE_DIR)/samba
	install -d -m0700 $(TARGET_DIR)/var/log/samba
	if [ ! -d $(TARGET_SYSCONFIG_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_SYSCONFIG_DIR); \
	fi
	install -m0644 $(SAMBA_DIR)/packaging/RedHat/samba.sysconfig $(TARGET_SYSCONFIG_DIR)/samba

$(TARGET_DIR)/etc/pam.d/samba: $(TARGET_DIR)/$(SAMBA_TARGET_BINARY)
	install -m0644 $(SAMBA_DIR)/packaging/RedHat/samba.pamd.stack \
		$(TARGET_DIR)/etc/pam.d/samba
	if [ ! -d $(TARGET_LIBSECURITY_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LIBSECURITY_DIR); \
	fi
	install -m0755 $(SAMBA_DIR)/source/bin/pam_smbpass.so $(TARGET_LIBSECURITY_DIR)
	install -m0755 $(SAMBA_DIR)/source/nsswitch/pam_winbind.so $(TARGET_LIBSECURITY_DIR)

samba-pam: $(TARGET_DIR)/etc/pam.d/samba

$(TARGET_DIR)/etc/rc.d/init.d/smb: $(TARGET_DIR)/$(SAMBA_TARGET_BINARY)
	install -m0755 $(SAMBA_DIR)/packaging/RedHat/smb.init \
		$(TARGET_DIR)/etc/rc.d/init.d/smb
	install -m0755 $(SAMBA_DIR)/packaging/RedHat/winbind.init \
		$(TARGET_DIR)/etc/rc.d/init.d/winbind

samba-init: $(TARGET_DIR)/etc/rc.d/init.d/smb

samba: uclibc $(SAMBA_PREREQ) $(TARGET_DIR)/$(SAMBA_TARGET_BINARY) $(SAMBA_POST)

samba-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SAMBA_DIR)/source uninstall
	-rm -f $(TARGET_DIR)/etc/pam.d/samba \
		$(TARGET_DIR)/etc/rc.d/init.d/smb \
		$(TARGET_DIR)/etc/smb.conf
	$(MAKE) -C $(SAMBA_DIR)/source clean
	-rm -rf $(DOC_DIR)/doc/samba

samba-dirclean:
	-rm -rf $(SAMBA_DIR)

