#
# w3c-libwww
#
######################################################
ifneq ($(USE_CVS),true)
LIBWWW_SOURCE:=w3c-libwww.tar.gz
LIBWWW_SITE:=http://www.w3.org/Library/Distribution/
LIBWWW_CAT:=zcat
LIBWWW_DIR:=$(BUILD_DIR)/w3c-libwww
else
LIBWWW_DIR:=$(BUILD_DIR)/w3c-libwww
endif

LIBWWW_BINARY:=libwwwcore.so.0.1.0
LIBWWW_TARGET_BINARY:=$(TARGET_DIR)/usr/lib/$(LIBWWW_BINARY)

ifneq ($(USE_CVS),true)
libwww-fetch:
	$(WGET) -P $(DL_DIR) $(LIBWWW_SITE)/$(LIBWWW_SOURCE)

libwww-source: $(DL_DIR)/$(LIBWWW_SOURCE)
else
libwww-source:
endif

LIBWWW_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d w3c-libwww $(CVS_TAG) $(CVS_PREFIX)w3c-libwww

w3c-libwww-checkout:
	@$(LIBWWW_CVSCO)

$(LIBWWW_DIR)/.unpacked: $(DL_DIR)/$(LIBWWW_SOURCE)
ifneq ($(USE_CVS),true)
	$(LIBWWW_CAT) $(DL_DIR)/$(LIBWWW_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LIBWWW_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(LIBWWW_DIR)/config/
	touch $(LIBWWW_DIR)/.unpacked

$(LIBWWW_DIR)/.configured: $(LIBWWW_DIR)/.unpacked
	(cd $(LIBWWW_DIR); rm -rf config.cache; \
                $(TARGET_CONFIGURE_OPTS) \
		CONFIG_SITE=$(SOURCE_DIR)/config.site-$(BASEARCH) \
                CFLAGS="$(TARGET_CFLAGS)" \
                ./configure \
                --target=$(GNU_TARGET_NAME) \
                --host=$(GNU_TARGET_NAME) \
                --build=$(GNU_HOST_NAME) \
                --prefix=/usr \
                --exec-prefix=/usr \
                --bindir=/usr/bin \
                --sbindir=/usr/sbin \
                --libexecdir=/usr/lib \
                --sysconfdir=/etc \
                --datadir=/usr/share \
                --localstatedir=/var \
                --mandir=/usr/man \
                --infodir=/usr/info \
                $(DISABLE_NLS) \
                --disable-rpath \
                --disable-dependency-tracking \
        );
	touch $(LIBWWW_DIR)/.configured

$(LIBWWW_DIR)/Library/src/.libs/$(LIBWWW_BINARY): $(LIBWWW_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(LIBWWW_DIR)

$(LIBWWW_TARGET_BINARY): $(LIBWWW_DIR)/Library/src/.libs/$(LIBWWW_BINARY)
	# since we set DESTDIR on make install cmdline we need to hack this...
	for p in prefix exec_prefix ; do \
	    sed -i -e "s,^\($$p\)=.*,\1=$(STAGING_DIR)/usr," $(LIBWWW_DIR)/libwww-config ; \
	done; 
	$(MAKE) CC=$(TARGET_CC) DESTDIR=$(STAGING_DIR) -C $(LIBWWW_DIR) install
	touch $(TARGET_DIR)/.touchme
	$(MAKE) CC=$(TARGET_CC) DESTDIR=$(TARGET_DIR) -C $(LIBWWW_DIR) install 
	@echo "Removing w3c-libwww development files from $(TARGET_DIR)..."
	find $(TARGET_DIR) -name \*.a -newer $(TARGET_DIR)/.touchme | xargs rm -f
	@for f in `find $(TARGET_DIR) -type f -newer $(TARGET_DIR)/.touchme -exec file {} \; | \
		grep "ELF.*not stripped" | cut -d : -f 1` ; do \
	    $(STRIP) $$f ; \
	done
	rm -rf $(TARGET_DIR)/usr/include/w3c-libwww 
	rm -f $(TARGET_DIR)/usr/include/wwwconf.h
	rm -f $(TARGET_DIR)/usr/lib/libmd5*.la
	rm -f $(TARGET_DIR)/usr/lib/libpics*.la
	rm -f $(TARGET_DIR)/usr/lib/libwww*.la
	rm -f $(TARGET_DIR)/usr/lib/libxml*.la
	rm -f $(STAGING_DIR)/.touchme
	rm -f $(STAGING_DIR)/usr/lib/libmd5*.la
	rm -f $(STAGING_DIR)/usr/lib/libpics*.la
	rm -f $(STAGING_DIR)/usr/lib/libwww*.la
	rm -f $(STAGING_DIR)/usr/lib/libxml*.la
	mkdir -p $(DOC_DIR)/doc/w3c-libwww
	for f in COPYRIGHT.html COPYRIGH LICENSE.html README.html ; do \
	    install -m0644 $(LIBWWW_DIR)/$$f $(DOC_DIR)/doc/w3c-libwww/ ; \
	done
	mv $(DOC_DIR)/doc/w3c-libwww/COPYRIGH $(DOC_DIR)/doc/w3c-libwww/COPYRIGHT

w3c-libwww: uclibc $(LIBWWW_TARGET_BINARY)

w3c-libwww-clean:
	$(MAKE) -C $(LIBWWW_DIR) clean
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBWWW_DIR) uninstall
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(LIBWWW_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/w3c-libwww

w3c-libwww-dirclean:
	-rm -rf $(LIBWWW_DIR)

