'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\" Copyright (c) 2001 Kevin B. Kenny.  All rights reserved.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: lreplace.n,v 1.14 2003/03/19 23:01:12 cagney Exp $
'\" 
.so man.macros
.TH lreplace n 7.4 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
lreplace \- Replace elements in a list with new elements
.SH SYNOPSIS
\fBlreplace \fIlist first last \fR?\fIelement element ...\fR?
.BE

.SH DESCRIPTION
.PP
\fBlreplace\fR returns a new list formed by replacing one or more elements of
\fIlist\fR with the \fIelement\fR arguments.
\fIfirst\fR and \fIlast\fR specify the first and last index of the
range of elements to replace.  0 refers to the first element of the
list, and \fBend\fR (or any abbreviation of it) may be used to refer
to the last element of the list.  If \fIlist\fR is empty, then
\fIfirst\fR and \fIlast\fR are ignored.

If \fIfirst\fR is less than zero, it is considered to refer to the
first element of the list.  For non-empty lists, the element indicated
by \fIfirst\fR must exist.

If \fIlast\fR is less than zero but greater than \fIfirst\fR, then any
specified elements will be prepended to the list.  If \fIlast\fR is
less than \fIfirst\fR then no elements are deleted; the new elements
are simply inserted before \fIfirst\fR.

The \fIelement\fR arguments specify zero or more new arguments to
be added to the list in place of those that were deleted.
Each \fIelement\fR argument will become a separate element of
the list.  If no \fIelement\fR arguments are specified, then the elements
between \fIfirst\fR and \fIlast\fR are simply deleted.  If \fIlist\fR
is empty, any \fIelement\fR arguments are added to the end of the list.

.SH "SEE ALSO"
.VS 8.4
list(n), lappend(n), lindex(n), linsert(n), llength(n), lsearch(n), 
lset(n), lrange(n), lsort(n)
.VE

.SH KEYWORDS
element, list, replace
