/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Collation;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Library;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class Column {
    public HsqlNameManager.HsqlName columnName;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private Expression defaultExpression;
    long identityStart;
    long identityIncrement;
    static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    static final BigDecimal BIG_DECIMAL_0 = new BigDecimal(0.0);
    static final BigDecimal BIG_DECIMAL_1 = new BigDecimal(1.0);
    static int[] tenPower = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000};

    Column(HsqlNameManager.HsqlName name, boolean nullable, int type, int size, int scale, boolean primarykey, Expression defexpression) throws HsqlException {
        this.columnName = name;
        this.isNullable = nullable;
        this.colType = type;
        this.colSize = size;
        this.colScale = scale;
        this.isPrimaryKey = primarykey;
        this.defaultExpression = defexpression;
    }

    void setIdentity(boolean identity, long startvalue, long increment) throws HsqlException {
        this.isIdentity = identity;
        this.identityStart = startvalue;
        this.identityIncrement = increment;
        if (this.isIdentity && this.colType == 4 && (this.identityStart > Integer.MAX_VALUE || this.identityIncrement > Integer.MAX_VALUE)) {
            throw Trace.error(65, this.columnName.statementName);
        }
    }

    private Column() {
    }

    Column duplicate(boolean withIdentity) throws HsqlException {
        Column newCol = new Column();
        newCol.columnName = this.columnName;
        newCol.isNullable = this.isNullable;
        newCol.colType = this.colType;
        newCol.colSize = this.colSize;
        newCol.colScale = this.colScale;
        newCol.defaultExpression = this.defaultExpression;
        if (withIdentity) {
            newCol.setIdentity(this.isIdentity, this.identityStart, this.identityIncrement);
        }
        return newCol;
    }

    void setType(Column other) {
        this.isNullable = other.isNullable;
        this.colType = other.colType;
        this.colSize = other.colSize;
        this.colScale = other.colScale;
    }

    boolean isIdentity() {
        return this.isIdentity;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    void setNullable(boolean value) {
        this.isNullable = value;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
    }

    Object getDefaultValue(Session session) throws HsqlException {
        return this.defaultExpression == null ? null : this.defaultExpression.getValue(session, this.colType);
    }

    String getDefaultDDL() {
        String ddl = null;
        try {
            ddl = this.defaultExpression == null ? null : this.defaultExpression.getDDL();
        }
        catch (HsqlException hsqlException) {}
        return ddl;
    }

    Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    void setDefaultExpression(Expression expr) {
        this.defaultExpression = expr;
    }

    int getType() {
        return this.colType;
    }

    int getDIType() {
        return this.colType == 100 ? 12 : this.colType;
    }

    int getDITypeSub() {
        if (this.colType == 100) {
            return 4;
        }
        return 1;
    }

    int getSize() {
        return this.colSize;
    }

    int getScale() {
        return this.colScale;
    }

    static Object add(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad + bd));
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return String.valueOf((String)a) + (String)b;
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.add(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai + bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa + longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object concat(Object a, Object b) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        return String.valueOf(a.toString()) + b.toString();
    }

    static Object negate(Object a, int type) throws HsqlException {
        if (a == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = -((Number)a).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad));
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return ValuePool.getInt(-((Number)a).intValue());
            }
            case -5: {
                return ValuePool.getLong(-((Number)a).longValue());
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object multiply(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        if (!(a instanceof Number) || !(b instanceof Number)) {
            a = Column.convertObject(a, type);
            b = Column.convertObject(b, type);
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad * bd));
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.multiply(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai * bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa * longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object divide(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad / bd));
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                int scale = abd.scale() > bbd.scale() ? abd.scale() : bbd.scale();
                return bbd.signum() == 0 ? null : abd.divide(bbd, scale, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                if (bi == 0) {
                    throw Trace.error(6);
                }
                return ValuePool.getInt(ai / bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return longb == 0L ? null : ValuePool.getLong(longa / longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static Object subtract(Object a, Object b, int type) throws HsqlException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ValuePool.getDouble(Double.doubleToLongBits(ad - bd));
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.subtract(bbd);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ValuePool.getInt(ai - bi);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return ValuePool.getLong(longa - longb);
            }
        }
        throw Trace.error(20, Types.getTypeString(type));
    }

    static int compare(Collation collation, Object a, Object b, int type) {
        int i = 0;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (type) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                return collation.compare((String)a, (String)b);
            }
            case 1: {
                return collation.compare(Library.rtrim((String)a), Library.rtrim((String)b));
            }
            case 100: {
                return collation.compareIgnoreCase((String)a, (String)b);
            }
            case -6: 
            case 4: 
            case 5: {
                int ai = ((Number)a).intValue();
                int bi = ((Number)b).intValue();
                return ai > bi ? 1 : (bi > ai ? -1 : 0);
            }
            case -5: {
                long longa = ((Number)a).longValue();
                long longb = ((Number)b).longValue();
                return longa > longb ? 1 : (longb > longa ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double ad = ((Number)a).doubleValue();
                double bd = ((Number)b).doubleValue();
                return ad > bd ? 1 : (bd > ad ? -1 : 0);
            }
            case 2: 
            case 3: {
                i = ((BigDecimal)a).compareTo((BigDecimal)b);
                break;
            }
            case 91: {
                return HsqlDateTime.compare((Date)a, (Date)b);
            }
            case 92: {
                return HsqlDateTime.compare((Time)a, (Time)b);
            }
            case 93: {
                return HsqlDateTime.compare((Timestamp)a, (Timestamp)b);
            }
            case 16: {
                boolean boola = (Boolean)a;
                boolean boolb = (Boolean)b;
                return boola == boolb ? 0 : (boolb ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(a instanceof Binary) || !(b instanceof Binary)) break;
                i = Column.compareTo(((Binary)a).getBytes(), ((Binary)b).getBytes());
                break;
            }
            case 1111: {
                return 0;
            }
        }
        return i == 0 ? 0 : (i < 0 ? -1 : 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object convertObject(Object o, int type) throws HsqlException {
        try {
            if (o == null) {
                return null;
            }
            switch (type) {
                case 0: {
                    return null;
                }
                case -6: {
                    Integer n;
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        int val = Integer.parseInt((String)o);
                        o = ValuePool.getInt(val);
                    }
                    if (o instanceof Integer) {
                        int temp = ((Number)o).intValue();
                        if (127 < temp) throw Trace.error(65);
                        if (temp >= -128) return o;
                        throw Trace.error(65);
                    }
                    if (o instanceof Long) {
                        long temp = ((Number)o).longValue();
                        if (127L < temp) throw Trace.error(65);
                        if (temp >= -128L) return ValuePool.getInt(((Number)o).intValue());
                        throw Trace.error(65);
                    }
                    if (o instanceof Byte) {
                        return ValuePool.getInt(((Number)o).intValue());
                    }
                    if (o instanceof Number) {
                        return Column.convertObject(Column.convertToInt(o), type);
                    }
                    if (!(o instanceof Boolean)) break;
                    if (((Boolean)o).booleanValue()) {
                        n = ValuePool.getInt(1);
                        return n;
                    }
                    n = ValuePool.getInt(0);
                    return n;
                }
                case 5: {
                    Integer n;
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        int val = Integer.parseInt((String)o);
                        o = ValuePool.getInt(val);
                    }
                    if (o instanceof Integer) {
                        int temp = ((Number)o).intValue();
                        if (Short.MAX_VALUE < temp) throw Trace.error(65);
                        if (temp >= Short.MIN_VALUE) return o;
                        throw Trace.error(65);
                    }
                    if (o instanceof Long) {
                        long temp = ((Number)o).longValue();
                        if (32767L < temp) throw Trace.error(65);
                        if (temp >= -32768L) return ValuePool.getInt(((Number)o).intValue());
                        throw Trace.error(65);
                    }
                    if (o instanceof Byte) return ValuePool.getInt(((Number)o).intValue());
                    if (o instanceof Short) {
                        return ValuePool.getInt(((Number)o).intValue());
                    }
                    if (o instanceof Number) {
                        return Column.convertObject(Column.convertToInt(o), type);
                    }
                    if (!(o instanceof Boolean)) break;
                    if (((Boolean)o).booleanValue()) {
                        n = ValuePool.getInt(1);
                        return n;
                    }
                    n = ValuePool.getInt(0);
                    return n;
                }
                case 4: {
                    Integer n;
                    if (o instanceof Integer) {
                        return o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        int val = Integer.parseInt((String)o);
                        return ValuePool.getInt(val);
                    }
                    if (o instanceof Long) {
                        long temp = ((Number)o).longValue();
                        if (Integer.MAX_VALUE < temp) throw Trace.error(65);
                        if (temp >= Integer.MIN_VALUE) return ValuePool.getInt(((Number)o).intValue());
                        throw Trace.error(65);
                    }
                    if (o instanceof Byte) return ValuePool.getInt(((Number)o).intValue());
                    if (o instanceof Short) {
                        return ValuePool.getInt(((Number)o).intValue());
                    }
                    if (o instanceof Number) {
                        return Column.convertToInt(o);
                    }
                    if (!(o instanceof Boolean)) break;
                    if (((Boolean)o).booleanValue()) {
                        n = ValuePool.getInt(1);
                        return n;
                    }
                    n = ValuePool.getInt(0);
                    return n;
                }
                case -5: {
                    Long l;
                    if (o instanceof Long) {
                        return o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        long val = Long.parseLong((String)o);
                        return ValuePool.getLong(val);
                    }
                    if (o instanceof Integer) {
                        return ValuePool.getLong(((Integer)o).longValue());
                    }
                    if (o instanceof Byte) return ValuePool.getLong(((Number)o).intValue());
                    if (o instanceof Short) {
                        return ValuePool.getLong(((Number)o).intValue());
                    }
                    if (o instanceof Number) {
                        return Column.convertToLong(o);
                    }
                    if (!(o instanceof Boolean)) break;
                    if (((Boolean)o).booleanValue()) {
                        l = ValuePool.getLong(1L);
                        return l;
                    }
                    l = ValuePool.getLong(0L);
                    return l;
                }
                case 6: 
                case 7: 
                case 8: {
                    Double d;
                    if (o instanceof Double) {
                        return o;
                    }
                    if (o instanceof String) {
                        o = Library.trim((String)o, " ", true, true);
                        double d2 = JavaSystem.parseDouble((String)o);
                        long l = Double.doubleToLongBits(d2);
                        return ValuePool.getDouble(l);
                    }
                    if (o instanceof Number) {
                        return Column.convertToDouble(o);
                    }
                    if (!(o instanceof Boolean)) break;
                    if (((Boolean)o).booleanValue()) {
                        d = ValuePool.getDouble(1L);
                        return d;
                    }
                    d = ValuePool.getDouble(0L);
                    return d;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal;
                    if (o instanceof BigDecimal) {
                        return o;
                    }
                    if (o instanceof Long) {
                        return BigDecimal.valueOf((Long)o);
                    }
                    if (!(o instanceof Boolean)) break;
                    if (((Boolean)o).booleanValue()) {
                        bigDecimal = BIG_DECIMAL_1;
                        return bigDecimal;
                    }
                    bigDecimal = BIG_DECIMAL_0;
                    return bigDecimal;
                }
                case 16: {
                    Boolean bl;
                    if (o instanceof Boolean) {
                        return (Boolean)o;
                    }
                    if (o instanceof String) {
                        Boolean bl2;
                        if (((String)(o = Library.trim((String)o, " ", true, true))).equalsIgnoreCase("TRUE")) {
                            bl2 = Boolean.TRUE;
                            return bl2;
                        }
                        bl2 = Boolean.FALSE;
                        return bl2;
                    }
                    if (o instanceof Integer) {
                        Boolean bl3;
                        if ((Integer)o == 0) {
                            bl3 = Boolean.FALSE;
                            return bl3;
                        }
                        bl3 = Boolean.TRUE;
                        return bl3;
                    }
                    if (o instanceof Long) {
                        Boolean bl4;
                        if ((Long)o == 0L) {
                            bl4 = Boolean.FALSE;
                            return bl4;
                        }
                        bl4 = Boolean.TRUE;
                        return bl4;
                    }
                    if (o instanceof Double) {
                        Boolean bl5;
                        if ((Double)o == 0.0) {
                            bl5 = Boolean.FALSE;
                            return bl5;
                        }
                        bl5 = Boolean.TRUE;
                        return bl5;
                    }
                    if (!(o instanceof BigDecimal)) throw Trace.error(16);
                    if (((BigDecimal)o).equals(BIG_DECIMAL_0)) {
                        bl = Boolean.FALSE;
                        return bl;
                    }
                    bl = Boolean.TRUE;
                    return bl;
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (o instanceof String) {
                        return o;
                    }
                    if (o instanceof Time) {
                        return HsqlDateTime.getTimeString((Time)o, null);
                    }
                    if (o instanceof Timestamp) {
                        return HsqlDateTime.getTimestampString((Timestamp)o, null);
                    }
                    if (o instanceof Date) {
                        return HsqlDateTime.getDateString((Date)o, null);
                    }
                    if (!(o instanceof byte[])) break;
                    return StringConverter.byteToHex((byte[])o);
                }
                case 92: {
                    if (o instanceof Time) {
                        return HsqlDateTime.getNormalisedTime((Time)o);
                    }
                    if (o instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedTime((Timestamp)o);
                    }
                    if (o instanceof String) {
                        return HsqlDateTime.timeValue((String)o);
                    }
                    if (!(o instanceof Date)) break;
                    throw Trace.error(95, Types.getTypeString(type));
                }
                case 93: {
                    if (o instanceof Timestamp) {
                        return o;
                    }
                    if (o instanceof Time) {
                        return HsqlDateTime.getNormalisedTimestamp((Time)o);
                    }
                    if (o instanceof Date) {
                        return HsqlDateTime.getNormalisedTimestamp((Date)o);
                    }
                    if (!(o instanceof String)) break;
                    return HsqlDateTime.timestampValue((String)o);
                }
                case 91: {
                    if (o instanceof Date) {
                        return HsqlDateTime.getNormalisedDate((Date)o);
                    }
                    if (o instanceof Timestamp) {
                        return HsqlDateTime.getNormalisedDate((Timestamp)o);
                    }
                    if (o instanceof String) {
                        return HsqlDateTime.dateValue((String)o);
                    }
                    if (!(o instanceof Time)) break;
                    throw Trace.error(95, Types.getTypeString(type));
                }
                case -4: 
                case -3: 
                case -2: {
                    if (o instanceof Binary) {
                        return o;
                    }
                    if (o instanceof byte[]) {
                        return new Binary((byte[])o, false);
                    }
                    if (!(o instanceof String)) throw Trace.error(95, Types.getTypeString(type));
                    return new Binary(StringConverter.hexToByte((String)o), false);
                }
                case 1111: {
                    if (o instanceof JavaObject) {
                        return o;
                    }
                    if (o instanceof String) {
                        return new JavaObject(StringConverter.hexToByte((String)o));
                    }
                    if (!(o instanceof Binary)) return new JavaObject((Serializable)o);
                    return new JavaObject(((Binary)o).getBytes());
                }
            }
            if (!(o instanceof JavaObject)) return Column.convertString(o.toString(), type);
            o = ((JavaObject)o).getObject();
            return Column.convertObject(o, type);
        }
        catch (HsqlException e) {
            throw e;
        }
        catch (Exception e) {
            throw Trace.error(16, e.toString());
        }
    }

    private static Object convertString(String s, int type) throws HsqlException {
        switch (type) {
            case -6: 
            case 5: {
                return Column.convertObject(s, type);
            }
            case 4: {
                int val = Integer.parseInt(s);
                return ValuePool.getInt(val);
            }
            case -5: {
                return ValuePool.getLong(Long.parseLong(s));
            }
            case 6: 
            case 7: 
            case 8: {
                double d = JavaSystem.parseDouble(s);
                long l = Double.doubleToLongBits(d);
                return ValuePool.getDouble(l);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return s;
            }
            case 91: {
                return HsqlDateTime.dateValue(s);
            }
            case 92: {
                return HsqlDateTime.timeValue(s);
            }
            case 93: {
                return HsqlDateTime.timestampValue(s);
            }
            case 2: 
            case 3: {
                s = Library.trim(s, " ", true, true);
                return new BigDecimal(s);
            }
            case 16: {
                return s.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Trace.error(95, Types.getTypeString(type));
    }

    static String createSQLString(Object o, int type) throws HsqlException {
        if (o == null) {
            return "NULL";
        }
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.createSQLString(((Number)o).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.toQuotedString(o.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                if (!(o instanceof Binary)) {
                    throw Trace.error(95);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((Binary)o).getBytes()), '\'', false);
            }
            case 1111: {
                if (!(o instanceof JavaObject)) {
                    throw Trace.error(18);
                }
                return StringConverter.toQuotedString(StringConverter.byteToHex(((JavaObject)o).getBytes()), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createSQLString((String)o);
            }
        }
        return o.toString();
    }

    public static String createSQLString(double x) {
        if (x == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (x == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(x)) {
            return "0E0/0E0";
        }
        String s = Double.toString(x);
        if (s.indexOf(69) < 0) {
            s = s.concat("E0");
        }
        return s;
    }

    public static String createSQLString(String s) {
        if (s == null) {
            return "NULL";
        }
        return StringConverter.toQuotedString(s, '\'', true);
    }

    public static Object convertObject(Session session, Object o, int type, int precision, int scale) throws HsqlException {
        if (o == null) {
            return o;
        }
        if (precision == 0) {
            return Column.convertObject(o, type);
        }
        boolean check = true;
        switch (type) {
            case -1: 
            case 100: {
                type = 12;
            }
            case 1: 
            case 12: {
                if (o instanceof String) {
                    check = false;
                } else {
                    o = Column.convertObject(o, 12);
                }
                return Column.enforceSize(o, type, precision, scale, check);
            }
            case 2: 
            case 3: {
                if (!(o instanceof BigDecimal)) {
                    o = Column.convertObject(o, type);
                }
                return Column.enforceSize(o, type, precision, scale, true);
            }
            case 93: {
                if (o instanceof Time) {
                    long millis = session.currentDate.getTime() + ((Time)o).getTime();
                    o = HsqlDateTime.getTimestamp(millis);
                }
                if (!(o instanceof Timestamp)) break;
                return Column.enforceSize(o, type, precision, scale, false);
            }
        }
        return Column.convertObject(o, type);
    }

    static Object enforceSize(Object obj, int type, int size, int scale, boolean check) throws HsqlException {
        if (obj == null) {
            return obj;
        }
        if (size == 0 && type != 93) {
            return obj;
        }
        switch (type) {
            case 1: {
                return Column.checkChar((String)obj, size, check);
            }
            case 12: 
            case 100: {
                return Column.checkVarchar((String)obj, size, check);
            }
            case 2: 
            case 3: {
                int sign;
                BigDecimal dec = (BigDecimal)obj;
                dec = dec.setScale(scale, 5);
                BigInteger big = JavaSystem.getUnscaledValue(dec);
                int n = sign = big.signum() == -1 ? 1 : 0;
                if (big.toString().length() - sign > size) {
                    throw Trace.error(124);
                }
                return dec;
            }
            case 93: {
                if (size == 6) {
                    return obj;
                }
                Timestamp ts = (Timestamp)obj;
                int nanos = ts.getNanos();
                int divisor = tenPower[size];
                int newNanos = nanos / divisor * divisor;
                ts.setNanos(newNanos);
                return ts;
            }
        }
        return obj;
    }

    static String checkVarchar(String s, int len, boolean check) throws HsqlException {
        int slen = s.length();
        if (slen > len) {
            if (check) {
                throw Trace.error(124);
            }
            return s.substring(0, len);
        }
        return s;
    }

    static String checkChar(String s, int len, boolean check) throws HsqlException {
        int slen = s.length();
        if (slen == len) {
            return s;
        }
        if (slen > len) {
            if (check) {
                throw Trace.error(124);
            }
            return s.substring(0, len);
        }
        char[] b = new char[len];
        s.getChars(0, slen, b, 0);
        int i = slen;
        while (i < len) {
            b[i] = 32;
            ++i;
        }
        return new String(b);
    }

    static Integer convertToInt(Object o) throws HsqlException {
        if (o instanceof BigDecimal) {
            BigInteger bi = ((BigDecimal)o).toBigInteger();
            if (bi.compareTo(MAX_INT) > 0 || bi.compareTo(MIN_INT) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getInt(bi.intValue());
        }
        if (o instanceof Double || o instanceof Float) {
            double d = ((Number)o).doubleValue();
            if (Double.isNaN(d) || d >= 2.147483648E9 || d <= -2.147483649E9) {
                throw Trace.error(65);
            }
            return ValuePool.getInt((int)d);
        }
        throw Trace.error(95);
    }

    static Long convertToLong(Object o) throws HsqlException {
        if (o instanceof BigDecimal) {
            BigInteger bi = ((BigDecimal)o).toBigInteger();
            if (bi.compareTo(MAX_LONG) > 0 || bi.compareTo(MIN_LONG) < 0) {
                throw Trace.error(65);
            }
            return ValuePool.getLong(bi.longValue());
        }
        if (o instanceof Double || o instanceof Float) {
            double d = ((Number)o).doubleValue();
            if (Double.isNaN(d) || d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
                throw Trace.error(65);
            }
            return ValuePool.getLong((long)d);
        }
        throw Trace.error(95);
    }

    static Double convertToDouble(Object o) throws HsqlException {
        double val;
        if (o instanceof BigDecimal) {
            int signum;
            BigDecimal bd = (BigDecimal)o;
            val = bd.doubleValue();
            BigDecimal bo = new BigDecimal(val + (double)(signum = bd.signum()));
            if (bo.compareTo(bd) != signum) {
                throw Trace.error(65);
            }
        } else {
            val = ((Number)o).doubleValue();
        }
        return ValuePool.getDouble(Double.doubleToLongBits(val));
    }

    static int getCombinedNumberType(int type1, int type2, int expType) {
        int typeWidth1 = Column.getNumTypeWidth(type1);
        int typeWidth2 = Column.getNumTypeWidth(type2);
        if (typeWidth1 == 16 || typeWidth2 == 16) {
            return 8;
        }
        switch (expType) {
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 70: {
                return typeWidth1 > typeWidth2 ? type1 : type2;
            }
        }
        int sum = typeWidth1 + typeWidth2;
        if (sum <= 4) {
            return 4;
        }
        if (sum <= 8) {
            return -5;
        }
        return 2;
    }

    static int getNumTypeWidth(int type) {
        switch (type) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    static int compareToTypeRange(Object o, int targettype) {
        if (!(o instanceof Number)) {
            return 0;
        }
        if (o instanceof Integer || o instanceof Long) {
            int max;
            int min;
            long temp = ((Number)o).longValue();
            switch (targettype) {
                case -6: {
                    min = -128;
                    max = 127;
                    break;
                }
                case 5: {
                    min = Short.MIN_VALUE;
                    max = Short.MAX_VALUE;
                    break;
                }
                case 4: {
                    min = Integer.MIN_VALUE;
                    max = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    return 0;
                }
            }
            if ((long)max < temp) {
                return 1;
            }
            if (temp < (long)min) {
                return -1;
            }
            return 0;
        }
        try {
            o = Column.convertToLong(o);
            return Column.compareToTypeRange(o, targettype);
        }
        catch (HsqlException e) {
            if (e.getErrorCode() == -65) {
                if (o instanceof BigDecimal) {
                    return ((BigDecimal)o).signum();
                }
                if (o instanceof Double) {
                    return (Double)o > 0.0 ? 1 : -1;
                }
            }
            return 0;
        }
    }

    public static byte[] hexToByteArray(String hexString) throws HsqlException {
        try {
            return StringConverter.hexToByte(hexString);
        }
        catch (IOException iOException) {
            throw Trace.error(81);
        }
    }

    static int compareTo(byte[] o1, byte[] o2) {
        int len = o1.length;
        int lenb = o2.length;
        int i = 0;
        while (true) {
            int a = 0;
            int b = 0;
            if (i < len) {
                a = o1[i] & 0xFF;
            } else if (i >= lenb) {
                return 0;
            }
            if (i < lenb) {
                b = o2[i] & 0xFF;
            }
            if (a > b) {
                return 1;
            }
            if (b > a) {
                return -1;
            }
            ++i;
        }
    }
}

