/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Server;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

public class DatabaseManager {
    private static int dbIDCounter;
    static final HashMap memDatabaseMap;
    static final HashMap fileDatabaseMap;
    static final HashMap resDatabaseMap;
    static final IntKeyHashMap databaseIDMap;
    static HashMap serverMap;
    private static final HsqlTimer timer;

    static {
        memDatabaseMap = new HashMap();
        fileDatabaseMap = new HashMap();
        resDatabaseMap = new HashMap();
        databaseIDMap = new IntKeyHashMap();
        serverMap = new HashMap();
        timer = new HsqlTimer();
    }

    public static Vector getDatabaseURIs() {
        Vector<String> v = new Vector<String>();
        Iterator it = databaseIDMap.values().iterator();
        while (it.hasNext()) {
            Database db = (Database)it.next();
            v.addElement(db.getURI());
        }
        return v;
    }

    public static void closeDatabases(int mode) {
        Iterator it = databaseIDMap.values().iterator();
        while (it.hasNext()) {
            Database db = (Database)it.next();
            try {
                db.close(mode);
            }
            catch (HsqlException hsqlException) {}
        }
    }

    static Session newSession(int dbID, String user, String password) throws HsqlException {
        Database db = (Database)databaseIDMap.get(dbID);
        return db == null ? null : db.connect(user, password);
    }

    public static Session newSession(String type, String path, String user, String password, HsqlProperties props) throws HsqlException {
        Database db = DatabaseManager.getDatabase(type, path, props);
        return db == null ? null : db.connect(user, password);
    }

    static Session getSession(int dbId, int sessionId) {
        Database db = (Database)databaseIDMap.get(dbId);
        return db == null ? null : db.sessionManager.getSession(sessionId);
    }

    static int getDatabase(String type, String path, Server server, HsqlProperties props) throws HsqlException {
        Database db = DatabaseManager.getDatabase(type, path, props);
        DatabaseManager.registerServer(server, db);
        return db.databaseID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database getDatabase(String type, String path, HsqlProperties props) throws HsqlException {
        Database db;
        Database database = db = DatabaseManager.getDatabaseObject(type, path, props);
        synchronized (database) {
            switch (db.getState()) {
                case 1: {
                    break;
                }
                case 16: {
                    if (DatabaseManager.lookupDatabaseObject(type, path) == null) {
                        DatabaseManager.addDatabaseObject(type, path, db);
                    }
                    db.open();
                    break;
                }
                case 4: 
                case 8: {
                    throw Trace.error(1, 107);
                }
            }
        }
        return db;
    }

    private static synchronized Database getDatabaseObject(String type, String path, HsqlProperties props) throws HsqlException {
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.getDatabaseObject");
        }
        Database db = (Database)databaseMap.get(key);
        if (db == null) {
            db = new Database(type, path, String.valueOf(type) + key, props);
            db.databaseID = dbIDCounter;
            databaseIDMap.put(dbIDCounter, db);
            ++dbIDCounter;
            databaseMap.put(key, db);
        }
        return db;
    }

    private static synchronized Database lookupDatabaseObject(String type, String path) throws HsqlException {
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
        }
        return (Database)databaseMap.get(key);
    }

    private static synchronized void addDatabaseObject(String type, String path, Database db) throws HsqlException {
        HashMap databaseMap;
        String key = path;
        if (type == "file:") {
            databaseMap = fileDatabaseMap;
            key = DatabaseManager.filePathToKey(path);
        } else if (type == "res:") {
            databaseMap = resDatabaseMap;
        } else if (type == "mem:") {
            databaseMap = memDatabaseMap;
        } else {
            throw Trace.runtimeError(201, "DatabaseManager.addDatabaseObject()");
        }
        databaseIDMap.put(db.databaseID, db);
        databaseMap.put(key, db);
    }

    /*
     * Unable to fully structure code
     */
    static void removeDatabase(Database database) {
        block11: {
            dbID = database.databaseID;
            type = database.getType();
            key = path = database.getPath();
            DatabaseManager.notifyServers(database);
            if (type == "file:") {
                databaseMap = DatabaseManager.fileDatabaseMap;
                try {
                    key = DatabaseManager.filePathToKey(path);
                    break block11;
                }
                catch (HsqlException v0) {
                    it = databaseMap.keySet().iterator();
                    foundKey = null;
                    ** while (it.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    currentKey = it.next();
                    if (databaseMap.get(currentKey) != database) continue;
                    foundKey = currentKey;
                    break;
                }
lbl18:
                // 2 sources

                if (foundKey != null) {
                    key = foundKey;
                }
            } else if (type == "res:") {
                databaseMap = DatabaseManager.resDatabaseMap;
            } else if (type == "mem:") {
                databaseMap = DatabaseManager.memDatabaseMap;
            } else {
                throw Trace.runtimeError(201, "DatabaseManager.lookupDatabaseObject()");
            }
        }
        DatabaseManager.databaseIDMap.remove(dbID);
        databaseMap.remove(key);
        if (DatabaseManager.databaseIDMap.isEmpty()) {
            ValuePool.resetPool();
        }
    }

    static void deRegisterServer(Server server) {
        serverMap.remove(server);
    }

    private static void deRegisterServer(Server server, Database db) {
        Iterator it = serverMap.values().iterator();
        while (it.hasNext()) {
            HashSet databases = (HashSet)it.next();
            databases.remove(db);
            if (!databases.isEmpty()) continue;
            it.remove();
        }
    }

    private static void registerServer(Server server, Database db) {
        if (!serverMap.containsKey(server)) {
            serverMap.put(server, new HashSet());
        }
        HashSet databases = (HashSet)serverMap.get(server);
        databases.add(db);
    }

    private static void notifyServers(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            server.notify(0, db.databaseID);
        }
    }

    static boolean isServerDB(Database db) {
        Iterator it = serverMap.keySet().iterator();
        while (it.hasNext()) {
            Server server = (Server)it.next();
            HashSet databases = (HashSet)serverMap.get(server);
            if (!databases.contains(db)) continue;
            return true;
        }
        return false;
    }

    public static HsqlTimer getTimer() {
        return timer;
    }

    private static String filePathToKey(String path) throws HsqlException {
        try {
            return FileUtil.canonicalPath(path);
        }
        catch (Exception e) {
            throw Trace.error(29, e.toString());
        }
    }
}

