/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HsqlDeque;

public class HsqlTaskQueue {
    protected Thread taskRunnerThread;
    protected static final Runnable SHUTDOWNTASK = new Runnable(){

        public void run() {
        }
    };
    protected volatile boolean isShutdown;
    protected final HsqlDeque queue = new HsqlDeque();
    protected final TaskRunner taskRunner = new TaskRunner();

    public synchronized Thread getTaskRunnerThread() {
        return this.taskRunnerThread;
    }

    protected synchronized void clearThread() {
        this.taskRunnerThread = null;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public synchronized void restart() {
        if (this.taskRunnerThread == null && !this.isShutdown) {
            this.taskRunnerThread = new Thread(this.taskRunner);
            this.taskRunnerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) throws RuntimeException {
        if (!this.isShutdown) {
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.addLast(command);
            }
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownAfterQueued() {
        if (!this.isShutdown) {
            HsqlDeque hsqlDeque = this.queue;
            synchronized (hsqlDeque) {
                this.queue.addLast(SHUTDOWNTASK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownAfterCurrent() {
        this.isShutdown = true;
        HsqlDeque hsqlDeque = this.queue;
        synchronized (hsqlDeque) {
            this.queue.clear();
            this.queue.addLast(SHUTDOWNTASK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownImmediately() {
        this.isShutdown = true;
        if (this.taskRunnerThread != null) {
            this.taskRunnerThread.interrupt();
        }
        HsqlDeque hsqlDeque = this.queue;
        synchronized (hsqlDeque) {
            this.queue.clear();
            this.queue.addLast(SHUTDOWNTASK);
        }
    }

    protected class TaskRunner
    implements Runnable {
        protected TaskRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!HsqlTaskQueue.this.isShutdown) {
                    Runnable task;
                    HsqlDeque hsqlDeque = HsqlTaskQueue.this.queue;
                    synchronized (hsqlDeque) {
                        task = (Runnable)HsqlTaskQueue.this.queue.getFirst();
                    }
                    if (task == SHUTDOWNTASK) {
                        HsqlTaskQueue.this.isShutdown = true;
                        hsqlDeque = HsqlTaskQueue.this.queue;
                        synchronized (hsqlDeque) {
                            HsqlTaskQueue.this.queue.clear();
                            break;
                        }
                    }
                    if (task != null) {
                        task.run();
                        Object var1_1 = null;
                        continue;
                    }
                    break;
                }
            }
            finally {
                HsqlTaskQueue.this.clearThread();
            }
        }
    }
}

