/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class IntKeyIntValueHashMap
extends BaseHashMap {
    private Set keySet;
    private Collection values;

    public IntKeyIntValueHashMap() {
        this(16, 0.75f);
    }

    public IntKeyIntValueHashMap(int initialCapacity) throws IllegalArgumentException {
        this(initialCapacity, 0.75f);
    }

    public IntKeyIntValueHashMap(int initialCapacity, float loadFactor) throws IllegalArgumentException {
        super(initialCapacity, loadFactor, 1, 1, false);
    }

    public int get(int key) throws NoSuchElementException {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        throw new NoSuchElementException();
    }

    public int get(int key, int defaultValue) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.intValueTable[lookup];
        }
        return defaultValue;
    }

    public boolean get(int key, int[] value) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            value[0] = this.intValueTable[lookup];
            return true;
        }
        return false;
    }

    public boolean put(int key, int value) {
        int oldSize = this.size();
        super.addOrRemove(key, value, null, null, false);
        return oldSize != this.size();
    }

    public boolean remove(int key) {
        int oldSize = this.size();
        super.addOrRemove(key, 0L, null, null, true);
        return oldSize != this.size();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        public Iterator iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            intKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, true);
        }

        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        public Object get(Object key) {
            throw new RuntimeException();
        }

        public boolean add(Object value) {
            throw new RuntimeException();
        }

        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            IntKeyIntValueHashMap.this.clear();
        }
    }

    class Values
    implements Collection {
        Values() {
        }

        public Iterator iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            intKeyIntValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, false);
        }

        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        public boolean add(Object value) {
            throw new RuntimeException();
        }

        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public void clear() {
            IntKeyIntValueHashMap.this.clear();
        }
    }
}

