/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.Database;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.persist.ScaledRAInterface;

class ScaledRAFileNIO
implements ScaledRAInterface {
    private final boolean readOnly;
    private final long bufferLength;
    private RandomAccessFile file;
    private MappedByteBuffer buffer;
    private FileChannel channel;
    private boolean bufferModified;
    private SimpleLog appLog;
    private static final String JVM_ERROR = "JVM threw unsupported Exception";

    ScaledRAFileNIO(Database database, String name, boolean readOnly, int bufferLength) throws Throwable {
        block17: {
            long fileLength;
            if (bufferLength < 262144) {
                bufferLength = 262144;
            }
            this.file = new RandomAccessFile(name, readOnly ? "r" : "rw");
            try {
                fileLength = this.file.length();
            }
            catch (Throwable e) {
                this.file.close();
                throw e;
            }
            if (fileLength > 0x10000000L) {
                this.file.close();
                throw new IOException("length exceeds nio limit");
            }
            if ((long)bufferLength < fileLength) {
                bufferLength = (int)fileLength;
            }
            bufferLength = ScaledRAFileNIO.newNIOBufferSize(bufferLength);
            if (readOnly) {
                bufferLength = (int)fileLength;
            }
            if (fileLength < (long)bufferLength) {
                try {
                    this.file.seek(bufferLength - 1);
                    this.file.writeByte(0);
                    this.file.getFD().sync();
                    this.file.close();
                    this.file = new RandomAccessFile(name, readOnly ? "r" : "rw");
                }
                catch (Throwable e) {
                    this.file.close();
                    throw e;
                }
            }
            this.appLog = database.logger.appLog;
            this.readOnly = readOnly;
            this.bufferLength = bufferLength;
            this.channel = this.file.getChannel();
            try {
                this.buffer = this.channel.map(readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, bufferLength);
                Trace.printSystemOut("NIO file instance created. mode: " + readOnly);
                if (readOnly) break block17;
                long tempSize = (long)bufferLength - fileLength;
                if (tempSize > 262144L) {
                    tempSize = 262144L;
                }
                byte[] temp = new byte[(int)tempSize];
                try {
                    long pos = fileLength;
                    while (pos < (long)bufferLength - tempSize) {
                        this.buffer.position((int)pos);
                        this.buffer.put(temp, 0, temp.length);
                        pos += tempSize;
                    }
                    this.buffer.position((int)pos);
                    this.buffer.put(temp, 0, (int)((long)bufferLength - pos));
                    this.buffer.force();
                }
                catch (Throwable t) {
                    this.appLog.logContext(t, "JVM threw unsupported Exception length: " + bufferLength);
                }
                this.buffer.position(0);
            }
            catch (Throwable e) {
                Trace.printSystemOut("NIO constructor failed:  " + bufferLength);
                this.buffer = null;
                this.channel = null;
                this.file.close();
                System.gc();
                throw e;
            }
        }
    }

    public long length() throws IOException {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            this.appLog.logContext(e, "nio");
            throw e;
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public void seek(long newPos) throws IOException {
        try {
            this.buffer.position((int)newPos);
        }
        catch (IllegalArgumentException e) {
            this.appLog.logContext(e, "nio");
            throw new IOException(e.toString());
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public long getFilePointer() throws IOException {
        try {
            return this.buffer.position();
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public int read() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            this.buffer.get(b, offset, length);
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public void write(byte[] b, int offset, int len) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.put(b, offset, len);
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public void writeInt(int i) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putInt(i);
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public void writeLong(long i) throws IOException {
        try {
            this.bufferModified = true;
            this.buffer.putLong(i);
        }
        catch (Throwable e) {
            this.appLog.logContext(e, JVM_ERROR);
            throw new IOException(e.toString());
        }
    }

    public void close() throws IOException {
        try {
            Trace.printSystemOut("NIO close() start - fileLength = " + this.bufferLength);
            if (this.buffer != null && this.bufferModified) {
                try {
                    this.buffer.force();
                }
                catch (Throwable t) {
                    try {
                        this.buffer.force();
                    }
                    catch (Throwable throwable) {
                        this.appLog.logContext(t, "JVM threw unsupported Exception length: " + this.bufferLength);
                    }
                }
            }
            this.buffer = null;
            this.channel = null;
            this.file.close();
            System.gc();
        }
        catch (Throwable e) {
            this.appLog.logContext(e, "length: " + this.bufferLength);
            throw new IOException(e.toString());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return true;
    }

    public boolean canAccess(int length) {
        return (long)(this.buffer.position() + length) <= this.bufferLength;
    }

    public boolean canSeek(long position) {
        return position <= this.bufferLength;
    }

    public Database getDatabase() {
        return null;
    }

    static int newNIOBufferSize(int newSize) {
        int bufSize = 0;
        int scale = 20;
        while (scale < 30) {
            bufSize = 1 << scale;
            if (bufSize >= newSize) break;
            ++scale;
        }
        return bufSize;
    }
}

