/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputText
extends RowOutputBase {
    protected String fieldSep;
    protected String varSep;
    protected String longvarSep;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private String nextSep = "";
    private boolean nextSepEnd;
    protected boolean allQuoted;
    private String encoding;

    public RowOutputText(String fieldSep, String varSep, String longvarSep, boolean allQuoted, String encoding) {
        this.initTextDatabaseRowOutput(fieldSep, varSep, longvarSep, allQuoted, encoding);
    }

    private void initTextDatabaseRowOutput(String fieldSep, String varSep, String longvarSep, boolean allQuoted, String encoding) {
        if (fieldSep.endsWith("\n")) {
            this.fieldSepEnd = true;
            fieldSep = fieldSep.substring(0, fieldSep.length() - 1);
        }
        if (varSep.endsWith("\n")) {
            this.varSepEnd = true;
            varSep = varSep.substring(0, varSep.length() - 1);
        }
        if (longvarSep.endsWith("\n")) {
            this.longvarSepEnd = true;
            longvarSep = longvarSep.substring(0, longvarSep.length() - 1);
        }
        this.fieldSep = fieldSep;
        this.varSep = varSep;
        this.longvarSep = longvarSep;
        this.allQuoted = allQuoted;
        this.encoding = encoding;
    }

    public void writeEnd() {
        if (this.nextSepEnd) {
            this.writeBytes(this.nextSep);
        }
        this.writeBytes(TextCache.NL);
    }

    public void writeSize(int size) {
        this.nextSep = "";
        this.nextSepEnd = false;
    }

    public void writeType(int type) {
    }

    public void writeString(String s) {
        if ((s = this.checkConvertString(s, this.fieldSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    protected void writeVarString(String s) {
        if ((s = this.checkConvertString(s, this.varSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.varSep;
        this.nextSepEnd = this.varSepEnd;
    }

    protected void writeLongVarString(String s) {
        if ((s = this.checkConvertString(s, this.longvarSep)) == null) {
            return;
        }
        byte[] bytes = this.getBytes(s);
        this.write(bytes, 0, bytes.length);
        this.nextSep = this.longvarSep;
        this.nextSepEnd = this.longvarSepEnd;
    }

    protected String checkConvertString(String s, String sep) {
        if (s.indexOf(10) != -1 || s.indexOf(13) != -1) {
            throw new IllegalArgumentException(Trace.getMessage(145));
        }
        if (s.indexOf(sep) != -1) {
            return null;
        }
        return s;
    }

    private byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = s.getBytes();
        }
        return bytes;
    }

    protected void writeByteArray(byte[] b) {
        this.ensureRoom(b.length * 2);
        StringConverter.writeHex(this.getBuffer(), this.count, b);
        this.count += b.length * 2;
    }

    public void writeShortData(short i) {
        this.writeIntData(i);
    }

    public void writeIntData(int i) {
        this.writeBytes(Integer.toString(i));
        this.nextSep = this.fieldSep;
        this.nextSepEnd = this.fieldSepEnd;
    }

    public void writeIntData(int i, int position) {
        throw Trace.runtimeError(201, "RowInputText");
    }

    public void writeLongData(long i) {
        throw Trace.runtimeError(201, "RowInputText");
    }

    protected void writeFieldType(int type) {
        this.writeBytes(this.nextSep);
        switch (type) {
            case 12: 
            case 100: {
                this.nextSep = this.varSep;
                this.nextSepEnd = this.varSepEnd;
                break;
            }
            case -1: {
                this.nextSep = this.longvarSep;
                this.nextSepEnd = this.longvarSepEnd;
                break;
            }
            default: {
                this.nextSep = this.fieldSep;
                this.nextSepEnd = this.fieldSepEnd;
            }
        }
    }

    protected void writeNull(int type) {
        this.writeFieldType(type);
    }

    protected void writeChar(String s, int t) {
        switch (t) {
            case 1: {
                this.writeString(s);
                return;
            }
            case 12: 
            case 100: {
                this.writeVarString(s);
                return;
            }
        }
        this.writeLongVarString(s);
    }

    protected void writeSmallint(Number o) {
        this.writeString(o.toString());
    }

    protected void writeInteger(Number o) {
        this.writeString(o.toString());
    }

    protected void writeBigint(Number o) {
        this.writeString(o.toString());
    }

    protected void writeReal(Double o, int type) {
        this.writeString(o.toString());
    }

    protected void writeDecimal(BigDecimal o) {
        this.writeString(o.toString());
    }

    protected void writeBit(Boolean o) {
        this.writeString(o.toString());
    }

    protected void writeDate(Date o) {
        this.writeString(o.toString());
    }

    protected void writeTime(Time o) {
        this.writeString(o.toString());
    }

    protected void writeTimestamp(Timestamp o) {
        this.writeString(o.toString());
    }

    protected void writeOther(JavaObject o) {
        byte[] ba = o.getBytes();
        this.writeByteArray(ba);
    }

    protected void writeBinary(Binary o, int t) {
        this.writeByteArray(o.getBytes());
    }

    public int getSize(CachedRow r) {
        this.reset();
        try {
            this.writeSize(0);
            this.writeData(r.getData(), r.getTable());
            this.writeEnd();
        }
        catch (Exception exception) {
            this.reset();
        }
        int rowsize = this.size();
        this.reset();
        return rowsize;
    }
}

