/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialogCommon {
    private static String[][] connTypes;
    private static final String[][] sJDBCTypes;
    private static final String fileName = "hsqlprefs.dat";
    private static File recentSettings;
    static String emptySettingName;
    private static String homedir;

    static {
        sJDBCTypes = new String[][]{{"HSQL Database Engine In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:."}, {"HSQL Database Engine Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:file:\u00abdatabase/path?\u00bb"}, {"HSQL Database Engine Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost/"}, {"HSQL Database Engine WebServer", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://\u00abhostname/?\u00bb"}, {"JDBC-ODBC Bridge from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:\u00abdatabase?\u00bb"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://\u00abhost?\u00bb:1099/jdbc:cloudscape:\u00abdatabase?\u00bb;create=true"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:\u00abdatabase?\u00bb"}, {"IBM DB2 (thin)", "COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2://\u00abhost?\u00bb:6789/\u00abdatabase?\u00bb"}, {"Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://\u00abhost?\u00bb:1533/\u00abdatabase?\u00bb:INFORMIXSERVER=\u00abserver?\u00bb"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:\u00abdatabase?\u00bb.prp"}, {"MySQL Connector/J", "com.mysql.jdbc.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"MM.MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@\u00abdatabase?\u00bb"}, {"Oracle (thin)", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@\u00abhost?\u00bb:1521:\u00abdatabase?\u00bb"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL v6.5", "postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}};
        recentSettings = null;
        emptySettingName = "Recent settings...";
        homedir = null;
    }

    ConnectionDialogCommon() {
    }

    static String[][] getTypes() {
        return sJDBCTypes;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Hashtable loadRecentConnectionSettings() throws IOException {
        Hashtable<String, ConnectionSetting> list = new Hashtable<String, ConnectionSetting>();
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return list;
                }
                recentSettings = new File(homedir, fileName);
                if (!recentSettings.exists()) {
                    JavaSystem.createNewFile(recentSettings);
                    return list;
                }
            }
        }
        catch (Throwable throwable) {
            return list;
        }
        FileInputStream in = null;
        ObjectInputStream objStream = null;
        try {
            in = new FileInputStream(recentSettings);
            objStream = new ObjectInputStream(in);
            list.clear();
            while (true) {
                ConnectionSetting setting;
                if (emptySettingName.equals((setting = (ConnectionSetting)objStream.readObject()).getName())) {
                    continue;
                }
                list.put(setting.getName(), setting);
            }
        }
        catch (EOFException eOFException) {
            if (objStream != null) {
                objStream.close();
            }
            if (in == null) return list;
            in.close();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Unrecognized class type " + cnfe.getMessage());
            catch (ClassCastException cce) {
                throw new IOException("Unrecognized class type " + cce.getMessage());
            }
        }
        finally {
            return list;
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    static void addToRecentConnectionSettings(Hashtable settings, ConnectionSetting newSetting) throws IOException {
        settings.put(newSetting.getName(), newSetting);
        ConnectionDialogCommon.storeRecentConnectionSettings(settings);
    }

    private static void storeRecentConnectionSettings(Hashtable settings) {
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return;
                }
                recentSettings = new File(homedir, fileName);
                recentSettings.exists();
            }
            if (settings == null || settings.size() == 0) {
                return;
            }
            FileOutputStream out = new FileOutputStream(recentSettings);
            ObjectOutputStream objStream = new ObjectOutputStream(out);
            Enumeration en = settings.elements();
            while (en.hasMoreElements()) {
                objStream.writeObject(en.nextElement());
            }
            objStream.flush();
            objStream.close();
            out.close();
        }
        catch (Throwable throwable) {}
    }

    static void deleteRecentConnectionSettings() {
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return;
                }
                recentSettings = new File(homedir, fileName);
            }
            if (!recentSettings.exists()) {
                recentSettings = null;
                return;
            }
            recentSettings.delete();
            recentSettings = null;
        }
        catch (Throwable throwable) {}
    }

    public static void setHomeDir() {
        if (homedir == null) {
            try {
                Class<?> c = Class.forName("sun.security.action.GetPropertyAction");
                Constructor<?> constructor = c.getConstructor(String.class);
                PrivilegedAction a = (PrivilegedAction)constructor.newInstance("user.home");
                homedir = (String)AccessController.doPrivileged(a);
            }
            catch (Exception exception) {
                System.err.println("No access to home directory.  Continuing without...");
            }
        }
    }
}

