/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class DiskNode
extends Node {
    protected Row rData;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    static final int SIZE_IN_BYTE = 16;

    DiskNode(CachedRow r, RowInputInterface in, int id) throws IOException, HsqlException {
        this.iId = id;
        this.rData = r;
        this.iBalance = in.readIntData();
        this.iLeft = in.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = in.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = in.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    DiskNode(CachedRow r, int id) {
        this.iId = id;
        this.rData = r;
    }

    void delete() {
        this.rData = null;
        this.iBalance = -2;
    }

    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return -1;
    }

    Row getRow() throws HsqlException {
        return this.rData;
    }

    private Node findNode(int pos) throws HsqlException {
        Node ret = null;
        CachedRow r = ((CachedRow)this.rData).getTable().getRow(pos);
        if (r != null) {
            ret = r.getNode(this.iId);
        }
        return ret;
    }

    boolean isLeft(Node node) throws HsqlException {
        if (node == null) {
            return this.iLeft == -1;
        }
        return this.iLeft == ((DiskNode)node).getKey();
    }

    boolean isRight(Node node) throws HsqlException {
        if (node == null) {
            return this.iRight == -1;
        }
        return this.iRight == ((DiskNode)node).getKey();
    }

    Node getLeft() throws HsqlException {
        if (this.iLeft == -1) {
            return null;
        }
        return this.findNode(this.iLeft);
    }

    Node getRight() throws HsqlException {
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight);
    }

    Node getParent() throws HsqlException {
        if (this.iParent == -1) {
            return null;
        }
        return this.findNode(this.iParent);
    }

    boolean isRoot() {
        return this.iParent == -1;
    }

    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        DiskNode parent = (DiskNode)this.getParent();
        return this.getKey() == parent.iLeft;
    }

    Object[] getData() throws HsqlException {
        return this.rData.getData();
    }

    void setParent(Node n) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iParent = n == null ? -1 : n.getKey();
    }

    void setBalance(int b) throws HsqlException {
        if (this.iBalance != b) {
            ((CachedRow)this.rData).setChanged();
            this.iBalance = b;
        }
    }

    void setLeft(Node n) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iLeft = n == null ? -1 : n.getKey();
    }

    void setRight(Node n) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iRight = n == null ? -1 : n.getKey();
    }

    boolean equals(Node n) {
        return this == n || n != null && this.getKey() == ((DiskNode)n).getKey();
    }

    void write(RowOutputInterface out) throws IOException {
        out.writeIntData(this.iBalance);
        out.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        out.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        out.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }

    Node getUpdatedNode() throws HsqlException {
        Row row = this.rData.getUpdatedRow();
        return row == null ? null : row.getNode(this.iId);
    }

    void writeTranslate(RowOutputInterface out, IntLookup lookup) {
        out.writeIntData(this.iBalance);
        this.writeTranslatePointer(this.iLeft, out, lookup);
        this.writeTranslatePointer(this.iRight, out, lookup);
        this.writeTranslatePointer(this.iParent, out, lookup);
    }

    private void writeTranslatePointer(int pointer, RowOutputInterface out, IntLookup lookup) {
        int newPointer = 0;
        if (pointer != -1) {
            newPointer = lookup.lookupFirstEqual(pointer);
        }
        out.writeIntData(newPointer);
    }
}

