/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingLen;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    boolean sortUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType;
    Select[] unionArray;
    int unionMaxDepth;
    Select unionSelect;
    int unionType;
    int unionDepth;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private boolean simpleLimit;
    Result.ResultMetaData resultMetaData;
    IntKeyHashMap asteriskPositions;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap aliasMap = new HashMap();
        int i = 0;
        while (i < this.iResultLen) {
            String alias = this.exprColumns[i].getAlias();
            if (alias != null) {
                aliasMap.put(alias, this.exprColumns[i]);
            }
            ++i;
        }
        return aliasMap;
    }

    void resolve(Session session) throws HsqlException {
        this.resolveTables();
        this.resolveTypes(session);
        this.setFilterConditions(session);
    }

    private void resolveTables() throws HsqlException {
        int i = this.iResultLen;
        while (i < this.exprColumns.length) {
            if (this.exprColumns[i].getType() == 2) {
                if (this.exprColumns[i].joinedTableColumnIndex == -1) {
                    boolean descending = this.exprColumns[i].isDescending();
                    this.exprColumns[i] = this.exprColumns[i].getExpressionForAlias(this.exprColumns, this.iResultLen);
                    if (descending) {
                        this.exprColumns[i].setDescending();
                    }
                }
            } else {
                this.exprColumns[i].replaceAliases(this.exprColumns, this.iResultLen);
            }
            ++i;
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceAliases(this.exprColumns, this.iResultLen);
        }
        int len = this.tFilter.length;
        int i2 = 0;
        while (i2 < len) {
            this.resolveTables(this.tFilter[i2]);
            ++i2;
        }
    }

    void resolveUnionColumnTypes() throws HsqlException {
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            int i = 0;
            while (i < this.iResultLen) {
                Expression e = this.exprColumns[i];
                if (!e.isTypeEqual(this.unionSelect.exprColumns[i])) {
                    this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], e.getDataType(), e.getColumnSize(), e.getColumnScale());
                }
                ++i;
            }
        }
    }

    void resolveTypes(Session session) throws HsqlException {
        int len = this.exprColumns.length;
        int i = 0;
        while (i < len) {
            this.exprColumns[i].resolveTypes(session);
            ++i;
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session);
        }
    }

    void resolveTablesUnion(TableFilter f) throws HsqlException {
        if (this.unionArray == null) {
            this.resolveTables(f);
        } else {
            int i = 0;
            while (i < this.unionArray.length) {
                this.unionArray[i].resolveTables(f);
                ++i;
            }
        }
    }

    void resolveTables(TableFilter f) throws HsqlException {
        int len = this.exprColumns.length;
        int i = 0;
        while (i < len) {
            this.exprColumns[i].resolveTables(f);
            ++i;
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(f);
        }
    }

    private void setFilterConditions(Session session) throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        int i = 0;
        while (i < this.tFilter.length) {
            this.tFilter[i].setConditions(session, this.queryCondition);
            ++i;
        }
    }

    boolean checkResolved(boolean check) throws HsqlException {
        boolean result = true;
        int len = this.exprColumns.length;
        int i = 0;
        while (i < len) {
            result = result && this.exprColumns[i].checkResolved(check);
            ++i;
        }
        if (this.queryCondition != null) {
            boolean bl = result = result && this.queryCondition.checkResolved(check);
        }
        if (this.havingCondition != null) {
            result = result && this.havingCondition.checkResolved(check);
        }
        i = 0;
        while (i < this.tFilter.length) {
            if (this.tFilter[i].filterIndex == null) {
                this.tFilter[i].filterIndex = this.tFilter[i].filterTable.getPrimaryIndex();
            }
            ++i;
        }
        return result;
    }

    Object getValue(Session session, int type) throws HsqlException {
        this.resolve(session);
        Result r = this.getResult(session, 2);
        int size = r.getSize();
        int len = r.getColumnCount();
        if (len == 1) {
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                Object o = r.rRoot.data[0];
                return r.metaData.colTypes[0] == type ? o : Column.convertObject(o, type);
            }
            throw Trace.error(17);
        }
        HsqlException e = Trace.error(17);
        throw new HsqlInternalException(e);
    }

    void prepareResult(Session session) throws HsqlException {
        this.resolveAll(session, true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            int i = this.iResultLen;
            while (i < this.iResultLen + this.iGroupLen) {
                this.exprColumns[i].collectAllColumnNames(this.groupColumnNames);
                ++i;
            }
        }
        int len = this.exprColumns.length;
        Result.ResultMetaData rmd = this.resultMetaData = new Result.ResultMetaData(len);
        int groupByStart = this.iResultLen;
        int groupByEnd = groupByStart + this.iGroupLen;
        int orderByStart = groupByEnd + this.iHavingLen;
        int orderByEnd = orderByStart + this.iOrderLen;
        int i = 0;
        while (i < len) {
            Expression e = this.exprColumns[i];
            rmd.colTypes[i] = e.getDataType();
            rmd.colSizes[i] = e.getColumnSize();
            rmd.colScales[i] = e.getColumnScale();
            if (e.isAggregate()) {
                this.isAggregated = true;
            }
            if (i >= groupByStart && i < groupByEnd && !this.exprColumns[i].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[i]);
            }
            if (i >= groupByEnd && i < groupByEnd + this.iHavingLen && !this.exprColumns[i].isConditional()) {
                Trace.error(69, this.exprColumns[i]);
            }
            if (i >= orderByStart && i < orderByEnd && !this.exprColumns[i].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[i]);
            }
            if (i < this.iResultLen) {
                rmd.colLabels[i] = e.getAlias();
                rmd.isLabelQuoted[i] = e.isAliasQuoted();
                rmd.schemaNames[i] = e.getTableSchemaName();
                rmd.tableNames[i] = e.getTableName();
                rmd.colNames[i] = e.getColumnName();
                if (rmd.isTableColumn(i)) {
                    rmd.colNullable[i] = e.nullability;
                    rmd.isIdentity[i] = e.isIdentity;
                    rmd.isWritable[i] = e.isWritable;
                }
                rmd.classNames[i] = e.getValueClassName();
            }
            ++i;
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        this.checkAggregateOrGroupByColumns(groupByEnd, orderByStart);
        this.checkAggregateOrGroupByOrderColumns(orderByStart, orderByEnd);
        this.prepareSort();
        this.simpleLimit = !this.isDistinctSelect && !this.isGrouped && this.unionSelect == null && this.iOrderLen == 0;
    }

    void prepareUnions() throws HsqlException {
        int count = 0;
        Select current = this;
        while (current != null) {
            current = current.unionSelect;
            ++count;
        }
        if (count == 1) {
            if (this.unionDepth != 0) {
                throw Trace.error(121);
            }
            return;
        }
        this.unionArray = new Select[count];
        count = 0;
        current = this;
        while (current != null) {
            this.unionArray[count] = current;
            this.unionMaxDepth = current.unionDepth > this.unionMaxDepth ? current.unionDepth : this.unionMaxDepth;
            current = current.unionSelect;
            ++count;
        }
        if (this.unionArray[this.unionArray.length - 1].unionDepth != 0) {
            throw Trace.error(121);
        }
    }

    Result getResult(Session session, int maxrows) throws HsqlException {
        Result r;
        if (this.unionArray == null) {
            r = this.getSingleResult(session, maxrows);
        } else {
            r = this.getResultMain(session);
            if (this.sortUnion) {
                this.sortResult(session, r);
                r.trimResult(this.getLimitStart(session), this.getLimitCount(session, maxrows));
            }
        }
        r.setColumnCount(this.iResultLen);
        return r;
    }

    private Result getResultMain(Session session) throws HsqlException {
        Result[] unionResults = new Result[this.unionArray.length];
        int i = 0;
        while (i < this.unionArray.length) {
            unionResults[i] = this.unionArray[i].getSingleResult(session, Integer.MAX_VALUE);
            ++i;
        }
        int depth = this.unionMaxDepth;
        while (depth >= 0) {
            int pass = 0;
            while (pass < 2) {
                int i2 = 0;
                while (i2 < this.unionArray.length - 1) {
                    if (!(unionResults[i2] == null || this.unionArray[i2].unionDepth < depth || pass == 0 && this.unionArray[i2].unionType != 3 || pass == 1 && this.unionArray[i2].unionType == 3)) {
                        int nextIndex = i2 + 1;
                        while (nextIndex < this.unionArray.length) {
                            if (unionResults[nextIndex] != null) break;
                            ++nextIndex;
                        }
                        if (nextIndex == this.unionArray.length) break;
                        this.unionArray[i2].mergeResults(session, unionResults[i2], unionResults[nextIndex]);
                        unionResults[nextIndex] = unionResults[i2];
                        unionResults[i2] = null;
                    }
                    ++i2;
                }
                ++pass;
            }
            --depth;
        }
        return unionResults[unionResults.length - 1];
    }

    private void mergeResults(Session session, Result first, Result second) throws HsqlException {
        switch (this.unionType) {
            case 1: {
                first.append(second);
                first.removeDuplicates(session, this.iResultLen);
                break;
            }
            case 2: {
                first.append(second);
                break;
            }
            case 3: {
                first.removeDifferent(session, second, this.iResultLen);
                break;
            }
            case 4: {
                first.removeSecond(session, second, this.iResultLen);
            }
        }
    }

    int getLimitStart(Session session) throws HsqlException {
        Integer limit;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getArg().getValue(session)) != null) {
            return limit;
        }
        return 0;
    }

    int getLimitCount(Session session, int rowCount) throws HsqlException {
        Integer limit;
        int limitCount = 0;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getArg2().getValue(session)) != null) {
            limitCount = limit;
        }
        if (rowCount != 0 && (limitCount == 0 || rowCount < limitCount)) {
            limitCount = rowCount;
        }
        return limitCount;
    }

    int getMaxRowCount(Session session, int rowCount) throws HsqlException {
        int limitStart = this.getLimitStart(session);
        int limitCount = this.getLimitCount(session, rowCount);
        if (!this.simpleLimit) {
            rowCount = Integer.MAX_VALUE;
        } else {
            if (rowCount == 0) {
                rowCount = limitCount;
            }
            rowCount = rowCount == 0 || rowCount > Integer.MAX_VALUE - limitStart ? Integer.MAX_VALUE : (rowCount += limitStart);
        }
        return rowCount;
    }

    private Result getSingleResult(Session session, int rowCount) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult(session);
        }
        Result r = this.buildResult(session, this.getMaxRowCount(session, rowCount));
        if (this.isDistinctSelect) {
            r.removeDuplicates(session, this.iResultLen);
        }
        if (!this.sortUnion) {
            this.sortResult(session, r);
            r.trimResult(this.getLimitStart(session), this.getLimitCount(session, rowCount));
        }
        return r;
    }

    private void prepareSort() {
        int startCol;
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int i = startCol = this.iResultLen + this.iGroupLen + this.iHavingLen;
        int j = 0;
        while (j < this.iOrderLen) {
            int colindex = i;
            if (this.exprColumns[i].joinedTableColumnIndex != -1) {
                colindex = this.exprColumns[i].joinedTableColumnIndex;
            }
            this.sortOrder[j] = colindex;
            this.sortDirection[j] = this.exprColumns[i].isDescending() ? -1 : 1;
            ++i;
            ++j;
        }
    }

    private void sortResult(Session session, Result r) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        r.sortResult(session, this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int start, int end) throws HsqlException {
        if (start < end) {
            HsqlArrayList colExps = new HsqlArrayList();
            int i = start;
            while (i < end) {
                this.exprColumns[i].collectInGroupByExpressions(colExps);
                ++i;
            }
            i = 0;
            int size = colExps.size();
            while (i < size) {
                Expression exp = (Expression)colExps.get(i);
                if (!this.inAggregateOrGroupByClause(exp)) {
                    throw Trace.error(67, exp);
                }
                ++i;
            }
        }
    }

    private void checkAggregateOrGroupByOrderColumns(int start, int end) throws HsqlException {
        this.checkAggregateOrGroupByColumns(start, end);
        if (start < end && this.isDistinctSelect) {
            HsqlArrayList colExps = new HsqlArrayList();
            int i = start;
            while (i < end) {
                this.exprColumns[i].collectInGroupByExpressions(colExps);
                ++i;
            }
            i = 0;
            int size = colExps.size();
            while (i < size) {
                Expression exp = (Expression)colExps.get(i);
                if (!this.isSimilarIn(exp, 0, this.iResultLen)) {
                    throw Trace.error(71, exp);
                }
                ++i;
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression exp) {
        if (this.isGrouped) {
            return this.isSimilarIn(exp, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(exp, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return exp.canBeInAggregate();
        }
        return true;
    }

    private boolean isSimilarIn(Expression exp, int start, int end) {
        int i = start;
        while (i < end) {
            if (exp.similarTo(this.exprColumns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression exp, HashSet definedColumns) {
        HashSet colNames = new HashSet();
        exp.collectAllColumnNames(colNames);
        if (colNames.size() > 0 && definedColumns == null) {
            return false;
        }
        Iterator i = colNames.iterator();
        while (i.hasNext()) {
            if (definedColumns.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Result buildResult(Session session, int limitcount) throws HsqlException {
        gResult = new GroupedResult(this, this.resultMetaData);
        len = this.exprColumns.length;
        filter = this.tFilter.length;
        first = new boolean[filter];
        outerused = new boolean[filter];
        level = 0;
        notempty = this.queryCondition == null || this.queryCondition.isFixedConditional() == false || this.queryCondition.testCondition(session) != false;
        while (notempty && level >= 0) {
            t = this.tFilter[level];
            if (!first[level]) {
                found = t.findFirst(session);
                outerfound = t.isOuterJoin != false && found == false && outerused[level] == false && t.nonJoinIsNull == false && t.nextOuter(session) != false;
                outerused[level] = outerfound;
                first[level] = found;
            } else {
                found = t.next(session);
                outerfound = t.isOuterJoin != false && found == false && first[level] == false && outerused[level] == false && t.nonJoinIsNull == false && t.nextOuter(session) != false;
                outerused[level] = outerfound;
                first[level] = found;
            }
            if (!found && !outerfound) {
                --level;
                continue;
            }
            if (level >= filter - 1) ** GOTO lbl27
            ++level;
            continue;
lbl-1000:
            // 1 sources

            {
                outerused[level--] = false;
lbl27:
                // 2 sources

                ** while (outerused[level])
            }
lbl28:
            // 1 sources

            if (this.queryCondition != null && !this.queryCondition.testCondition(session)) continue;
            try {
                row = new Object[len];
                i = gResult.groupBegin;
                while (i < gResult.groupEnd) {
                    row[i] = this.exprColumns[i].getValue(session);
                    ++i;
                }
                row = gResult.getRow(row);
                i = 0;
                while (i < gResult.groupBegin) {
                    row[i] = this.isAggregated != false && this.exprColumns[i].isAggregate() != false ? this.exprColumns[i].updateAggregatingValue(session, row[i]) : this.exprColumns[i].getValue(session);
                    ++i;
                }
                i = gResult.groupEnd;
                while (i < len) {
                    row[i] = this.isAggregated != false && this.exprColumns[i].isAggregate() != false ? this.exprColumns[i].updateAggregatingValue(session, row[i]) : this.exprColumns[i].getValue(session);
                    ++i;
                }
                gResult.addRow(row);
                if (gResult.size() < limitcount) continue;
                break;
            }
            catch (HsqlInternalException v0) {}
        }
        if (this.isAggregated && !this.isGrouped && gResult.size() == 0) {
            row = new Object[len];
            i = 0;
            while (i < len) {
                row[i] = this.exprColumns[i].isAggregate() != false ? null : this.exprColumns[i].getValue(session);
                ++i;
            }
            gResult.addRow(row);
        }
        it = gResult.iterator();
        while (it.hasNext()) {
            row = (Object[])it.next();
            if (this.isAggregated) {
                i = 0;
                while (i < len) {
                    if (this.exprColumns[i].isAggregate()) {
                        row[i] = this.exprColumns[i].getAggregatedValue(session, row[i]);
                    }
                    ++i;
                }
            }
            if (this.iHavingLen <= 0 || Boolean.TRUE.equals(row[this.iResultLen + this.iGroupLen])) continue;
            it.remove();
        }
        return gResult.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT").append(' ');
        int i = 0;
        while (i < this.iResultLen) {
            sb.append(this.exprColumns[i].getDDL());
            if (i < this.iResultLen - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append("FROM");
        i = 0;
        while (i < this.tFilter.length) {
            TableFilter filter = this.tFilter[i];
            if (i != 0 && filter.isOuterJoin) {
                sb.append("FROM").append(' ');
                sb.append("JOIN").append(' ');
            }
            sb.append(',');
            ++i;
        }
        sb.append(' ').append("WHERE").append(' ');
        i = 0;
        while (i < this.tFilter.length) {
            TableFilter cfr_ignored_0 = this.tFilter[i];
            ++i;
        }
        sb.append(' ').append("GROUP").append(' ');
        i = this.iResultLen;
        while (i < this.iResultLen + this.iGroupLen) {
            sb.append(this.exprColumns[i].getDDL());
            if (i < this.iResultLen + this.iGroupLen - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append(' ').append("HAVING").append(' ');
        i = this.iResultLen + this.iGroupLen;
        while (i < this.iResultLen + this.iGroupLen + this.iHavingLen) {
            sb.append(this.exprColumns[i].getDDL());
            if (i < this.iResultLen + this.iGroupLen - 1) {
                sb.append(',');
            }
            ++i;
        }
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    sb.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    sb.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    sb.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    sb.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        int groupByEnd = this.iResultLen + this.iGroupLen;
        int orderByStart = groupByEnd + this.iHavingLen;
        int orderByEnd = orderByStart + this.iOrderLen;
        sb.append(' ').append("ORDER").append("BY").append(' ');
        int i2 = orderByStart;
        while (i2 < orderByEnd) {
            sb.append(this.exprColumns[i2].getDDL());
            if (i2 < this.iResultLen + this.iGroupLen - 1) {
                sb.append(',');
            }
            ++i2;
        }
        return sb;
    }

    boolean resolveAll(Session session, boolean check) throws HsqlException {
        if (this.isResolved) {
            return true;
        }
        this.resolve(session);
        this.isResolved = this.checkResolved(check);
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            int i = 0;
            while (i < this.iResultLen) {
                Expression e = this.exprColumns[i];
                if (!e.isTypeEqual(this.unionSelect.exprColumns[i])) {
                    this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], e.getDataType(), e.getColumnSize(), e.getColumnScale());
                }
                ++i;
            }
            this.isResolved &= this.unionSelect.resolveAll(session, check);
        }
        return this.isResolved;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String describe(Session session) {
        try {
            this.getResult(session, 1);
        }
        catch (HsqlException hsqlException) {}
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            sb.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            sb.append("offset=[").append(this.limitCondition.getArg().describe(session)).append("]\n");
            sb.append("limit=[").append(this.limitCondition.getArg2().describe(session)).append("]\n");
        }
        sb.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        sb.append("isGrouped=[").append(this.isGrouped).append("]\n");
        sb.append("isAggregated=[").append(this.isAggregated).append("]\n");
        sb.append("columns=[");
        int columns = this.exprColumns.length - this.iOrderLen;
        int i = 0;
        while (i < columns) {
            sb.append(this.exprColumns[i].describe(session));
            ++i;
        }
        sb.append("\n]\n");
        sb.append("tableFilters=[\n");
        i = 0;
        while (i < this.tFilter.length) {
            sb.append("[\n");
            sb.append(this.tFilter[i].describe(session));
            sb.append("\n]");
            ++i;
        }
        sb.append("]\n");
        String temp = this.queryCondition == null ? "null" : this.queryCondition.describe(session);
        sb.append("eCondition=[").append(temp).append("]\n");
        temp = this.havingCondition == null ? "null" : this.havingCondition.describe(session);
        sb.append("havingCondition=[").append(temp).append("]\n");
        sb.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    sb.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    sb.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    sb.append(" UNION ");
                    break;
                }
                case 2: {
                    sb.append(" UNION ALL ");
                    break;
                }
                default: {
                    sb.append(" UNKNOWN SET OPERATION ");
                }
            }
            sb.append("[\n").append(this.unionSelect.describe(session)).append("]\n");
        }
        return sb.toString();
    }

    Result describeResult() {
        Result r = new Result(3, this.iResultLen);
        Result.ResultMetaData rmd = r.metaData;
        int i = 0;
        while (i < this.iResultLen) {
            Expression e = this.exprColumns[i];
            rmd.colTypes[i] = e.getDataType();
            rmd.colSizes[i] = e.getColumnSize();
            rmd.colScales[i] = e.getColumnScale();
            rmd.colLabels[i] = e.getAlias();
            rmd.isLabelQuoted[i] = e.isAliasQuoted();
            rmd.tableNames[i] = e.getTableName();
            rmd.colNames[i] = e.getColumnName();
            if (rmd.isTableColumn(i)) {
                rmd.colNullable[i] = e.nullability;
                rmd.isIdentity[i] = e.isIdentity;
                rmd.isWritable[i] = e.isWritable;
            }
            ++i;
        }
        return r;
    }
}

