/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database db, DataFileCache cache, String filename) {
        this.database = db;
        this.cache = cache;
        this.scale = cache.cacheFileScale;
        this.filename = filename;
    }

    void process() throws HsqlException, IOException {
        boolean complete = false;
        Trace.printSystemOut("Defrag Transfer begins");
        this.transactionRowLookup = this.database.txManager.getTransactionIDList();
        HsqlArrayList allTables = this.database.schemaManager.getAllTables();
        this.rootsList = new int[allTables.size()][];
        Storage dest = null;
        try {
            try {
                OutputStream fos = this.database.getFileAccess().openOutputStreamElement(String.valueOf(this.filename) + ".new");
                this.fileStreamOut = new BufferedOutputStream(fos, 4096);
                int i = 0;
                while (i < 32) {
                    this.fileStreamOut.write(0);
                    ++i;
                }
                this.fileOffset = 32L;
                i = 0;
                int tSize = allTables.size();
                while (i < tSize) {
                    Table t = (Table)allTables.get(i);
                    if (t.getTableType() == 4) {
                        int[] rootsArray = this.writeTableToDataFile(t);
                        this.rootsList[i] = rootsArray;
                    } else {
                        this.rootsList[i] = null;
                    }
                    Trace.printSystemOut(String.valueOf(t.getName().name) + " complete");
                    ++i;
                }
                this.writeTransactionRows();
                this.fileStreamOut.close();
                this.fileStreamOut = null;
                dest = ScaledRAFile.newScaledRAFile(this.database, String.valueOf(this.filename) + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
                dest.seek(12L);
                dest.writeLong(this.fileOffset);
                dest.close();
                dest = null;
                i = 0;
                int size = this.rootsList.length;
                while (i < size) {
                    int[] roots = this.rootsList[i];
                    if (roots != null) {
                        Trace.printSystemOut(StringUtil.getList(roots, ",", ""));
                    }
                    ++i;
                }
                complete = true;
            }
            catch (IOException iOException) {
                throw Trace.error(29, String.valueOf(this.filename) + ".new");
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw Trace.error(72);
            }
        }
        finally {
            if (this.fileStreamOut != null) {
                this.fileStreamOut.close();
            }
            if (dest != null) {
                dest.close();
            }
            if (!complete) {
                this.database.getFileAccess().removeElement(String.valueOf(this.filename) + ".new");
            }
        }
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList allTables = this.database.schemaManager.getAllTables();
        int i = 0;
        int size = allTables.size();
        while (i < size) {
            Table t = (Table)allTables.get(i);
            if (t.getTableType() == 4) {
                int[] rootsArray = this.rootsList[i];
                t.setIndexRoots(rootsArray);
            }
            ++i;
        }
    }

    void updateTransactionRowIDs() throws HsqlException {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        RowOutputBinary rowOut = new RowOutputBinary();
        DoubleIntIndex pointerLookup = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] rootsArray = table.getIndexRootsArray();
        long pos = this.fileOffset;
        int count = 0;
        pointerLookup.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator it = table.rowIterator(session);
        while (it.hasNext()) {
            row = it.next();
            pointerLookup.addUnsorted(row.getPos(), (int)(pos / (long)this.scale));
            if (count % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + count + " " + row.getPos() + " " + pos);
            }
            pos += (long)row.getStorageSize();
            ++count;
        }
        Trace.printSystemOut(String.valueOf(table.getName().name) + " list done ", this.stopw.elapsedTime());
        count = 0;
        it = table.rowIterator(session);
        while (it.hasNext()) {
            row = it.next();
            rowOut.reset();
            row.write(rowOut, pointerLookup);
            this.fileStreamOut.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.size());
            this.fileOffset += (long)row.getStorageSize();
            if (count % 50000 == 0) {
                Trace.printSystemOut(String.valueOf(count) + " rows " + this.stopw.elapsedTime());
            }
            ++count;
        }
        int i = 0;
        while (i < rootsArray.length) {
            if (rootsArray[i] != -1) {
                int lookupIndex = pointerLookup.findFirstEqualKeyIndex(rootsArray[i]);
                if (lookupIndex == -1) {
                    throw Trace.error(129);
                }
                rootsArray[i] = pointerLookup.getValue(lookupIndex);
            }
            ++i;
        }
        this.setTransactionRowLookups(pointerLookup);
        Trace.printSystemOut(String.valueOf(table.getName().name) + " : table converted");
        return rootsArray;
    }

    void setTransactionRowLookups(DoubleIntIndex pointerLookup) {
        int i = 0;
        int size = this.transactionRowLookup.size();
        while (i < size) {
            int key = this.transactionRowLookup.getKey(i);
            int lookupIndex = pointerLookup.findFirstEqualKeyIndex(key);
            if (lookupIndex != -1) {
                this.transactionRowLookup.setValue(i, pointerLookup.getValue(lookupIndex));
            }
            ++i;
        }
    }

    void writeTransactionRows() {
        int i = 0;
        int size = this.transactionRowLookup.size();
        while (i < size) {
            if (this.transactionRowLookup.getValue(i) == 0) {
                int key = this.transactionRowLookup.getKey(i);
                try {
                    this.transactionRowLookup.setValue(i, (int)(this.fileOffset / (long)this.scale));
                    RowInputInterface rowIn = this.cache.readObject(key);
                    this.fileStreamOut.write(rowIn.getBuffer(), 0, rowIn.getSize());
                    this.fileOffset += (long)rowIn.getSize();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }
}

