/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileNIO;
import org.hsqldb.persist.ScaledRAInterface;

public class ScaledRAFileHybrid
implements ScaledRAInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    final boolean wasNio;
    long maxLength;
    ScaledRAInterface store;

    public ScaledRAFileHybrid(Database database, String name, boolean readOnly) throws IOException {
        this.database = database;
        this.fileName = name;
        this.isReadOnly = readOnly;
        this.newStore(0L);
        this.wasNio = this.store.wasNio();
    }

    public long length() throws IOException {
        return this.store.length();
    }

    public void seek(long position) throws IOException {
        this.checkSeek(position);
        this.store.seek(position);
    }

    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    public int read() throws IOException {
        this.checkLength(1);
        return this.store.read();
    }

    public void read(byte[] b, int offset, int length) throws IOException {
        this.checkLength(length);
        this.store.read(b, offset, length);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.checkLength(length);
        this.store.write(b, offset, length);
    }

    public int readInt() throws IOException {
        this.checkLength(4);
        return this.store.readInt();
    }

    public void writeInt(int i) throws IOException {
        this.checkLength(4);
        this.store.writeInt(i);
    }

    public long readLong() throws IOException {
        this.checkLength(8);
        return this.store.readLong();
    }

    public void writeLong(long i) throws IOException {
        this.checkLength(8);
        this.store.writeLong(i);
    }

    public void close() throws IOException {
        this.store.close();
    }

    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    public boolean wasNio() {
        return this.wasNio;
    }

    public boolean canAccess(int length) {
        return true;
    }

    public boolean canSeek(long position) {
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    private void checkLength(int length) throws IOException {
        if (this.store.canAccess(length)) {
            return;
        }
        this.newStore(this.store.getFilePointer() + (long)length);
    }

    private void checkSeek(long position) throws IOException {
        if (this.store.canSeek(position)) {
            return;
        }
        this.newStore(position);
    }

    void newStore(long requiredPosition) throws IOException {
        long currentPosition = 0L;
        if (this.store != null) {
            currentPosition = this.store.getFilePointer();
            this.store.close();
        }
        if (requiredPosition <= 0x10000000L) {
            try {
                this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, (int)requiredPosition);
                this.store.seek(currentPosition);
                return;
            }
            catch (Throwable throwable) {}
        }
        this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly);
        this.store.seek(currentPosition);
    }
}

