/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.ObjectCacheHashMap;

public class TextCache
extends DataFileCache {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean ignoreFirst;
    protected String header;
    protected Table table;
    private ObjectCacheHashMap uncommittedCache;
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    static final char LF_CHAR = '\n';
    static final char CR_CHAR = '\r';

    TextCache(Table table, String name) throws HsqlException {
        super(table.database, name);
        this.table = table;
        this.uncommittedCache = new ObjectCacheHashMap(5);
    }

    protected void initParams(Database database, String baseFileName) throws HsqlException {
        this.fileName = baseFileName;
        this.database = database;
        this.fa = FileUtil.getDefaultInstance();
        HsqlProperties tableprops = HsqlProperties.delimitedArgPairsToProps(this.fileName, "=", ";", null);
        switch (tableprops.errorCodes.length) {
            case 0: {
                throw Trace.error(75, 172);
            }
            case 1: {
                this.fileName = tableprops.errorKeys[0].trim();
                break;
            }
            default: {
                throw Trace.error(75, 173, tableprops.errorKeys[1]);
            }
        }
        HsqlDatabaseProperties dbProps = database.getProperties();
        this.fs = this.translateSep(tableprops.getProperty("fs", dbProps.getProperty("textdb.fs", ",")));
        this.vs = this.translateSep(tableprops.getProperty("vs", dbProps.getProperty("textdb.vs", this.fs)));
        this.lvs = this.translateSep(tableprops.getProperty("lvs", dbProps.getProperty("textdb.lvs", this.fs)));
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Trace.error(75, 174);
        }
        this.ignoreFirst = tableprops.isPropertyTrue("ignore_first", dbProps.isPropertyTrue("textdb.ignore_first", false));
        this.isQuoted = tableprops.isPropertyTrue("quoted", dbProps.isPropertyTrue("textdb.quoted", true));
        this.isAllQuoted = tableprops.isPropertyTrue("all_quoted", dbProps.isPropertyTrue("textdb.all_quoted", false));
        this.stringEncoding = this.translateSep(tableprops.getProperty("encoding", dbProps.getProperty("textdb.encoding", "ASCII")));
        int cacheScale = tableprops.getIntegerProperty("cache_scale", dbProps.getIntegerProperty("textdb.cache_scale", 10, 8, 16));
        int cacheSizeScale = tableprops.getIntegerProperty("cache_size_scale", dbProps.getIntegerProperty("textdb.cache_size_scale", 10, 8, 20));
        int lookupTableLength = 1 << cacheScale;
        int avgRowBytes = 1 << cacheSizeScale;
        this.maxCacheSize = lookupTableLength * 3;
        this.maxCacheBytes = this.maxCacheSize * avgRowBytes;
        this.maxDataFileSize = Integer.MAX_VALUE;
        this.cachedRowPadding = 1;
        this.cacheFileScale = 1;
    }

    protected void initBuffers() {
        if (this.isQuoted || this.isAllQuoted) {
            this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
            this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
        } else {
            this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
            this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
        }
    }

    private String translateSep(String sep) {
        return this.translateSep(sep, false);
    }

    private String translateSep(String sep, boolean isProperty) {
        if (sep == null) {
            return null;
        }
        int next = 0;
        next = sep.indexOf(92);
        if (next != -1) {
            int start = 0;
            char[] sepArray = sep.toCharArray();
            int ch = 0;
            int len = sep.length();
            StringBuffer realSep = new StringBuffer(len);
            do {
                realSep.append(sepArray, start, next - start);
                start = ++next;
                if (next >= len) {
                    realSep.append('\\');
                    break;
                }
                if (!isProperty) {
                    ch = sepArray[next];
                }
                if (ch == 110) {
                    realSep.append('\n');
                    ++start;
                    continue;
                }
                if (ch == 114) {
                    realSep.append('\r');
                    ++start;
                    continue;
                }
                if (ch == 116) {
                    realSep.append('\t');
                    ++start;
                    continue;
                }
                if (ch == 92) {
                    realSep.append('\\');
                    ++start;
                    continue;
                }
                if (ch == 117) {
                    realSep.append((char)Integer.parseInt(sep.substring(++start, start + 4), 16));
                    start += 4;
                    continue;
                }
                if (sep.startsWith("semi", next)) {
                    realSep.append(';');
                    start += 4;
                    continue;
                }
                if (sep.startsWith("space", next)) {
                    realSep.append(' ');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("quote", next)) {
                    realSep.append('\"');
                    start += 5;
                    continue;
                }
                if (sep.startsWith("apos", next)) {
                    realSep.append('\'');
                    start += 4;
                    continue;
                }
                realSep.append('\\');
                realSep.append(sepArray[next]);
                ++start;
            } while ((next = sep.indexOf(92, start)) != -1);
            realSep.append(sepArray, start, len - start);
            sep = realSep.toString();
        }
        return sep;
    }

    public void open(boolean readonly) throws HsqlException {
        this.fileFreePosition = 0L;
        try {
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.fileName, readonly, 0, null, null);
            this.fileFreePosition = this.dataFile.length();
            if (this.fileFreePosition > Integer.MAX_VALUE) {
                throw new IOException();
            }
            this.initBuffers();
        }
        catch (Exception e) {
            throw Trace.error(29, 188, new Object[]{this.fileName, e});
        }
        this.cacheReadonly = readonly;
    }

    void reopen() throws HsqlException {
        this.open(this.cacheReadonly);
    }

    public void close(boolean write) throws HsqlException {
        if (this.dataFile == null) {
            return;
        }
        try {
            this.cache.saveAll();
            boolean empty = this.dataFile.length() <= (long)NL.length();
            this.dataFile.close();
            this.dataFile = null;
            if (empty && !this.cacheReadonly) {
                FileUtil.delete(this.fileName);
            }
        }
        catch (Exception e) {
            throw Trace.error(29, 189, new Object[]{this.fileName, e});
        }
    }

    void purge() throws HsqlException {
        this.uncommittedCache.clear();
        try {
            if (this.cacheReadonly) {
                this.close(false);
            } else {
                if (this.dataFile != null) {
                    this.dataFile.close();
                    this.dataFile = null;
                }
                FileUtil.delete(this.fileName);
            }
        }
        catch (Exception e) {
            throw Trace.error(29, 190, new Object[]{this.fileName, e});
        }
    }

    public synchronized void remove(int pos, PersistentStore store) throws IOException {
        CachedObject row = (CachedObject)this.uncommittedCache.remove(pos);
        if (row != null) {
            return;
        }
        row = this.cache.release(pos);
        this.clearRowImage(row);
        this.release(pos);
    }

    private void clearRowImage(CachedObject row) throws IOException {
        int length = row.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
        this.rowOut.reset();
        HsqlByteArrayOutputStream out = this.rowOut.getOutputStream();
        out.fill(32, length);
        out.write(ScriptWriterText.BYTES_LINE_SEP);
        this.dataFile.seek(row.getPos());
        this.dataFile.write(out.getBuffer(), 0, out.size());
    }

    public synchronized void removePersistence(int pos, PersistentStore store) throws IOException {
        CachedObject row = (CachedObject)this.uncommittedCache.get(pos);
        if (row != null) {
            return;
        }
        row = this.cache.get(pos);
        this.clearRowImage(row);
    }

    protected synchronized RowInputInterface readObject(int pos) throws IOException {
        ByteArray buffer = new ByteArray(80);
        boolean complete = false;
        boolean wasCR = false;
        boolean hasQuote = false;
        boolean wasNormal = false;
        if ((pos = this.findNextUsedLinePos(pos)) == -1) {
            return null;
        }
        this.dataFile.seek(pos);
        while (!complete) {
            wasNormal = false;
            int c = this.dataFile.read();
            if (c == -1) {
                if (buffer.length() == 0) {
                    return null;
                }
                complete = true;
                if (wasCR || this.cacheReadonly) break;
                this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                break;
            }
            switch (c) {
                case 34: {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                    if (!this.isQuoted) break;
                    hasQuote = !hasQuote;
                    break;
                }
                case 13: {
                    wasCR = !hasQuote;
                    break;
                }
                case 10: {
                    complete = !hasQuote;
                    break;
                }
                default: {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                }
            }
            buffer.append(c);
        }
        if (complete) {
            int length = (int)this.dataFile.getFilePointer() - pos;
            if (wasNormal) {
                --length;
            }
            ((RowInputText)this.rowIn).setSource(buffer.toString(), pos, length);
            return this.rowIn;
        }
        return null;
    }

    public int readHeaderLine() throws HsqlException {
        boolean complete = false;
        boolean wasCR = false;
        boolean wasNormal = false;
        ByteArray buffer = new ByteArray(80);
        while (!complete) {
            int c;
            block11: {
                block12: {
                    wasNormal = false;
                    try {
                        c = this.dataFile.read();
                        if (c != -1) break block11;
                        if (buffer.length() != 0) break block12;
                        return 0;
                    }
                    catch (IOException iOException) {
                        throw Trace.error(76);
                    }
                }
                complete = true;
                if (this.cacheReadonly) break;
                this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
                break;
            }
            switch (c) {
                case 13: {
                    wasCR = true;
                    break;
                }
                case 10: {
                    complete = true;
                    break;
                }
                default: {
                    wasNormal = true;
                    complete = wasCR;
                    wasCR = false;
                }
            }
            buffer.append(c);
        }
        this.header = buffer.toString();
        try {
            int length = (int)this.dataFile.getFilePointer();
            if (wasNormal) {
                --length;
            }
            return length;
        }
        catch (IOException iOException) {
            throw Trace.error(76);
        }
    }

    int findNextUsedLinePos(int pos) throws IOException {
        int firstPos = pos;
        int currentPos = pos;
        boolean wasCR = false;
        this.dataFile.seek(pos);
        block6: while (true) {
            int c = this.dataFile.read();
            ++currentPos;
            switch (c) {
                case 13: {
                    wasCR = true;
                    continue block6;
                }
                case 10: {
                    wasCR = false;
                    ((RowInputText)this.rowIn).skippedLine();
                    firstPos = currentPos;
                    continue block6;
                }
                case 32: {
                    if (!wasCR) continue block6;
                    wasCR = false;
                    ((RowInputText)this.rowIn).skippedLine();
                    continue block6;
                }
                case -1: {
                    return -1;
                }
            }
            break;
        }
        return firstPos;
    }

    public synchronized void add(CachedObject object) throws IOException {
        super.add(object);
        this.clearRowImage(object);
    }

    public synchronized CachedObject get(int i, PersistentStore store, boolean keep) throws HsqlException {
        if (i < 0) {
            return null;
        }
        CachedObject o = (CachedObject)this.uncommittedCache.get(i);
        if (o == null) {
            o = super.get(i, store, keep);
        }
        return o;
    }

    protected synchronized void saveRows(CachedObject[] rows, int offset, int count) throws IOException {
        if (count == 0) {
            return;
        }
        int i = offset;
        while (i < offset + count) {
            CachedObject r = rows[i];
            this.uncommittedCache.put(r.getPos(), r);
            rows[i] = null;
            ++i;
        }
    }

    public synchronized void saveRow(CachedObject row) throws IOException {
        this.uncommittedCache.remove(row.getPos());
        super.saveRow(row);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) throws HsqlException {
        if (this.ignoreFirst && this.fileFreePosition == 0L) {
            try {
                this.writeHeader(header);
                this.header = header;
            }
            catch (IOException e) {
                throw new HsqlException(e, Trace.getMessage(98), 98);
            }
            return;
        }
        throw Trace.error(150);
    }

    private void writeHeader(String header) throws IOException {
        byte[] buf = null;
        String firstLine = String.valueOf(header) + NL;
        try {
            buf = firstLine.getBytes(this.stringEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            buf = firstLine.getBytes();
        }
        this.dataFile.write(buf, 0, buf.length);
        this.fileFreePosition = buf.length;
    }

    public int getLineNumber() {
        return ((RowInputText)this.rowIn).getLineNumber();
    }

    protected void setFileModified() throws IOException {
        this.fileModified = true;
    }

    private class ByteArray {
        private byte[] buffer;
        private int buflen;

        public ByteArray(int n) {
            this.buffer = new byte[n];
            this.buflen = 0;
        }

        public void append(int c) {
            if (this.buflen >= this.buffer.length) {
                byte[] newbuf = new byte[this.buflen + 80];
                System.arraycopy(this.buffer, 0, newbuf, 0, this.buflen);
                this.buffer = newbuf;
            }
            this.buffer[this.buflen] = (byte)c;
            ++this.buflen;
        }

        public int length() {
            return this.buflen;
        }

        public void setLength(int l) {
            this.buflen = l;
        }

        public String toString() {
            try {
                return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(this.buffer, 0, this.buflen);
            }
        }
    }
}

