/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.extendable.DefaultExtendableItem;
import java.util.LinkedHashSet;
import java.util.Set;

public class Configuration
extends DefaultExtendableItem {
    private String _name;
    private String _description;
    private String[] _extends;
    private Visibility _visibility;
    private boolean _transitive = true;

    public Configuration(String name, Visibility visibility, String description, String[] ext) {
        this(name, visibility, description, ext, true);
    }

    public Configuration(String name, Visibility visibility, String description, String[] ext, boolean transitive) {
        if (name == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this._name = name;
        this._visibility = visibility;
        this._description = description;
        if (ext == null) {
            this._extends = new String[0];
        } else {
            this._extends = new String[ext.length];
            for (int i = 0; i < ext.length; ++i) {
                this._extends[i] = ext[i].trim();
            }
        }
        this._transitive = transitive;
    }

    public Configuration(String name) {
        this(name, Visibility.PUBLIC, null, null);
    }

    public String getDescription() {
        return this._description;
    }

    public String[] getExtends() {
        return this._extends;
    }

    public String getName() {
        return this._name;
    }

    public Visibility getVisibility() {
        return this._visibility;
    }

    public final boolean isTransitive() {
        return this._transitive;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return ((Configuration)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void replaceWildcards(ModuleDescriptor md) {
        if (this != md.getConfiguration(this._name)) {
            throw new IllegalArgumentException("The given ModuleDescriptor doesn't own this configuration!");
        }
        Configuration[] configs = md.getConfigurations();
        LinkedHashSet<String> newExtends = new LinkedHashSet<String>();
        for (int j = 0; j < this._extends.length; ++j) {
            if ("*".equals(this._extends[j])) {
                this.addOther(configs, null, newExtends);
                continue;
            }
            if ("*(public)".equals(this._extends[j])) {
                this.addOther(configs, Visibility.PUBLIC, newExtends);
                continue;
            }
            if ("*(private)".equals(this._extends[j])) {
                this.addOther(configs, Visibility.PRIVATE, newExtends);
                continue;
            }
            newExtends.add(this._extends[j]);
        }
        this._extends = newExtends.toArray(new String[newExtends.size()]);
    }

    private void addOther(Configuration[] allConfigs, Visibility visibility, Set configs) {
        for (int i = 0; i < allConfigs.length; ++i) {
            String currentName = allConfigs[i].getName();
            if (this._name.equals(currentName) || visibility != null && !visibility.equals(allConfigs[i].getVisibility())) continue;
            configs.add(currentName);
        }
    }

    public static class Visibility {
        public static Visibility PUBLIC = new Visibility("public");
        public static Visibility PRIVATE = new Visibility("private");
        private String _name;

        public static Visibility getVisibility(String name) {
            if ("private".equals(name)) {
                return PRIVATE;
            }
            if ("public".equals(name)) {
                return PUBLIC;
            }
            throw new IllegalArgumentException("unknwon visibility " + name);
        }

        private Visibility(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

