/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antrun;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AntPropertyHelper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Typedef;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAntMojo
extends AbstractMojo {
    public static final String DEFAULT_MAVEN_PROJECT_REFID = "maven.project";
    public static final String DEFAULT_MAVEN_PROJECT_HELPER_REFID = "maven.project.helper";
    public static final String ANTLIB = "org/apache/maven/ant/tasks/antlib.xml";
    public static final String TASK_URI = "antlib:org.apache.maven.ant.tasks";
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private List pluginArtifacts;
    protected ArtifactRepository localRepository;
    private String propertyPrefix;
    private String taskNamespace;
    private String versionsPropertyName;

    protected void executeTasks(Target antTasks) throws MojoExecutionException {
        MavenProject mavenProject = this.getMavenProject();
        if (antTasks == null) {
            this.getLog().info((CharSequence)"No ant tasks defined - SKIPPED");
            return;
        }
        if (this.propertyPrefix == null) {
            this.propertyPrefix = "";
        }
        try {
            ExpressionEvaluator exprEvaluator = (ExpressionEvaluator)antTasks.getProject().getReference("maven.expressionEvaluator");
            Project antProject = antTasks.getProject();
            PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
            propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(exprEvaluator, mavenProject.getArtifacts(), this.getLog()));
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
            antProject.addBuildListener((BuildListener)antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", (Object)p);
            antProject.addReference("maven.compile.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", (Object)p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
            antProject.addReference("maven.test.classpath", (Object)p);
            antProject.addReference("maven.plugin.classpath", (Object)this.getPathFromArtifacts(this.pluginArtifacts, antProject));
            antProject.addReference(DEFAULT_MAVEN_PROJECT_REFID, (Object)this.getMavenProject());
            antProject.addReference(DEFAULT_MAVEN_PROJECT_HELPER_REFID, (Object)this.projectHelper);
            antProject.addReference("maven.local.repository", (Object)this.localRepository);
            this.initMavenTasks(antProject);
            this.copyProperties(mavenProject, antProject);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Executing tasks");
            }
            antTasks.execute();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Executed tasks");
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (BuildException e) {
            throw new MojoExecutionException("An Ant BuildException has occured: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing ant tasks: " + e.getMessage(), e);
        }
    }

    public Path getPathFromArtifacts(Collection artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }

    public void copyProperties(MavenProject mavenProject, Project antProject) {
        Artifact artifact;
        Properties mavenProps = mavenProject.getProperties();
        Iterator iter = ((Hashtable)mavenProps).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            antProject.setProperty(key, mavenProps.getProperty(key));
        }
        antProject.setProperty("ant.file", mavenProject.getFile().getAbsolutePath());
        System.out.println(this.propertyPrefix + "project.artifactId");
        antProject.setProperty(this.propertyPrefix + "project.groupId", mavenProject.getGroupId());
        antProject.setProperty(this.propertyPrefix + "project.artifactId", mavenProject.getArtifactId());
        antProject.setProperty(this.propertyPrefix + "project.name", mavenProject.getName());
        antProject.setProperty(this.propertyPrefix + "project.description", mavenProject.getDescription());
        antProject.setProperty(this.propertyPrefix + "project.version", mavenProject.getVersion());
        antProject.setProperty(this.propertyPrefix + "project.packaging", mavenProject.getPackaging());
        antProject.setProperty(this.propertyPrefix + "project.build.directory", mavenProject.getBuild().getDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.outputDirectory", mavenProject.getBuild().getOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.outputDirectory", mavenProject.getBuild().getTestOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.sourceDirectory", mavenProject.getBuild().getSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testSourceDirectory", mavenProject.getBuild().getTestSourceDirectory());
        Set depArtifacts = mavenProject.getArtifacts();
        Iterator it = depArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact2 = (Artifact)it.next();
            String propName = artifact2.getDependencyConflictId();
            antProject.setProperty(this.propertyPrefix + propName, artifact2.getFile().getPath());
        }
        StringBuffer versionsBuffer = new StringBuffer();
        Iterator it2 = depArtifacts.iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            versionsBuffer.append(artifact.getVersion() + File.pathSeparator);
        }
        antProject.setProperty(this.versionsPropertyName, versionsBuffer.toString());
        it2 = depArtifacts.iterator();
        while (it2.hasNext()) {
            artifact = (Artifact)it2.next();
            String propName = AntPropertyHelper.getDependencyArtifactPropertyName(artifact);
            antProject.setProperty(propName, artifact.getFile().getPath());
        }
    }

    public MavenProject getMavenProject() {
        return this.project;
    }

    public void initMavenTasks(Project antProject) {
        this.getLog().debug((CharSequence)"Initialize Maven Ant Tasks");
        Typedef typedef = new Typedef();
        typedef.setProject(antProject);
        typedef.setResource(ANTLIB);
        typedef.execute();
    }
}

