/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.PropertyUtils;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.SingleResponseValueSource;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.interpolation.multi.MultiDelimiterInterpolatorFilterReader;
import org.codehaus.plexus.interpolation.multi.MultiDelimiterStringSearchInterpolator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

public class DefaultMavenFileFilter
extends AbstractLogEnabled
implements MavenFileFilter {
    private BuildContext buildContext;

    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List filterWrappers = this.getDefaultFilterWrappers(mre);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    public void copyFile(MavenFileFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        this.copyFile(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.getTo(), mavenFileFilterRequest.isFiltering(), filterWrappers, mavenFileFilterRequest.getEncoding());
    }

    public void copyFile(File from, File to, boolean filtering, List filterWrappers, String encoding) throws MavenFilteringException {
        this.copyFile(from, to, filtering, filterWrappers, encoding, false);
    }

    public void copyFile(File from, File to, boolean filtering, List filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
        try {
            if (filtering) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("filering " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.FilterWrapper[] wrappers = filterWrappers.toArray(new FileUtils.FilterWrapper[filterWrappers.size()]);
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])wrappers);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("copy " + from.getPath() + " to " + to.getPath());
                }
                FileUtils.copyFile((File)from, (File)to, (String)encoding, (FileUtils.FilterWrapper[])new FileUtils.FilterWrapper[0], (boolean)overwrite);
            }
            this.buildContext.refresh(to);
        }
        catch (IOException e) {
            throw new MavenFilteringException(e.getMessage(), e);
        }
    }

    public List getDefaultFilterWrappers(MavenProject mavenProject, List filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession) throws MavenFilteringException {
        return this.getDefaultFilterWrappers(mavenProject, filters, escapedBackslashesInFilePath, mavenSession, null);
    }

    public List getDefaultFilterWrappers(MavenProject mavenProject, List filters, boolean escapedBackslashesInFilePath, MavenSession mavenSession, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        MavenResourcesExecution mre = mavenResourcesExecution == null ? new MavenResourcesExecution() : mavenResourcesExecution.copyOf();
        mre.setMavenProject(mavenProject);
        mre.setMavenSession(mavenSession);
        mre.setFilters(filters);
        mre.setEscapedBackslashesInFilePath(escapedBackslashesInFilePath);
        return this.getDefaultFilterWrappers(mre);
    }

    public List getDefaultFilterWrappers(AbstractMavenFilteringRequest req) throws MavenFilteringException {
        ArrayList<Wrapper> defaultFilterWrappers;
        AbstractMavenFilteringRequest request = req == null ? new MavenFileFilterRequest() : req;
        Properties baseProps = new Properties();
        if (request.getMavenProject() != null) {
            ((Hashtable)baseProps).putAll(request.getMavenProject().getProperties() == null ? Collections.EMPTY_MAP : request.getMavenProject().getProperties());
        }
        if (request.getMavenSession() != null) {
            ((Hashtable)baseProps).putAll(request.getMavenSession().getExecutionProperties());
        }
        Properties filterProperties = new Properties();
        this.loadProperties(filterProperties, request.getFileFilters(), baseProps);
        if (((Hashtable)filterProperties).size() < 1) {
            ((Hashtable)filterProperties).putAll(baseProps);
        }
        if (request.getMavenProject() != null) {
            if (request.isInjectProjectBuildFilters()) {
                List buildFilters = request.getMavenProject().getBuild().getFilters();
                buildFilters.removeAll(request.getFileFilters());
                this.loadProperties(filterProperties, buildFilters, baseProps);
            }
            ((Hashtable)filterProperties).putAll(request.getMavenProject().getProperties() == null ? Collections.EMPTY_MAP : request.getMavenProject().getProperties());
        }
        if (request.getMavenSession() != null) {
            ((Hashtable)filterProperties).putAll(request.getMavenSession().getExecutionProperties());
        }
        if (request.getAdditionalProperties() != null) {
            ((Hashtable)filterProperties).putAll(request.getAdditionalProperties());
        }
        ArrayList<Wrapper> arrayList = defaultFilterWrappers = request == null ? new ArrayList<Wrapper>(1) : new ArrayList(request.getDelimiters().size() + 1);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("properties used " + filterProperties);
        }
        PropertiesBasedValueSource propertiesValueSource = new PropertiesBasedValueSource(filterProperties);
        if (request != null) {
            Wrapper wrapper = new Wrapper(request.getDelimiters(), request.getMavenProject(), request.getMavenSession(), (ValueSource)propertiesValueSource, request.getProjectStartExpressions(), request.getEscapeString(), request.isEscapeWindowsPaths());
            defaultFilterWrappers.add(wrapper);
        }
        return defaultFilterWrappers;
    }

    private void loadProperties(Properties filterProperties, List propertiesFilePaths, Properties baseProps) throws MavenFilteringException {
        if (propertiesFilePaths != null) {
            Iterator iterator = propertiesFilePaths.iterator();
            while (iterator.hasNext()) {
                String filterFile = (String)iterator.next();
                if (StringUtils.isEmpty((String)filterFile)) continue;
                try {
                    Properties properties = PropertyUtils.loadPropertyFile(new File(filterFile), baseProps);
                    ((Hashtable)filterProperties).putAll(properties);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Error loading property file '" + filterFile + "'", e);
                }
            }
        }
    }

    private static final class Wrapper
    extends FileUtils.FilterWrapper {
        private LinkedHashSet delimiters;
        private MavenProject project;
        private ValueSource propertiesValueSource;
        private List projectStartExpressions;
        private String escapeString;
        private boolean escapeWindowsPaths;
        private final MavenSession mavenSession;

        Wrapper(LinkedHashSet delimiters, MavenProject project, MavenSession mavenSession, ValueSource propertiesValueSource, List projectStartExpressions, String escapeString, boolean escapeWindowsPaths) {
            this.delimiters = delimiters;
            this.project = project;
            this.mavenSession = mavenSession;
            this.propertiesValueSource = propertiesValueSource;
            this.projectStartExpressions = projectStartExpressions;
            this.escapeString = escapeString;
            this.escapeWindowsPaths = escapeWindowsPaths;
        }

        public Reader getReader(Reader reader) {
            MultiDelimiterStringSearchInterpolator interpolator = new MultiDelimiterStringSearchInterpolator();
            interpolator.setDelimiterSpecs(this.delimiters);
            Object ri = null;
            ri = this.projectStartExpressions != null && !this.projectStartExpressions.isEmpty() ? new PrefixAwareRecursionInterceptor((Collection)this.projectStartExpressions, true) : new SimpleRecursionInterceptor();
            interpolator.addValueSource(this.propertiesValueSource);
            if (this.project != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource(this.projectStartExpressions, (Object)this.project, true));
            }
            if (this.mavenSession != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("session", (Object)this.mavenSession));
                Settings settings = this.mavenSession.getSettings();
                if (settings != null) {
                    interpolator.addValueSource((ValueSource)new PrefixedObjectValueSource("settings", (Object)settings));
                    interpolator.addValueSource((ValueSource)new SingleResponseValueSource("localRepository", (Object)settings.getLocalRepository()));
                }
            }
            interpolator.setEscapeString(this.escapeString);
            if (this.escapeWindowsPaths) {
                interpolator.addPostProcessor(new InterpolationPostProcessor(){

                    public Object execute(String expression, Object value) {
                        if (value instanceof String) {
                            return FilteringUtils.escapeWindowsPath((String)value);
                        }
                        return value;
                    }
                });
            }
            MultiDelimiterInterpolatorFilterReader filterReader = new MultiDelimiterInterpolatorFilterReader(reader, (Interpolator)interpolator);
            filterReader.setRecursionInterceptor((RecursionInterceptor)ri);
            filterReader.setDelimiterSpecs(this.delimiters);
            filterReader.setInterpolateWithPrefixPattern(false);
            filterReader.setEscapeString(this.escapeString);
            return filterReader;
        }
    }
}

