/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSourceJarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private String[] includes;
    private String[] excludes;
    private boolean useDefaultExcludes;
    protected MavenProject project;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File defaultManifestFile;
    private boolean useDefaultManifestFile;
    private boolean attach;
    protected boolean excludeResources;
    protected boolean includePom;
    private MavenProjectHelper projectHelper;
    protected File outputDirectory;
    protected String finalName;
    protected List reactorProjects;
    private boolean forceCreation;

    public void execute() throws MojoExecutionException {
        this.packageSources(this.project);
    }

    protected abstract String getClassifier();

    protected abstract List getSources(MavenProject var1) throws MojoExecutionException;

    protected abstract List getResources(MavenProject var1) throws MojoExecutionException;

    protected void packageSources(MavenProject p) throws MojoExecutionException {
        if (!"pom".equals(p.getPackaging())) {
            this.packageSources(Arrays.asList(p));
        }
    }

    protected void packageSources(List projects) throws MojoExecutionException {
        if (this.project.getArtifact().getClassifier() != null) {
            this.getLog().warn((CharSequence)("NOT adding sources to artifacts with classifier as Maven only supports one classifier per artifact. Current artifact [" + this.project.getArtifact().getId() + "] has a [" + this.project.getArtifact().getClassifier() + "] classifier."));
            return;
        }
        MavenArchiver archiver = this.createArchiver();
        Iterator i = projects.iterator();
        while (i.hasNext()) {
            MavenProject subProject = this.getProject((MavenProject)i.next());
            if ("pom".equals(subProject.getPackaging())) continue;
            this.archiveProjectContent(subProject, (Archiver)archiver.getArchiver());
        }
        if (!archiver.getArchiver().getFiles().isEmpty()) {
            if (this.useDefaultManifestFile && this.defaultManifestFile.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
                this.archive.setManifestFile(this.defaultManifestFile);
            }
            File outputFile = new File(this.outputDirectory, this.finalName + "-" + this.getClassifier() + this.getExtension());
            try {
                archiver.setOutputFile(outputFile);
                this.archive.setAddMavenDescriptor(false);
                this.archive.setForced(this.forceCreation);
                archiver.createArchive(this.project, this.archive);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)e);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (ManifestException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)((Object)e));
            }
            if (this.attach) {
                this.projectHelper.attachArtifact(this.project, this.getType(), this.getClassifier(), outputFile);
            } else {
                this.getLog().info((CharSequence)"NOT adding java-sources to attached artifacts list.");
            }
        } else {
            this.getLog().info((CharSequence)"No sources in project. Archive not created.");
        }
    }

    protected void archiveProjectContent(MavenProject p, Archiver archiver) throws MojoExecutionException {
        File sourceDirectory;
        if (this.includePom) {
            try {
                archiver.addFile(p.getFile(), p.getFile().getName());
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error adding POM file to target jar file.", (Exception)((Object)e));
            }
        }
        Iterator i = this.getSources(p).iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            sourceDirectory = new File(s);
            if (!sourceDirectory.exists()) continue;
            this.addDirectory(archiver, sourceDirectory, this.getCombinedIncludes(null), this.getCombinedExcludes(null));
        }
        i = this.getResources(p).iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            sourceDirectory = new File(resource.getDirectory());
            if (!sourceDirectory.exists()) continue;
            List resourceIncludes = resource.getIncludes();
            String[] combinedIncludes = this.getCombinedIncludes(resourceIncludes);
            List resourceExcludes = resource.getExcludes();
            String[] combinedExcludes = this.getCombinedExcludes(resourceExcludes);
            String targetPath = resource.getTargetPath();
            if (targetPath != null) {
                if (!targetPath.trim().endsWith("/")) {
                    targetPath = targetPath + "/";
                }
                this.addDirectory(archiver, sourceDirectory, targetPath, combinedIncludes, combinedExcludes);
                continue;
            }
            this.addDirectory(archiver, sourceDirectory, combinedIncludes, combinedExcludes);
        }
    }

    protected MavenArchiver createArchiver() throws MojoExecutionException {
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        if (this.project.getBuild() != null) {
            List resources = this.project.getBuild().getResources();
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
                this.addDirectory((Archiver)archiver.getArchiver(), new File(r.getDirectory()), this.getCombinedIncludes(null), this.getCombinedExcludes(null));
            }
        }
        return archiver;
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            archiver.addDirectory(sourceDirectory, includes, excludes);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", (Exception)((Object)e));
        }
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String prefix, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            archiver.addDirectory(sourceDirectory, prefix, includes, excludes);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", (Exception)((Object)e));
        }
    }

    protected String getExtension() {
        return ".jar";
    }

    protected MavenProject getProject(MavenProject p) {
        if (p.getExecutionProject() != null) {
            return p.getExecutionProject();
        }
        return p;
    }

    protected String getType() {
        return "java-source";
    }

    private String[] getCombinedIncludes(List additionalIncludes) {
        ArrayList<String> combinedIncludes = new ArrayList<String>();
        if (this.includes != null && this.includes.length > 0) {
            combinedIncludes.addAll(Arrays.asList(this.includes));
        }
        if (additionalIncludes != null && additionalIncludes.size() > 0) {
            combinedIncludes.addAll(additionalIncludes);
        }
        if (combinedIncludes.size() == 0) {
            combinedIncludes.addAll(Arrays.asList(DEFAULT_INCLUDES));
        }
        return combinedIncludes.toArray(new String[combinedIncludes.size()]);
    }

    private String[] getCombinedExcludes(List additionalExcludes) {
        ArrayList<String> combinedExcludes = new ArrayList<String>();
        if (this.useDefaultExcludes) {
            combinedExcludes.addAll(FileUtils.getDefaultExcludesAsList());
        }
        if (this.excludes != null && this.excludes.length > 0) {
            combinedExcludes.addAll(Arrays.asList(this.excludes));
        }
        if (additionalExcludes != null && additionalExcludes.size() > 0) {
            combinedExcludes.addAll(additionalExcludes);
        }
        if (combinedExcludes.size() == 0) {
            combinedExcludes.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        }
        return combinedExcludes.toArray(new String[combinedExcludes.size()]);
    }
}

