/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.AbstractSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;

public class StaleSourceScanner
extends AbstractSourceInclusionScanner {
    private final long lastUpdatedWithinMsecs;
    private final Set sourceIncludes;
    private final Set sourceExcludes;

    public StaleSourceScanner() {
        this(0L, Collections.singleton("**/*"), Collections.EMPTY_SET);
    }

    public StaleSourceScanner(long lastUpdatedWithinMsecs) {
        this(lastUpdatedWithinMsecs, Collections.singleton("**/*"), Collections.EMPTY_SET);
    }

    public StaleSourceScanner(long lastUpdatedWithinMsecs, Set sourceIncludes, Set sourceExcludes) {
        this.lastUpdatedWithinMsecs = lastUpdatedWithinMsecs;
        this.sourceIncludes = sourceIncludes;
        this.sourceExcludes = sourceExcludes;
    }

    @Override
    public Set getIncludedSources(File sourceDir, File targetDir) throws InclusionScanException {
        List srcMappings = this.getSourceMappings();
        if (srcMappings.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        String[] potentialIncludes = this.scanForSources(sourceDir, this.sourceIncludes, this.sourceExcludes);
        HashSet<File> matchingSources = new HashSet<File>();
        block0: for (int i = 0; i < potentialIncludes.length; ++i) {
            String path = potentialIncludes[i];
            File sourceFile = new File(sourceDir, path);
            for (SourceMapping mapping : srcMappings) {
                Set targetFiles = mapping.getTargetFiles(targetDir, path);
                for (File targetFile : targetFiles) {
                    if (targetFile.exists() && targetFile.lastModified() + this.lastUpdatedWithinMsecs >= sourceFile.lastModified()) continue;
                    matchingSources.add(sourceFile);
                    continue block0;
                }
            }
        }
        return matchingSources;
    }
}

