/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty = false;
    private boolean[] propertyVersionability;

    DirtyCollectionSearchVisitor(EventSource session, boolean[] propertyVersionability) {
        super(session);
        this.propertyVersionability = propertyVersionability;
    }

    boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            EventSource session = this.getSession();
            PersistentCollection persistentCollection = type.isArrayType() ? session.getPersistenceContext().getCollectionHolder(collection) : (PersistentCollection)collection;
            if (persistentCollection.isDirty()) {
                this.dirty = true;
                return null;
            }
        }
        return null;
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i) {
        return this.propertyVersionability[i] && super.includeEntityProperty(values, i);
    }
}

